/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.format;

import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.renjin.gcc.format.FormatArrayInput;
import org.renjin.gcc.format.FormatInput;
import org.renjin.gcc.format.FormatSpec;

public class Formatter {
    private final String formatString;
    private final List<FormatSpec> conversions = new ArrayList<FormatSpec>();
    private List<ArgumentType> argumentTypes = new ArrayList<ArgumentType>();
    private int currentPos = 0;
    private int currentArgumentIndex = 0;
    private FormatSpec currentSpec;
    private DecimalFormatSymbols dfs;

    public Formatter(String formatString) throws IllegalArgumentException {
        this(Locale.getDefault(), formatString);
    }

    public Formatter(Locale locale, String formatString) throws IllegalArgumentException {
        this.formatString = formatString;
        this.dfs = new DecimalFormatSymbols(locale);
        this.consumeLiteral();
        while (this.currentPos < formatString.length()) {
            this.consumeNextSpec();
            this.consumeLiteral();
        }
    }

    private void consumeLiteral() {
        StringBuilder sb = new StringBuilder();
        block10: while (this.hasMoreChars()) {
            char c2 = this.next();
            if (c2 == '%') {
                this.pushBack();
                break;
            }
            if (c2 == '\\') {
                if (!this.hasMoreChars()) continue;
                c2 = this.next();
                switch (c2) {
                    case 'a': {
                        sb.append('\u0007');
                        continue block10;
                    }
                    case 'b': {
                        sb.append('\b');
                        continue block10;
                    }
                    case 'f': {
                        sb.append('\f');
                        continue block10;
                    }
                    case 'n': {
                        sb.append(System.getProperty("line.separator"));
                        continue block10;
                    }
                    case 'r': {
                        sb.append('\r');
                        continue block10;
                    }
                    case 't': {
                        sb.append('\t');
                        continue block10;
                    }
                    case 'v': {
                        sb.append('\u000b');
                        continue block10;
                    }
                    case '\\': {
                        sb.append('\\');
                        continue block10;
                    }
                }
                sb.append('\\');
                sb.append(c2);
                continue;
            }
            sb.append(c2);
        }
        if (sb.length() != 0) {
            FormatSpec spec = new FormatSpec(this.dfs);
            spec.conversionCharacter = '\u0000';
            spec.literal = sb.toString();
            this.conversions.add(spec);
        }
    }

    private void consumeNextSpec() {
        if (this.consumeIf('%')) {
            this.currentSpec = new FormatSpec(this.dfs);
            this.consumePosition();
            this.consumeFlags();
            this.consumeFieldWidth();
            this.consumePrecision();
            this.consumeSizeFlags();
            this.consumeConversionCharacter();
            if (this.currentSpec.conversionCharacter == '%') {
                FormatSpec spec = new FormatSpec(this.dfs);
                spec.conversionCharacter = '\u0000';
                spec.literal = "%";
                this.conversions.add(spec);
                return;
            }
            if (this.currentSpec.leadingZeros && this.currentSpec.leftJustify) {
                this.currentSpec.leadingZeros = false;
            }
            if (this.currentSpec.precisionSet && this.currentSpec.leadingZeros) {
                switch (this.currentSpec.conversionCharacter) {
                    case 'd': 
                    case 'i': 
                    case 'o': 
                    case 'x': {
                        this.currentSpec.leadingZeros = false;
                    }
                }
            }
            if (this.currentSpec.conversionCharacter == 'u') {
                this.currentSpec.leadingSign = false;
                this.currentSpec.leadingSpace = false;
            }
            if (this.currentSpec.conversionCharacter == 'p') {
                this.currentSpec.fieldWidth = 8;
                this.currentSpec.fieldWidthSet = true;
                this.currentSpec.leadingZeros = true;
            }
            if (!this.currentSpec.positionalSpecification) {
                this.currentSpec.argumentPosition = this.currentArgumentIndex++;
            }
            this.setArgumentType(this.currentSpec.argumentPosition, this.currentSpec.getArgumentType());
            this.conversions.add(this.currentSpec);
        }
    }

    private void setArgumentType(int argumentIndex, ArgumentType argumentType) {
        while (this.argumentTypes.size() < argumentIndex) {
            this.argumentTypes.add(ArgumentType.UNUSED);
        }
        if (argumentIndex == this.argumentTypes.size()) {
            this.argumentTypes.add(argumentType);
        } else {
            this.argumentTypes.set(argumentIndex, argumentType);
        }
    }

    private void consumePosition() {
        int argumentIndex = this.maybeConsumeArgumentIndex();
        if (argumentIndex != -1) {
            this.currentSpec.positionalSpecification = true;
            this.currentSpec.argumentPosition = argumentIndex;
        }
    }

    private void consumeFlags() {
        while (this.hasMoreChars()) {
            char c2 = this.peek();
            if (c2 == '\'') {
                this.currentSpec.thousands = true;
            } else if (c2 == '-') {
                this.currentSpec.leftJustify = true;
                this.currentSpec.leadingZeros = false;
            } else if (c2 == '+') {
                this.currentSpec.leadingSign = true;
                this.currentSpec.leadingSpace = false;
            } else if (c2 == ' ') {
                if (!this.currentSpec.leadingSign) {
                    this.currentSpec.leadingSpace = true;
                }
            } else if (c2 == '#') {
                this.currentSpec.alternateForm = true;
            } else {
                if (c2 != '0') break;
                if (!this.currentSpec.leftJustify) {
                    this.currentSpec.leadingZeros = true;
                }
            }
            ++this.currentPos;
        }
    }

    private void consumeFieldWidth() {
        this.currentSpec.fieldWidth = 0;
        this.currentSpec.fieldWidthSet = false;
        if (this.consumeIf('*')) {
            this.currentSpec.fieldWidthSet = true;
            this.currentSpec.variableFieldWidth = true;
            int fieldWidthArgumentIndex = this.maybeConsumeArgumentIndex();
            this.currentSpec.argumentPositionForFieldWidth = fieldWidthArgumentIndex != -1 ? fieldWidthArgumentIndex : this.currentArgumentIndex++;
            this.setArgumentType(this.currentSpec.argumentPositionForFieldWidth, ArgumentType.INTEGER);
        } else {
            int digitCount = this.peekDigitCount();
            if (digitCount > 0) {
                this.currentSpec.fieldWidth = this.consumeDigits(digitCount);
                this.currentSpec.fieldWidthSet = true;
            }
        }
    }

    private void consumePrecision() {
        if (this.consumeIf('.')) {
            this.currentSpec.precisionSet = true;
            if (this.consumeIf('*')) {
                this.currentSpec.variablePrecision = true;
                int precisionArgumentIndex = this.maybeConsumeArgumentIndex();
                this.currentSpec.argumentPositionForPrecision = precisionArgumentIndex != -1 ? precisionArgumentIndex : this.currentArgumentIndex++;
                this.setArgumentType(this.currentSpec.argumentPositionForPrecision, ArgumentType.INTEGER);
            } else {
                int digitCount = this.peekDigitCount();
                this.currentSpec.precision = digitCount == 0 ? 0 : this.consumeDigits(digitCount);
            }
        }
    }

    private void consumeSizeFlags() {
        if (!this.consumeIf('z')) {
            if (this.consumeIf('h')) {
                this.currentSpec.optionalh = true;
                this.consumeIf('h');
            } else if (this.consumeIf('l')) {
                this.currentSpec.optionall = true;
                this.consumeIf('l');
            } else if (this.consumeIf('L')) {
                this.currentSpec.optionalL = true;
                this.consumeIf('L');
            }
        }
    }

    private void consumeConversionCharacter() {
        this.currentSpec.conversionCharacter = this.next();
    }

    private int maybeConsumeArgumentIndex() {
        int digitCount = this.peekDigitCount();
        if (digitCount > 0 && this.formatString.charAt(this.currentPos + digitCount) == '$') {
            int argumentIndex = this.consumeDigits(digitCount) - 1;
            ++this.currentPos;
            return argumentIndex;
        }
        return -1;
    }

    private int peekDigitCount() {
        int digitCount = 0;
        while (this.currentPos + digitCount < this.formatString.length() && Character.isDigit(this.formatString.charAt(this.currentPos + digitCount))) {
            ++digitCount;
        }
        return digitCount;
    }

    private int consumeDigits(int digitCount) {
        int number2 = Integer.parseInt(this.formatString.substring(this.currentPos, this.currentPos + digitCount));
        this.currentPos += digitCount;
        return number2;
    }

    private boolean hasMoreChars() {
        return this.currentPos < this.formatString.length();
    }

    private char peek() {
        return this.formatString.charAt(this.currentPos);
    }

    private void pushBack() {
        --this.currentPos;
    }

    private char next() {
        return this.formatString.charAt(this.currentPos++);
    }

    private boolean consumeIf(char c2) {
        if (this.formatString.charAt(this.currentPos) == c2) {
            ++this.currentPos;
            return true;
        }
        return false;
    }

    public List<ArgumentType> getArgumentTypes() {
        return this.argumentTypes;
    }

    public ArgumentType getArgumentType(int i) {
        if (i < this.argumentTypes.size()) {
            return this.argumentTypes.get(i);
        }
        return ArgumentType.UNUSED;
    }

    public String format(FormatInput input) {
        StringBuilder result = new StringBuilder();
        for (FormatSpec conversion : this.conversions) {
            result.append(conversion.format(input));
        }
        return result.toString();
    }

    public static String format(String formatString, Object ... arguments) {
        return new Formatter(formatString).format(new FormatArrayInput(arguments));
    }

    public static enum ArgumentType {
        INTEGER,
        DOUBLE,
        POINTER,
        UNUSED,
        LONG,
        STRING;

    }
}

