/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.eval;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.commons.vfs2.FileSystemManager;
import org.renjin.eval.Session;
import org.renjin.primitives.packaging.ClasspathPackageLoader;
import org.renjin.primitives.packaging.PackageLoader;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.util.concurrent.MoreExecutors;
import org.renjin.sexp.Frame;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.HashFrame;
import org.renjin.sexp.Symbol;
import org.renjin.util.FileSystemUtils;

public class SessionBuilder {
    private boolean loadBasePackage = true;
    private List<String> packagesToLoad = Lists.newArrayList();
    private FileSystemManager fileSystemManager;
    private PackageLoader packageLoader;
    private ClassLoader classLoader;
    private ExecutorService executorService = null;
    private Frame globalFrame = new HashFrame();

    @Deprecated
    public SessionBuilder withFileSystemManager(FileSystemManager fsm) {
        return this.setFileSystemManager(fsm);
    }

    public SessionBuilder withoutBasePackage() {
        this.loadBasePackage = false;
        return this;
    }

    public SessionBuilder withDefaultPackages() {
        this.packagesToLoad = Session.DEFAULT_PACKAGES;
        return this;
    }

    public SessionBuilder setFileSystemManager(FileSystemManager fileSystemManager) {
        this.fileSystemManager = fileSystemManager;
        return this;
    }

    public SessionBuilder setPackageLoader(PackageLoader packageLoader) {
        this.packageLoader = packageLoader;
        return this;
    }

    public SessionBuilder setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public SessionBuilder setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public SessionBuilder setGlobalFrame(Frame globalFrame) {
        this.globalFrame = globalFrame;
        return this;
    }

    @Deprecated
    public <T> SessionBuilder bind(Class<T> clazz, T instance) {
        if (clazz.equals(FileSystemManager.class)) {
            this.setFileSystemManager((FileSystemManager)instance);
        } else if (clazz.equals(PackageLoader.class)) {
            this.setPackageLoader((PackageLoader)instance);
        } else if (clazz.equals(ClassLoader.class)) {
            this.setClassLoader((ClassLoader)instance);
        }
        return this;
    }

    public Session build() {
        try {
            if (this.classLoader == null) {
                this.classLoader = this.getClass().getClassLoader();
            }
            if (this.fileSystemManager == null) {
                this.fileSystemManager = FileSystemUtils.getMinimalFileSystemManager(this.classLoader);
            }
            if (this.packageLoader == null) {
                this.packageLoader = new ClasspathPackageLoader(this.classLoader);
            }
            if (this.executorService == null) {
                this.executorService = MoreExecutors.sameThreadExecutor();
            }
            Session session = new Session(this.fileSystemManager, this.classLoader, this.packageLoader, this.executorService, this.globalFrame);
            if (this.loadBasePackage) {
                session.getTopLevelContext().init();
            }
            for (int i = this.packagesToLoad.size() - 1; i >= 0; --i) {
                session.getTopLevelContext().evaluate(FunctionCall.newCall(Symbol.get("library"), Symbol.get(this.packagesToLoad.get(i))));
            }
            return session;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Session buildDefault() {
        return new SessionBuilder().build();
    }
}

