/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.statements;

import java.util.Collections;
import java.util.List;
import org.renjin.compiler.codegen.ConstantBytecode;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.codegen.VariableStorage;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.expressions.EnvironmentVariable;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.LValue;
import org.renjin.compiler.ir.tac.statements.BasicBlockEndingStatement;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.compiler.ir.tac.statements.StatementVisitor;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.Environment;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class ReturnStatement
implements Statement,
BasicBlockEndingStatement {
    private Expression returnValue;
    private List<Symbol> environmentVariableNames = Lists.newArrayList();
    private List<Expression> environmentVariables = Lists.newArrayList();

    public ReturnStatement(Expression returnValue) {
        this.returnValue = returnValue;
    }

    public Expression getReturnValue() {
        return this.returnValue;
    }

    @Override
    public Expression getRHS() {
        return this.returnValue;
    }

    @Override
    public void setRHS(Expression newRHS) {
        this.returnValue = newRHS;
    }

    @Override
    public Iterable<IRLabel> possibleTargets() {
        return Collections.emptySet();
    }

    public void addEnvironmentVariables(Iterable<EnvironmentVariable> variables) {
        for (EnvironmentVariable variable : variables) {
            this.addEnvironmentVariable(variable.getName(), variable);
        }
    }

    public void addEnvironmentVariable(Symbol symbol2, LValue lValue) {
        this.environmentVariableNames.add(symbol2);
        this.environmentVariables.add(lValue);
    }

    @Override
    public int getChildCount() {
        return 1 + this.environmentVariableNames.size();
    }

    @Override
    public Expression childAt(int index) {
        if (index == 0) {
            return this.returnValue;
        }
        return this.environmentVariables.get(index - 1);
    }

    @Override
    public void setChild(int childIndex, Expression child) {
        if (childIndex == 0) {
            this.returnValue = child;
        } else {
            this.environmentVariables.set(childIndex - 1, child);
        }
    }

    @Override
    public void accept(StatementVisitor visitor) {
        visitor.visitReturn(this);
    }

    @Override
    public int emit(EmitContext emitContext, InstructionAdapter mv) {
        for (int i = 0; i < this.environmentVariableNames.size(); ++i) {
            VariableStorage variableStorage = emitContext.getVariableStorage((LValue)this.environmentVariables.get(i));
            if (variableStorage == null) continue;
            mv.load(emitContext.getEnvironmentVarIndex(), Type.getType(Environment.class));
            mv.aconst(this.environmentVariableNames.get(i).getPrintName());
            mv.load(variableStorage.getSlotIndex(), variableStorage.getType());
            emitContext.convert(mv, variableStorage.getType(), Type.getType(SEXP.class));
            if (variableStorage.getType().getSort() != 10) {
                ValueBounds bounds = this.environmentVariables.get(i).getValueBounds();
                if (bounds.isAttributeConstant()) {
                    AttributeMap attributes2 = bounds.getConstantAttributes();
                    if (attributes2 != AttributeMap.EMPTY) {
                        ConstantBytecode.generateAttributes(mv, attributes2);
                    }
                } else {
                    throw new UnsupportedOperationException("Lost attributes");
                }
            }
            mv.invokevirtual(Type.getInternalName(Environment.class), "setVariableUnsafe", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(String.class), Type.getType(SEXP.class)), false);
        }
        this.returnValue.load(emitContext, mv);
        emitContext.writeReturn(mv, this.returnValue.getType());
        return 0;
    }

    @Override
    public boolean isPure() {
        return true;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("return ");
        s.append(this.returnValue);
        for (int i = 0; i < this.environmentVariableNames.size(); ++i) {
            s.append(", ");
            s.append(this.environmentVariableNames.get(i));
            s.append(" = ");
            s.append(this.environmentVariables.get(i));
        }
        return s.toString();
    }
}

