/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.functions;

import org.renjin.compiler.NotCompilableException;
import org.renjin.compiler.ir.exception.InvalidSyntaxException;
import org.renjin.compiler.ir.tac.IRBodyBuilder;
import org.renjin.compiler.ir.tac.InlinedContext;
import org.renjin.compiler.ir.tac.expressions.Constant;
import org.renjin.compiler.ir.tac.expressions.EnvironmentVariable;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.SimpleExpression;
import org.renjin.compiler.ir.tac.expressions.UseMethodCall;
import org.renjin.compiler.ir.tac.functions.FunctionCallTranslator;
import org.renjin.compiler.ir.tac.functions.TranslationContext;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class UseMethodTranslator
extends FunctionCallTranslator {
    @Override
    public Expression translateToExpression(IRBodyBuilder builder, TranslationContext context, Function resolvedFunction, FunctionCall call2) {
        SimpleExpression objectExpr;
        if (!(context instanceof InlinedContext)) {
            throw new InvalidSyntaxException("'UseMethod' used in an inappropriate fashion.");
        }
        InlinedContext inlinedContext = (InlinedContext)context;
        int arity = call2.getArguments().length();
        if (arity < 1) {
            throw new InvalidSyntaxException("There must be a 'generic' argument");
        }
        Object genericSexp = call2.getArgument(0);
        if (!(genericSexp instanceof StringVector) || genericSexp.length() != 1) {
            throw new InvalidSyntaxException("'generic' must be a character string");
        }
        String generic = ((StringVector)genericSexp).getElementAsString(0);
        if (arity == 1) {
            PairList formals2 = inlinedContext.getFormals();
            if (formals2 == Null.INSTANCE) {
                objectExpr = new Constant(Null.INSTANCE);
            } else {
                Symbol formalName = formals2.getTag();
                if (formalName == Symbols.ELLIPSES) {
                    throw new NotCompilableException((SEXP)call2, "UseMethod() not supported when first argument to function is '...'");
                }
                objectExpr = new EnvironmentVariable(formalName);
            }
        } else {
            throw new NotCompilableException(call2);
        }
        this.assertUnaryFunction(call2, inlinedContext.getFormals());
        return new UseMethodCall(builder.getRuntimeState(), call2, generic, objectExpr);
    }

    private void assertUnaryFunction(FunctionCall call2, PairList formals2) {
        PairList second = ((PairList.Node)formals2).getNext();
        if (second == Null.INSTANCE) {
            return;
        }
        PairList.Node secondNode = (PairList.Node)second;
        if (secondNode.getRawTag() != Symbols.ELLIPSES || secondNode.getNext() != Null.INSTANCE) {
            throw new NotCompilableException((SEXP)call2, "UseMethod() not yet supported when more than one argument is present.");
        }
    }

    @Override
    public void addStatement(IRBodyBuilder builder, TranslationContext context, Function resolvedFunction, FunctionCall call2) {
        throw new NotCompilableException(call2);
    }
}

