/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.expressions;

import java.util.Map;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.sexp.SEXP;

public class ReadLoopVector
implements Expression {
    private ValueBounds bounds;

    public ReadLoopVector(ValueBounds bounds) {
        this.bounds = bounds;
    }

    public ReadLoopVector(SEXP elements) {
        this.bounds = ValueBounds.of(elements).withVaryingValues();
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public int load(EmitContext emitContext, InstructionAdapter mv) {
        mv.load(emitContext.getLoopVectorIndex(), Type.getType(SEXP.class));
        return 1;
    }

    @Override
    public Type getType() {
        return Type.getType(SEXP.class);
    }

    @Override
    public ValueBounds updateTypeBounds(Map<Expression, ValueBounds> typeMap) {
        return this.bounds;
    }

    @Override
    public ValueBounds getValueBounds() {
        return this.bounds;
    }

    @Override
    public void setChild(int childIndex, Expression child) {
        throw new IllegalArgumentException("no children");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public Expression childAt(int index) {
        throw new IllegalArgumentException("no children");
    }

    public String toString() {
        return "readLoopVector()";
    }
}

