/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.expressions;

import java.util.Map;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.SimpleExpression;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;

public final class Constant
implements SimpleExpression {
    public static final Constant NULL = new Constant(Null.INSTANCE);
    public static final Constant TRUE = new Constant(Logical.TRUE);
    public static final Constant FALSE = new Constant(Logical.FALSE);
    public static final Constant NA = new Constant(Logical.NA);
    private SEXP value;
    private ValueBounds valueBounds;
    private Type type;

    public Constant(SEXP value) {
        this.value = value;
        this.valueBounds = ValueBounds.of(value);
        this.type = this.valueBounds.storageType();
    }

    public Constant(int value) {
        this(IntVector.valueOf(value));
    }

    public Constant(Logical value) {
        this(LogicalVector.valueOf(value));
    }

    public SEXP getValue() {
        return this.value;
    }

    @Override
    public final int getChildCount() {
        return 0;
    }

    @Override
    public final Expression childAt(int index) {
        throw new IllegalArgumentException();
    }

    @Override
    public final boolean isPure() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int load(EmitContext emitContext, InstructionAdapter mv) {
        if (this.type.equals(Type.INT_TYPE)) {
            mv.iconst(((AtomicVector)this.value).getElementAsInt(0));
            return 1;
        } else if (this.type.equals(Type.DOUBLE_TYPE)) {
            mv.dconst(((AtomicVector)this.value).getElementAsDouble(0));
            return 1;
        } else if (this.type.equals(Type.getType(String.class))) {
            mv.aconst(((AtomicVector)this.value).getElementAsString(0));
            return 1;
        } else {
            if (!this.type.equals(Type.getType(SEXP.class))) throw new UnsupportedOperationException("type: " + this.type);
            if (this.value != Null.INSTANCE) throw new UnsupportedOperationException("const sexp: " + this.value.getClass().getName());
            mv.getstatic(Type.getInternalName(Null.class), "INSTANCE", Type.getDescriptor(Null.class));
        }
        return 1;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public final void setChild(int i, Expression expr) {
        throw new IllegalArgumentException();
    }

    @Override
    public ValueBounds updateTypeBounds(Map<Expression, ValueBounds> typeMap) {
        return this.valueBounds;
    }

    @Override
    public ValueBounds getValueBounds() {
        return this.valueBounds;
    }

    public String toString() {
        return this.value.toString();
    }
}

