/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.ssa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.renjin.compiler.TypeSolver;
import org.renjin.compiler.cfg.BasicBlock;
import org.renjin.compiler.cfg.CfgPredicates;
import org.renjin.compiler.cfg.ControlFlowGraph;
import org.renjin.compiler.cfg.DominanceTree;
import org.renjin.compiler.cfg.FlowEdge;
import org.renjin.compiler.ir.ssa.PhiFunction;
import org.renjin.compiler.ir.ssa.SsaVariable;
import org.renjin.compiler.ir.tac.TreeNode;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.LValue;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.compiler.ir.tac.statements.Assignment;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.repackaged.guava.collect.Iterables;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.repackaged.guava.collect.Sets;

public class SsaTransformer {
    private ControlFlowGraph cfg;
    private DominanceTree dtree;
    private Map<Variable, Integer> C = Maps.newHashMap();
    private Map<Variable, Stack<Integer>> S = Maps.newHashMap();
    private Set<Variable> allVariables;

    public SsaTransformer(ControlFlowGraph cfg, DominanceTree dtree) {
        this.cfg = cfg;
        this.dtree = dtree;
        this.allVariables = this.allVariables();
    }

    public void transform() {
        this.insertPhiFunctions();
        this.renameVariables();
    }

    private void insertPhiFunctions() {
        int iterCount = 0;
        HashMap<BasicBlock, Integer> hasAlready = Maps.newHashMap();
        HashMap<BasicBlock, Integer> work = Maps.newHashMap();
        for (BasicBlock X : this.cfg.getLiveBasicBlocks()) {
            hasAlready.put(X, 0);
            work.put(X, 0);
        }
        LinkedList<BasicBlock> W = Lists.newLinkedList();
        for (Variable V : this.allVariables) {
            ++iterCount;
            for (BasicBlock X : Iterables.filter(this.cfg.getLiveBasicBlocks(), CfgPredicates.containsAssignmentTo(V))) {
                work.put(X, iterCount);
                W.add(X);
            }
            while (!W.isEmpty()) {
                BasicBlock X = (BasicBlock)W.poll();
                for (BasicBlock Y : this.dtree.getFrontier(X)) {
                    if (X == this.cfg.getExit() || (Integer)hasAlready.get(Y) >= iterCount) continue;
                    Y.insertPhiFunction(V, Y.getIncoming());
                    hasAlready.put(Y, iterCount);
                    if ((Integer)work.get(Y) >= iterCount) continue;
                    work.put(Y, iterCount);
                    W.add(Y);
                }
            }
        }
    }

    private void renameVariables() {
        for (Variable V : this.allVariables) {
            this.C.put(V, 1);
            Stack<Integer> stack = new Stack<Integer>();
            stack.push(0);
            this.S.put(V, stack);
        }
        this.search(this.cfg.getEntry());
    }

    private Set<Variable> allVariables() {
        HashSet<Variable> set2 = Sets.newHashSet();
        for (BasicBlock bb : this.cfg.getBasicBlocks()) {
            for (Statement statement : bb.getStatements()) {
                this.collectVariables(set2, statement.getRHS());
                if (!(statement instanceof Assignment)) continue;
                this.collectVariables(set2, ((Assignment)statement).getLHS());
            }
        }
        return set2;
    }

    private void search(BasicBlock X) {
        for (Statement stmt : X.getStatements()) {
            Assignment assignment;
            this.renameVariables(stmt);
            if (!(stmt instanceof Assignment) || !((assignment = (Assignment)stmt).getLHS() instanceof Variable)) continue;
            Variable V = (Variable)assignment.getLHS();
            int i = this.C.get(V);
            assignment.setLHS(V.getVersion(i));
            this.S.get(V).push(i);
            this.C.put(V, i + 1);
        }
        for (BasicBlock Y : this.cfg.getSuccessors(X)) {
            int j = this.whichPred(Y, X);
            for (Assignment A : Lists.newArrayList(Y.phiAssignments())) {
                PhiFunction rhs = (PhiFunction)A.getRHS();
                Variable V = rhs.getArgument(j);
                int i = this.Top(V);
                rhs.setVersionNumber(j, i);
            }
        }
        for (BasicBlock Y : this.dtree.getChildren(X)) {
            this.search(Y);
        }
        for (Assignment A : X.assignments()) {
            if (!(A.getLHS() instanceof SsaVariable)) continue;
            SsaVariable lhs = (SsaVariable)A.getLHS();
            this.S.get(lhs.getInner()).pop();
        }
    }

    private void renameVariables(TreeNode node) {
        if (node instanceof PhiFunction) {
            return;
        }
        for (int childIndex = 0; childIndex != node.getChildCount(); ++childIndex) {
            Expression child = node.childAt(childIndex);
            if (child instanceof Variable) {
                Variable V = (Variable)child;
                int i = this.Top(V);
                node.setChild(childIndex, V.getVersion(i));
                continue;
            }
            if (child.getChildCount() <= 0) continue;
            this.renameVariables(child);
        }
    }

    private void collectVariables(Set<Variable> set2, Expression rhs) {
        if (rhs instanceof Variable) {
            set2.add((Variable)rhs);
        } else {
            for (int i = 0; i != rhs.getChildCount(); ++i) {
                this.collectVariables(set2, rhs.childAt(i));
            }
        }
    }

    private int Top(Variable V) {
        Stack<Integer> stack = this.S.get(V);
        if (stack.isEmpty()) {
            throw new IllegalStateException("Variable " + V + " has not been assigned to before its use");
        }
        return stack.peek();
    }

    private int whichPred(BasicBlock X, BasicBlock Y) {
        int j = 0;
        for (FlowEdge P : X.getIncoming()) {
            if (P.getPredecessor().equals(Y)) {
                return j;
            }
            ++j;
        }
        throw new IllegalArgumentException("X is not a predecessor of Y");
    }

    public void removePhiFunctions(TypeSolver types) {
        for (BasicBlock bb : this.cfg.getBasicBlocks()) {
            if (bb == this.cfg.getExit()) continue;
            ArrayList<Assignment> phiAssignments = new ArrayList<Assignment>();
            ListIterator<Statement> it = bb.getStatements().listIterator();
            while (it.hasNext()) {
                Statement statement = it.next();
                if (!(statement instanceof Assignment) || !(statement.getRHS() instanceof PhiFunction)) continue;
                phiAssignments.add((Assignment)statement);
                it.remove();
            }
            for (Assignment assignment : phiAssignments) {
                if (!types.isUsed(assignment)) continue;
                this.insertAssignments(assignment.getLHS(), (PhiFunction)assignment.getRHS());
            }
        }
    }

    private void insertAssignments(LValue lhs, PhiFunction phi) {
        for (int i = 0; i < phi.getArguments().size(); ++i) {
            SsaVariable variable = (SsaVariable)phi.getArgument(i);
            if (variable.getVersion() == 0) {
                this.cfg.getEntry().addStatement(new Assignment(lhs, variable));
                continue;
            }
            FlowEdge incoming = phi.getIncomingEdges().get(i);
            BasicBlock definingBlock = incoming.getPredecessor();
            definingBlock.addStatementBeforeJump(new Assignment(lhs, variable));
        }
    }
}

