/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.renjin.compiler.ir.TypeSet;
import org.renjin.primitives.sequence.IntSequence;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.guava.base.Preconditions;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.RawVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class ValueBounds {
    public static final int UNKNOWN_LENGTH = -1;
    public static final int SCALAR_LENGTH = 1;
    public static final int MAY_HAVE_NA = 0;
    public static final int NO_NA = 1;
    public static final ValueBounds UNBOUNDED = new Builder().build();
    public static final ValueBounds INT_PRIMITIVE = ValueBounds.primitive(16);
    public static final ValueBounds DOUBLE_PRIMITIVE = ValueBounds.primitive(32);
    public static final ValueBounds LOGICAL_PRIMITIVE = ValueBounds.primitive(8);
    private int length = -1;
    private int na = 0;
    private int typeSet = 8190;
    private SEXP constantValue = null;
    private boolean attributesOpen = true;
    private Map<Symbol, SEXP> attributes;

    private ValueBounds() {
    }

    private ValueBounds(ValueBounds toCopy) {
        assert (toCopy.attributes != null);
        this.length = toCopy.length;
        this.typeSet = toCopy.typeSet;
        this.na = toCopy.na;
        this.constantValue = toCopy.constantValue;
        this.attributes = toCopy.attributes;
        this.attributesOpen = toCopy.attributesOpen;
    }

    public static ValueBounds primitive(int type) {
        ValueBounds valueBounds = new ValueBounds();
        valueBounds.typeSet = type;
        valueBounds.length = 1;
        valueBounds.attributes = Collections.emptyMap();
        valueBounds.attributesOpen = false;
        valueBounds.na = 1;
        return valueBounds;
    }

    public static ValueBounds of(SEXP value) {
        ValueBounds valueBounds = new ValueBounds();
        valueBounds.na = ValueBounds.hasAnyNAs(value);
        valueBounds.constantValue = value;
        valueBounds.typeSet = TypeSet.of(value);
        valueBounds.length = value.length();
        valueBounds.attributes = value.getAttributes().toMap();
        valueBounds.attributesOpen = false;
        return valueBounds;
    }

    private static int hasAnyNAs(SEXP value) {
        if (value instanceof AtomicVector && ((AtomicVector)value).containsNA()) {
            return 0;
        }
        return 1;
    }

    public ValueBounds of(Object value) {
        if (value instanceof SEXP) {
            return ValueBounds.of((SEXP)value);
        }
        if (value instanceof Integer) {
            return ValueBounds.of(IntVector.valueOf((Integer)value));
        }
        if (value instanceof Double) {
            return ValueBounds.of(DoubleVector.valueOf((Double)value));
        }
        throw new UnsupportedOperationException("value: " + value);
    }

    public static ValueBounds of(Class returnType) {
        ValueBounds valueBounds = new ValueBounds();
        valueBounds.attributesOpen = true;
        valueBounds.attributes = Collections.emptyMap();
        valueBounds.typeSet = TypeSet.of(returnType);
        valueBounds.length = returnType.isPrimitive() ? 1 : -1;
        return valueBounds;
    }

    public boolean isConstant() {
        return this.constantValue != null;
    }

    public boolean isConstant(Symbol symbol2) {
        return this.constantValue == symbol2;
    }

    public boolean isLengthConstant() {
        return this.length != -1;
    }

    public boolean isAttributeConstant(Symbol name) {
        if (this.attributesOpen) {
            return this.attributes.get(name) != null;
        }
        if (!this.attributes.containsKey(name)) {
            return true;
        }
        return this.attributes.get(name) != null;
    }

    public boolean isAttributeDefinitelyNull(Symbol name) {
        return this.getAttributeIfConstant(name) == Null.INSTANCE;
    }

    public SEXP getAttributeIfConstant(Symbol name) {
        if (this.attributesOpen) {
            return this.attributes.get(name);
        }
        if (!this.attributes.containsKey(name)) {
            return Null.INSTANCE;
        }
        return this.attributes.get(name);
    }

    public boolean isClassAttributeConstant() {
        return this.isAttributeConstant(Symbols.CLASS);
    }

    public boolean isDimAttributeConstant() {
        return this.isAttributeConstant(Symbols.DIM);
    }

    public boolean isDimCountConstant() {
        return this.isDimAttributeConstant();
    }

    public boolean isAttributeConstant() {
        return !this.attributesOpen && !this.attributes.containsValue(null);
    }

    public boolean attributeCouldBePresent(Symbol attributeName) {
        SEXP bounds = this.attributes.get(attributeName);
        if (bounds == Null.INSTANCE) {
            return false;
        }
        if (this.attributesOpen) {
            return true;
        }
        return this.attributes.containsKey(attributeName);
    }

    public AtomicVector getConstantClassAttribute() {
        return (AtomicVector)this.getAttributeIfConstant(Symbols.CLASS);
    }

    public AtomicVector getConstantDimAttribute() {
        return (AtomicVector)this.getAttributeIfConstant(Symbols.DIM);
    }

    public int getConstantDimCount() {
        return this.getConstantDimAttribute().length();
    }

    public Map<Symbol, SEXP> getAttributeBounds() {
        return this.attributes;
    }

    public boolean isAttributeSetOpen() {
        return this.attributesOpen;
    }

    public ValueBounds getElementBounds() {
        if (this.constantValue instanceof ListVector) {
            ListVector constantList = (ListVector)this.constantValue;
            ArrayList<ValueBounds> elementBounds = new ArrayList<ValueBounds>();
            for (int i = 0; i < constantList.length(); ++i) {
                elementBounds.add(ValueBounds.of(constantList.getElementAsSEXP(i)));
            }
            return ValueBounds.union(elementBounds);
        }
        if (TypeSet.isDefinitelyAtomic(this.typeSet)) {
            return ValueBounds.primitive(this.typeSet);
        }
        return UNBOUNDED;
    }

    public AttributeMap getConstantAttributes() {
        if (this.attributesOpen) {
            throw new IllegalArgumentException("attribute set is not closed");
        }
        AttributeMap.Builder attributeMap = AttributeMap.builder();
        for (Map.Entry<Symbol, SEXP> entry : this.attributes.entrySet()) {
            assert (entry.getValue() != null);
            attributeMap.set(entry.getKey(), entry.getValue());
        }
        return attributeMap.build();
    }

    public int getTypeSet() {
        return this.typeSet;
    }

    public int getNA() {
        return this.na;
    }

    public boolean maybeNA() {
        return this.na == 0;
    }

    public int getLength() {
        return this.length;
    }

    public ValueBounds union(ValueBounds other) {
        ValueBounds u = new ValueBounds();
        u.typeSet = this.typeSet | other.typeSet;
        u.length = ValueBounds.unionLengths(this.length, other.length);
        u.na = this.na & other.na;
        boolean bl = u.attributesOpen = this.attributesOpen || other.attributesOpen;
        if (this.attributes == other.attributes) {
            Preconditions.checkNotNull(this.attributes, "attributes");
            u.attributes = this.attributes;
        } else if (this.attributes.isEmpty() && other.attributes.isEmpty()) {
            u.attributes = Collections.emptyMap();
        } else {
            u.attributes = new HashMap<Symbol, SEXP>();
            Sets.SetView<Symbol> attributeNames = Sets.union(this.attributes.keySet(), other.attributes.keySet());
            for (Symbol attributeName : attributeNames) {
                SEXP thisValue = this.attributes.get(attributeName);
                SEXP otherValue = other.attributes.get(attributeName);
                u.attributes.put(attributeName, this.unionConstant(thisValue, otherValue));
            }
        }
        return u;
    }

    private static int unionLengths(int x, int y) {
        if (x == y) {
            return x;
        }
        return -1;
    }

    private <T> T unionConstant(T x, T y) {
        if (x == null || y == null) {
            return null;
        }
        if (x.equals(y)) {
            return x;
        }
        return null;
    }

    public static ValueBounds union(Iterable<ValueBounds> bounds) {
        Iterator<ValueBounds> it = bounds.iterator();
        Preconditions.checkArgument(it.hasNext());
        ValueBounds union = it.next();
        while (it.hasNext()) {
            union = union.union(it.next());
        }
        return union;
    }

    public Type storageType() {
        if (this.typeSet == 32) {
            if (this.length == 1) {
                return Type.DOUBLE_TYPE;
            }
            return Type.getType(DoubleVector.class);
        }
        if (this.typeSet == 16 || this.typeSet == 8) {
            if (this.length == 1) {
                return Type.INT_TYPE;
            }
            return Type.getType(IntVector.class);
        }
        if (this.typeSet == 256) {
            if (this.length == 1) {
                return Type.BYTE_TYPE;
            }
            return Type.getType(RawVector.class);
        }
        if (this.typeSet == 64) {
            if (this.length == 1) {
                return Type.getType(String.class);
            }
            return Type.getType(StringVector.class);
        }
        return Type.getType(SEXP.class);
    }

    public String toString() {
        if (this.isConstant()) {
            return "[const " + this.formatConstant(this.constantValue) + "]";
        }
        if (this.typeSet == 8190 && this.length == -1) {
            return "[*]";
        }
        StringBuilder s = new StringBuilder();
        s.append("[");
        s.append(TypeSet.toString(this.typeSet));
        s.append(", len=");
        if (this.length == -1) {
            s.append("*");
        } else {
            s.append(this.length);
        }
        if (this.na == 0) {
            s.append(", ?NA");
        }
        for (Map.Entry<Symbol, SEXP> attribute : this.attributes.entrySet()) {
            s.append(", ").append(attribute.getKey().getPrintName()).append("=");
            if (attribute.getValue() == null) {
                s.append("?");
                continue;
            }
            if (attribute.getValue() == Null.INSTANCE) {
                s.append("\u2205");
                continue;
            }
            s.append("{").append(attribute.getValue()).append("}");
        }
        if (this.attributesOpen) {
            s.append(", ...=?");
        }
        s.append("]");
        return s.toString();
    }

    private String formatConstant(SEXP constantValue) {
        StringBuilder s = new StringBuilder(this.formatConstantValue(constantValue));
        AttributeMap attributes2 = constantValue.getAttributes();
        this.appendAttributesTo(s, attributes2);
        return s.toString();
    }

    private void appendAttributesTo(StringBuilder s, AttributeMap attributes2) {
        if (attributes2 != AttributeMap.EMPTY) {
            for (PairList.Node node : attributes2.nodes()) {
                s.append(", ").append(node.getTag().getPrintName()).append("=").append(this.formatConstant(node.getValue()));
            }
        }
    }

    private String formatConstantValue(SEXP constantValue) {
        IntSequence seq;
        if (constantValue.length() == 1) {
            if (constantValue instanceof IntVector) {
                return ((IntVector)constantValue).getElementAsInt(0) + "L";
            }
            if (constantValue instanceof DoubleVector) {
                return Double.toString(((DoubleVector)constantValue).getElementAsDouble(0));
            }
        }
        if (constantValue instanceof IntSequence && (seq = (IntSequence)constantValue).getBy() == 1) {
            return seq.getFrom() + ":" + (seq.getFrom() + seq.getLength());
        }
        return constantValue.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueBounds that = (ValueBounds)o;
        return this.length == that.length && this.typeSet == that.typeSet && this.attributesOpen == that.attributesOpen && this.na == that.na && Objects.equals(this.constantValue, that.constantValue) && Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        int result = this.length;
        result = 31 * result + this.typeSet;
        return result;
    }

    public SEXP getConstantValue() {
        return this.constantValue;
    }

    public static boolean allConstant(Iterable<ValueBounds> argumentTypes) {
        for (ValueBounds argumentType : argumentTypes) {
            if (argumentType.isConstant()) continue;
            return false;
        }
        return true;
    }

    public ValueBounds withVaryingValues() {
        ValueBounds bounds = new ValueBounds();
        bounds.length = this.length;
        bounds.typeSet = this.typeSet;
        bounds.attributes = this.attributes;
        bounds.attributesOpen = this.attributesOpen;
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ValueBounds bounds;

        public Builder() {
            this.bounds = new ValueBounds();
        }

        public Builder(ValueBounds bounds) {
            this.bounds = new ValueBounds(bounds);
        }

        public Builder setLength(int length2) {
            this.bounds.length = length2;
            return this;
        }

        public Builder setTypeSet(int typeSet) {
            this.bounds.typeSet = typeSet;
            return this;
        }

        public Builder setNA(int na2) {
            this.bounds.na = na2;
            return this;
        }

        public Builder setType(Class type) {
            return this.setTypeSet(TypeSet.of(type));
        }

        public Builder setEmptyAttributes() {
            this.bounds.attributes = Collections.emptyMap();
            this.bounds.attributesOpen = false;
            return this;
        }

        public void setAttributeBounds(Map<Symbol, SEXP> attributes2) {
            this.bounds.attributes = attributes2;
        }

        public void setAttributeSetOpen(boolean open2) {
            this.bounds.attributesOpen = open2;
        }

        public void setClosedAttributes(Map<Symbol, SEXP> attributes2) {
            this.bounds.attributes = attributes2;
            this.bounds.attributesOpen = false;
        }

        public void setAttribute(Symbol name, SEXP value) {
            if (this.bounds.attributes == null) {
                this.bounds.attributes = new HashMap();
            }
            this.bounds.attributes.put(name, value);
        }

        public void attributeCouldBePresent(Symbol attributeName) {
            this.setAttribute(attributeName, null);
        }

        public void setDimAttribute(AtomicVector value) {
            this.setAttribute(Symbols.DIM, value);
        }

        public ValueBounds build() {
            if (this.bounds.attributes == null) {
                this.bounds.attributes = Collections.emptyMap();
            }
            return this.bounds;
        }
    }
}

