/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.builtins;

import java.util.List;
import org.renjin.compiler.builtins.Specialization;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.ir.TypeSet;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbols;

public class GetAtomicElement
implements Specialization {
    private final ValueBounds resultBounds;
    private final Type type;

    public static boolean accept(ValueBounds source, ValueBounds subscript) {
        if (!TypeSet.isDefinitelyAtomic(source.getTypeSet())) {
            return false;
        }
        if (subscript.getLength() != 1) {
            return false;
        }
        return !subscript.maybeNA();
    }

    public GetAtomicElement(ValueBounds source, ValueBounds subscript) {
        assert (GetAtomicElement.accept(source, subscript));
        ValueBounds.Builder resultBounds = new ValueBounds.Builder();
        resultBounds.setTypeSet(TypeSet.elementOf(source.getTypeSet()));
        resultBounds.setNA(source.getNA());
        resultBounds.setAttributeSetOpen(false);
        resultBounds.setLength(1);
        SEXP resultNames = this.namesBounds(source);
        if (resultNames != Null.INSTANCE) {
            resultBounds.setAttribute(Symbols.NAMES, null);
        }
        this.resultBounds = resultBounds.build();
        this.type = this.resultBounds.storageType();
    }

    private SEXP namesBounds(ValueBounds source) {
        SEXP names2 = source.getAttributeIfConstant(Symbols.NAMES);
        SEXP dimnames2 = source.getAttributeIfConstant(Symbols.DIMNAMES);
        if (names2 == Null.INSTANCE && dimnames2 == Null.INSTANCE) {
            return Null.INSTANCE;
        }
        SEXP dim2 = source.getAttributeIfConstant(Symbols.DIM);
        if (dim2 != null && (dim2.length() == 1 ? dimnames2 == Null.INSTANCE : names2 == Null.INSTANCE)) {
            return Null.INSTANCE;
        }
        return null;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public ValueBounds getResultBounds() {
        return this.resultBounds;
    }

    @Override
    public void load(EmitContext emitContext, InstructionAdapter mv, List<IRArgument> arguments) {
        Expression sourceArgument = arguments.get(0).getExpression();
        sourceArgument.load(emitContext, mv);
        emitContext.convert(mv, sourceArgument.getType(), Type.getType(AtomicVector.class));
        Expression indexArgument = arguments.get(0).getExpression();
        indexArgument.load(emitContext, mv);
        emitContext.convert(mv, indexArgument.getType(), Type.INT_TYPE);
        switch (this.resultBounds.getTypeSet()) {
            case 16: {
                mv.invokeinterface(Type.getInternalName(AtomicVector.class), "getElementAsInt", Type.getMethodDescriptor(Type.INT_TYPE, Type.INT_TYPE));
                break;
            }
            case 32: {
                mv.invokeinterface(Type.getInternalName(AtomicVector.class), "getElementAsDouble", Type.getMethodDescriptor(Type.DOUBLE_TYPE, Type.INT_TYPE));
                break;
            }
            default: {
                throw new UnsupportedOperationException("type: " + TypeSet.toString(this.resultBounds.getTypeSet()));
            }
        }
    }

    @Override
    public boolean isPure() {
        return true;
    }
}

