/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.builtins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.renjin.compiler.builtins.ConstantCall;
import org.renjin.compiler.builtins.DataParallelScalarCall;
import org.renjin.compiler.builtins.DoubleBinaryOp;
import org.renjin.compiler.builtins.FailedToSpecializeException;
import org.renjin.compiler.builtins.Specialization;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.invoke.model.JvmMethod;
import org.renjin.primitives.Primitives;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class DataParallelCall
implements Specialization {
    private final String name;
    private final JvmMethod method;
    private List<ValueBounds> argumentBounds;
    private final ValueBounds resultBounds;
    private final Type type;

    public DataParallelCall(Primitives.Entry primitive2, JvmMethod method, List<ValueBounds> argumentBounds) {
        this.name = primitive2.name;
        this.method = method;
        this.argumentBounds = argumentBounds;
        this.resultBounds = this.computeBounds(argumentBounds);
        this.type = this.resultBounds.storageType();
    }

    private ValueBounds computeBounds(List<ValueBounds> argumentBounds) {
        List<ValueBounds> recycledArguments = this.recycledArgumentBounds(argumentBounds);
        int resultLength = this.computeResultLength(this.argumentBounds);
        ValueBounds.Builder bounds = new ValueBounds.Builder();
        bounds.setType(this.method.getReturnType());
        bounds.setNA(this.anyNAs(argumentBounds));
        bounds.setLength(resultLength);
        switch (this.method.getPreserveAttributesStyle()) {
            case NONE: {
                bounds.setEmptyAttributes();
                break;
            }
            case STRUCTURAL: {
                this.buildStructuralBounds(bounds, recycledArguments, resultLength);
                break;
            }
            case ALL: {
                this.buildAllBounds(bounds, recycledArguments, resultLength);
            }
        }
        return bounds.build();
    }

    private int anyNAs(List<ValueBounds> argumentBounds) {
        for (ValueBounds argumentBound : argumentBounds) {
            if (argumentBound.getNA() != 0) continue;
            return 0;
        }
        return 1;
    }

    private List<ValueBounds> recycledArgumentBounds(List<ValueBounds> argumentBounds) {
        ArrayList<ValueBounds> list2 = Lists.newArrayList();
        Iterator<ValueBounds> argumentIt = argumentBounds.iterator();
        for (JvmMethod.Argument formal : this.method.getFormals()) {
            if (!formal.isRecycle()) continue;
            list2.add(argumentIt.next());
        }
        return list2;
    }

    private int computeResultLength(List<ValueBounds> argumentBounds) {
        Iterator<ValueBounds> it = argumentBounds.iterator();
        int resultLength = 0;
        while (it.hasNext()) {
            int argumentLength = it.next().getLength();
            if (argumentLength == -1) {
                return -1;
            }
            if (argumentLength == 0) {
                return 0;
            }
            resultLength = Math.max(resultLength, argumentLength);
        }
        return resultLength;
    }

    private void buildStructuralBounds(ValueBounds.Builder bounds, List<ValueBounds> argumentBounds, int resultLength) {
        HashMap<Symbol, SEXP> attributes2 = new HashMap<Symbol, SEXP>();
        attributes2.put(Symbols.DIM, this.combineAttribute(Symbols.DIM, argumentBounds, resultLength));
        attributes2.put(Symbols.DIMNAMES, this.combineAttribute(Symbols.DIM, argumentBounds, resultLength));
        attributes2.put(Symbols.NAMES, this.combineAttribute(Symbols.DIM, argumentBounds, resultLength));
        bounds.setClosedAttributes(attributes2);
    }

    private SEXP combineAttribute(Symbol symbol2, List<ValueBounds> argumentBounds, int resultLength) {
        if (resultLength == -1 && argumentBounds.size() > 1) {
            return null;
        }
        for (ValueBounds argumentBound : argumentBounds) {
            SEXP value;
            if (argumentBound.getLength() != resultLength || (value = argumentBound.getAttributeIfConstant(symbol2)) == Null.INSTANCE) continue;
            return value;
        }
        return Null.INSTANCE;
    }

    private void buildAllBounds(ValueBounds.Builder bounds, List<ValueBounds> argumentBounds, int resultLength) {
        if (resultLength == -1 && argumentBounds.size() > 1) {
            return;
        }
        HashMap<Symbol, SEXP> attributes2 = new HashMap<Symbol, SEXP>();
        boolean open2 = false;
        for (ValueBounds argumentBound : argumentBounds) {
            if (argumentBound.getLength() != resultLength) continue;
            if (argumentBound.isAttributeSetOpen()) {
                open2 = true;
            }
            for (Map.Entry<Symbol, SEXP> entry : argumentBound.getAttributeBounds().entrySet()) {
                if (attributes2.containsKey(entry.getKey())) continue;
                attributes2.put(entry.getKey(), entry.getValue());
            }
        }
        bounds.setAttributeBounds(attributes2);
        bounds.setAttributeSetOpen(open2);
    }

    public Specialization specializeFurther() {
        if (this.resultBounds.getLength() == 1) {
            if (ValueBounds.allConstant(this.argumentBounds)) {
                return this.evaluateConstant();
            }
            DoubleBinaryOp op = DoubleBinaryOp.trySpecialize(this.name, this.method, this.resultBounds);
            if (op != null) {
                return op;
            }
            if (this.resultBounds.getNA() == 1) {
                return new DataParallelScalarCall(this.method, this.argumentBounds, this.resultBounds).trySpecializeFurther();
            }
        }
        return this;
    }

    private Specialization evaluateConstant() {
        Object constantValue;
        assert (!this.method.acceptsArgumentList());
        List<JvmMethod.Argument> formals2 = this.method.getAllArguments();
        Object[] args2 = new Object[formals2.size()];
        Iterator<ValueBounds> it = this.argumentBounds.iterator();
        int argIndex = 0;
        for (JvmMethod.Argument formal : formals2) {
            if (formal.isContextual()) {
                throw new UnsupportedOperationException("in " + this.method + ", formal: " + formal);
            }
            ValueBounds argument = it.next();
            args2[argIndex++] = ConstantCall.convert(argument.getConstantValue(), formal.getClazz());
        }
        try {
            constantValue = this.method.getMethod().invoke(null, args2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ConstantCall(constantValue);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public ValueBounds getResultBounds() {
        return this.resultBounds;
    }

    @Override
    public void load(EmitContext emitContext, InstructionAdapter mv, List<IRArgument> arguments) {
        throw new FailedToSpecializeException();
    }

    @Override
    public boolean isPure() {
        return this.method.isPure();
    }
}

