/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.renjin.compiler.builtins.ArgumentBounds;
import org.renjin.compiler.cfg.InlinedFunction;
import org.renjin.compiler.codegen.ApplyCallWriter;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.RuntimeState;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;

public class ApplyCallCompiler {
    private final RuntimeState runtimeState;
    private final Closure closure;
    private final Vector vector;
    private InlinedFunction inlinedFunction;
    private ValueBounds functionBounds;
    private boolean pure;

    public ApplyCallCompiler(Context context, Environment rho, Closure closure, Vector vector2) {
        this.closure = closure;
        this.vector = vector2;
        this.runtimeState = new RuntimeState(context, rho);
    }

    public void tryCompile() {
        Set<Symbol> suppliedFormals = Collections.singleton(this.findElementFormal(this.closure));
        ArrayList<ArgumentBounds> arguments = Lists.newArrayList(new ArgumentBounds(this.computeElementBounds()));
        this.inlinedFunction = new InlinedFunction(this.runtimeState, this.closure, suppliedFormals);
        this.functionBounds = this.inlinedFunction.updateBounds(arguments);
        this.pure = this.inlinedFunction.isPure();
        System.out.println("F = " + this.functionBounds);
    }

    private ValueBounds computeElementBounds() {
        return ValueBounds.of(this.vector).getElementBounds();
    }

    private Symbol findElementFormal(Closure closure) {
        PairList formals2 = closure.getFormals();
        if (formals2 == Null.INSTANCE) {
            throw new EvalException("unused argument X[[i]]", new Object[0]);
        }
        return formals2.getTag();
    }

    public ValueBounds getFunctionBounds() {
        return this.functionBounds;
    }

    public boolean isPure() {
        return this.pure;
    }

    public Class<?> compile() {
        ApplyCallWriter writer = new ApplyCallWriter(this.inlinedFunction, this.closure.getFormals().getTag(), this.computeElementBounds(), this.functionBounds);
        return writer.build();
    }
}

