/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.base;

import java.io.IOException;
import java.io.InputStream;
import java.util.IdentityHashMap;
import java.util.Set;
import org.renjin.RenjinVersion;
import org.renjin.eval.Context;
import org.renjin.eval.Session;
import org.renjin.packaging.LazyLoadFrame;
import org.renjin.primitives.Primitives;
import org.renjin.repackaged.guava.base.Function;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.sexp.Frame;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.Promise;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;

public class BaseFrame
implements Frame {
    private final IdentityHashMap<Symbol, SEXP> loaded = new IdentityHashMap(1100);

    @Override
    public Set<Symbol> getSymbols() {
        return Sets.union(Primitives.getBuiltinSymbols(), this.loaded.keySet());
    }

    @Override
    public SEXP getVariable(Symbol name) {
        SEXP value = Primitives.getBuiltin(name);
        if (value != null) {
            return value;
        }
        value = this.loaded.get(name);
        if (value != null) {
            return value;
        }
        return Symbol.UNBOUND_VALUE;
    }

    @Override
    public org.renjin.sexp.Function getFunction(Context context, Symbol name) {
        SEXP value = Primitives.getBuiltin(name);
        if (value == null) {
            value = this.loaded.get(name);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof Promise) {
            value = value.force(context);
        }
        if (value instanceof org.renjin.sexp.Function) {
            return (org.renjin.sexp.Function)value;
        }
        return null;
    }

    @Override
    public void setVariable(Symbol name, SEXP value) {
        this.loaded.put(name, value);
    }

    public BaseFrame(Session session) {
        this.installPlatform(session);
        this.installMachine();
        this.loaded.put(Symbol.get("R.version.string"), StringVector.valueOf("Renjin version " + RenjinVersion.getVersionName()));
    }

    private void installPlatform(Session session) {
        this.loaded.put(Symbol.get(".Library"), StringVector.valueOf(session.getHomeDirectory() + "/library"));
        this.loaded.put(Symbol.get(".Library.site"), StringVector.EMPTY);
        this.loaded.put(Symbol.get(".Platform"), ListVector.newNamedBuilder().add("OS.type", this.resolveOsName()).add("file.sep", "/").add("GUI", "unknown").add("endian", "big").add("pkgType", "source").add("r_arch", "").add("dynlib.ext", this.dynlibExt()).build());
    }

    protected String dynlibExt() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return ".dll";
        }
        if (os.contains("mac")) {
            return ".dylib";
        }
        return ".so";
    }

    @Override
    public void remove(Symbol name) {
        this.loaded.remove(name);
    }

    private void installMachine() {
        this.loaded.put(Symbol.get(".Machine"), ListVector.newNamedBuilder().add("double.eps", 2.220446E-16).add("double.neg.eps", 1.110223E-16).add("double.xmin", 2.225074E-308).add("double.xmax", 1.797693E308).add("double.base", 2).add("double.digits", 53).add("double.rounding", 5).add("double.guard", 0).add("double.ulp.digits", -52).add("double.neg.ulp.digits", -53).add("double.exponent", 11).add("double.min.exp", -1022).add("double.max.exp", 1023).add("integer.max", Integer.MAX_VALUE).add("sizeof.long", 4).add("sizeof.longlong", 8).add("sizeof.longdouble", 12).add("sizeof.pointer", 4).build());
    }

    private String resolveOsName() {
        return System.getProperty("os.name").contains("windows") ? "windows" : "unix";
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("The base frame cannot be cleared");
    }

    @Override
    public boolean isMissingArgument(Symbol name) {
        return false;
    }

    public void load(Context context) throws IOException {
        Iterable<NamedValue> frame2 = LazyLoadFrame.load(context, new Function<String, InputStream>(){

            @Override
            public InputStream apply(String name) {
                String resourcePath = "/org/renjin/base/" + name;
                InputStream in = this.getClass().getResourceAsStream(resourcePath);
                if (in == null) {
                    throw new RuntimeException("Could not open resource " + resourcePath);
                }
                return in;
            }
        });
        for (NamedValue name : frame2) {
            this.loaded.put(Symbol.get(name.getName()), name.getValue());
        }
        this.addPrimitiveAlias("as.double", "as.numeric");
        this.addPrimitiveAlias("as.double", "as.real");
        this.addPrimitiveAlias("is.symbol", "is.name");
    }

    private void addPrimitiveAlias(String primitiveName, String alias) {
        this.loaded.put(Symbol.get(alias), Primitives.getBuiltin(primitiveName));
    }
}

