/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.util;

import java.io.IOException;

public class EasyIn {
    static String line = null;
    static int idx;
    static int len;
    static String blank_string;

    public static String myCrappyReadLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n >= 0) {
            n = System.in.read();
            if (n < 0) {
                return null;
            }
            if ((char)n == '\n') break;
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    private void initTokenizer() throws IOException {
        do {
            if ((line = EasyIn.myCrappyReadLine()) == null) {
                throw new IOException("EOF");
            }
            idx = 0;
            len = line.length();
        } while (!this.hasTokens(line));
    }

    private boolean hasTokens(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (this.isDelim(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isDelim(char c2) {
        return c2 == ' ' || c2 == '\t' || c2 == '\r' || c2 == '\n';
    }

    private boolean moreTokens() {
        return idx < len;
    }

    private String getToken() throws IOException {
        if (line == null || !this.moreTokens()) {
            this.initTokenizer();
        }
        while (idx < len && this.isDelim(line.charAt(idx))) {
            ++idx;
        }
        if (idx == len) {
            this.initTokenizer();
            while (idx < len && this.isDelim(line.charAt(idx))) {
                ++idx;
            }
        }
        int n = idx;
        while (idx < len && !this.isDelim(line.charAt(idx))) {
            ++idx;
        }
        int n2 = idx;
        return line.substring(n, n2);
    }

    public String readchars(int n) throws IOException {
        int n2;
        if (line == null || !this.moreTokens()) {
            this.initTokenizer();
        }
        if ((n2 = idx) + n < len) {
            idx += n;
            return line.substring(n2, n2 + n);
        }
        idx = len;
        return line.substring(n2, len) + blank_string.substring(0, n - (len - n2));
    }

    public String readChars(int n) {
        try {
            return this.readchars(n);
        }
        catch (IOException iOException) {
            System.err.println("IO Exception in EasyIn.readChars");
            return null;
        }
    }

    public void skipRemaining() {
        line = null;
        idx = len;
    }

    public boolean readboolean() throws IOException {
        char c2 = this.getToken().charAt(0);
        return c2 == 't' || c2 == 'T';
    }

    public boolean readBoolean() {
        try {
            char c2 = this.getToken().charAt(0);
            return c2 == 't' || c2 == 'T';
        }
        catch (IOException iOException) {
            System.err.println("IO Exception in EasyIn.readBoolean");
            return false;
        }
    }

    public byte readbyte() throws IOException {
        return Byte.parseByte(this.getToken());
    }

    public byte readByte() {
        try {
            return Byte.parseByte(this.getToken());
        }
        catch (IOException iOException) {
            System.err.println("IO Exception in EasyIn.readByte");
            return 0;
        }
    }

    public short readshort() throws IOException {
        return Short.parseShort(this.getToken());
    }

    public short readShort() {
        try {
            return Short.parseShort(this.getToken());
        }
        catch (IOException iOException) {
            System.err.println("IO Exception in EasyIn.readShort");
            return 0;
        }
    }

    public int readint() throws IOException {
        return Integer.parseInt(this.getToken());
    }

    public int readInt() {
        try {
            return Integer.parseInt(this.getToken());
        }
        catch (IOException iOException) {
            System.err.println("IO Exception in EasyIn.readInt");
            return 0;
        }
    }

    public long readlong() throws IOException {
        return Long.parseLong(this.getToken());
    }

    public long readLong() {
        try {
            return Long.parseLong(this.getToken());
        }
        catch (IOException iOException) {
            System.err.println("IO Exception in EasyIn.readLong");
            return 0L;
        }
    }

    public float readfloat() throws IOException {
        return new Float(this.getToken()).floatValue();
    }

    public float readFloat() {
        try {
            return new Float(this.getToken()).floatValue();
        }
        catch (IOException iOException) {
            System.err.println("IO Exception in EasyIn.readFloat");
            return 0.0f;
        }
    }

    public double readdouble() throws IOException {
        String string = this.getToken();
        string = string.replace('D', 'E');
        string = string.replace('d', 'e');
        return new Double(string);
    }

    public double readDouble() {
        try {
            String string = this.getToken();
            string = string.replace('D', 'E');
            string = string.replace('d', 'e');
            return new Double(string);
        }
        catch (IOException iOException) {
            System.err.println("IO Exception in EasyIn.readDouble");
            return 0.0;
        }
    }

    public char readchar() throws IOException {
        return this.getToken().charAt(0);
    }

    public char readChar() {
        try {
            return this.getToken().charAt(0);
        }
        catch (IOException iOException) {
            System.err.println("IO Exception in EasyIn.readChar");
            return '\u0000';
        }
    }

    public String readstring() throws IOException {
        return EasyIn.myCrappyReadLine();
    }

    public String readString() {
        try {
            return EasyIn.myCrappyReadLine();
        }
        catch (IOException iOException) {
            System.err.println("IO Exception in EasyIn.readString");
            return "";
        }
    }

    public static void main(String[] stringArray) {
        EasyIn easyIn = new EasyIn();
        System.out.print("enter char: ");
        System.out.flush();
        System.out.println("You entered: " + easyIn.readChar());
        System.out.print("enter String: ");
        System.out.flush();
        System.out.println("You entered: " + easyIn.readString());
        System.out.print("enter boolean: ");
        System.out.flush();
        System.out.println("You entered: " + easyIn.readBoolean());
        System.out.print("enter byte: ");
        System.out.flush();
        System.out.println("You entered: " + easyIn.readByte());
        System.out.print("enter short: ");
        System.out.flush();
        System.out.println("You entered: " + easyIn.readShort());
        System.out.print("enter int: ");
        System.out.flush();
        System.out.println("You entered: " + easyIn.readInt());
        System.out.print("enter long: ");
        System.out.flush();
        System.out.println("You entered: " + easyIn.readLong());
        System.out.print("enter float: ");
        System.out.flush();
        System.out.println("You entered: " + easyIn.readFloat());
        System.out.print("enter double: ");
        System.out.flush();
        System.out.println("You entered: " + easyIn.readDouble());
    }

    static {
        blank_string = "                                                                                           ";
    }
}

