/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine.impl.interceptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.dmn.engine.ActivitiDmnException;
import org.activiti.dmn.engine.ActivitiDmnOptimisticLockingException;
import org.activiti.dmn.engine.DmnEngineConfiguration;
import org.activiti.dmn.engine.impl.cfg.TransactionContext;
import org.activiti.dmn.engine.impl.db.DbSqlSession;
import org.activiti.dmn.engine.impl.interceptor.Command;
import org.activiti.dmn.engine.impl.interceptor.CommandContextCloseListener;
import org.activiti.dmn.engine.impl.interceptor.Session;
import org.activiti.dmn.engine.impl.interceptor.SessionFactory;
import org.activiti.dmn.engine.impl.persistence.entity.DecisionTableEntityManager;
import org.activiti.dmn.engine.impl.persistence.entity.DmnDeploymentEntityManager;
import org.activiti.dmn.engine.impl.persistence.entity.ResourceEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandContext {
    private static Logger log = LoggerFactory.getLogger(CommandContext.class);
    protected Command<?> command;
    protected TransactionContext transactionContext;
    protected Map<Class<?>, SessionFactory> sessionFactories;
    protected Map<Class<?>, Session> sessions = new HashMap();
    protected Throwable exception;
    protected DmnEngineConfiguration dmnEngineConfiguration;
    protected List<CommandContextCloseListener> closeListeners;
    protected Map<String, Object> attributes;

    public CommandContext(Command<?> command, DmnEngineConfiguration dmnEngineConfiguration) {
        this.command = command;
        this.dmnEngineConfiguration = dmnEngineConfiguration;
        this.sessionFactories = dmnEngineConfiguration.getSessionFactories();
        this.transactionContext = dmnEngineConfiguration.getTransactionContextFactory().openTransactionContext(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        block42: {
            try {
                try {
                    try {
                        if (this.closeListeners != null) {
                            try {
                                for (CommandContextCloseListener listener : this.closeListeners) {
                                    listener.closing(this);
                                }
                            }
                            catch (Throwable exception) {
                                this.exception(exception);
                            }
                        }
                        if (this.exception == null) {
                            this.flushSessions();
                        }
                    }
                    catch (Throwable exception) {
                        try {
                            this.exception(exception);
                            break block42;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            try {
                                if (this.exception == null) {
                                    this.transactionContext.commit();
                                }
                            }
                            catch (Throwable exception2) {
                                this.exception(exception2);
                            }
                            if (this.closeListeners != null) {
                                try {
                                    for (CommandContextCloseListener listener : this.closeListeners) {
                                        listener.closed(this);
                                    }
                                }
                                catch (Throwable exception3) {
                                    this.exception(exception3);
                                }
                            }
                            if (this.exception != null) {
                                if (this.exception instanceof ActivitiDmnOptimisticLockingException) {
                                    log.debug("Optimistic locking exception : " + this.exception);
                                } else {
                                    log.debug("Error while closing command context", this.exception);
                                }
                                this.transactionContext.rollback();
                            }
                        }
                    }
                    try {
                        if (this.exception == null) {
                            this.transactionContext.commit();
                        }
                    }
                    catch (Throwable exception) {
                        this.exception(exception);
                    }
                    if (this.closeListeners != null) {
                        try {
                            for (CommandContextCloseListener listener : this.closeListeners) {
                                listener.closed(this);
                            }
                        }
                        catch (Throwable exception) {
                            this.exception(exception);
                        }
                    }
                    if (this.exception != null) {
                        if (this.exception instanceof ActivitiDmnOptimisticLockingException) {
                            log.debug("Optimistic locking exception : " + this.exception);
                        } else {
                            log.debug("Error while closing command context", this.exception);
                        }
                        this.transactionContext.rollback();
                    }
                }
                catch (Throwable exception) {
                    this.exception(exception);
                }
                finally {
                    this.closeSessions();
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
        if (this.exception == null) return;
        if (this.exception instanceof Error) {
            throw (Error)this.exception;
        }
        if (!(this.exception instanceof RuntimeException)) throw new ActivitiDmnException("exception while executing command " + this.command, this.exception);
        throw (RuntimeException)this.exception;
    }

    public void addCloseListener(CommandContextCloseListener commandContextCloseListener) {
        if (this.closeListeners == null) {
            this.closeListeners = new ArrayList<CommandContextCloseListener>(1);
        }
        this.closeListeners.add(commandContextCloseListener);
    }

    public List<CommandContextCloseListener> getCloseListeners() {
        return this.closeListeners;
    }

    protected void flushSessions() {
        for (Session session : this.sessions.values()) {
            session.flush();
        }
    }

    protected void closeSessions() {
        for (Session session : this.sessions.values()) {
            try {
                session.close();
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    public void exception(Throwable exception) {
        if (this.exception == null) {
            this.exception = exception;
        } else {
            log.error("masked exception in command context. for root cause, see below as it will be rethrown later.", exception);
        }
    }

    public void addAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>(1);
        }
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        if (this.attributes != null) {
            return this.attributes.get(key);
        }
        return null;
    }

    public <T> T getSession(Class<T> sessionClass) {
        Session session = this.sessions.get(sessionClass);
        if (session == null) {
            SessionFactory sessionFactory = this.sessionFactories.get(sessionClass);
            if (sessionFactory == null) {
                throw new ActivitiDmnException("no session factory configured for " + sessionClass.getName());
            }
            session = sessionFactory.openSession(this);
            this.sessions.put(sessionClass, session);
        }
        return (T)session;
    }

    public Map<Class<?>, SessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    public DbSqlSession getDbSqlSession() {
        return this.getSession(DbSqlSession.class);
    }

    public DmnDeploymentEntityManager getDeploymentEntityManager() {
        return this.dmnEngineConfiguration.getDeploymentEntityManager();
    }

    public DecisionTableEntityManager getDecisionTableEntityManager() {
        return this.dmnEngineConfiguration.getDecisionTableEntityManager();
    }

    public ResourceEntityManager getResourceEntityManager() {
        return this.dmnEngineConfiguration.getResourceEntityManager();
    }

    public DmnEngineConfiguration getDmnEngineConfiguration() {
        return this.dmnEngineConfiguration;
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public Command<?> getCommand() {
        return this.command;
    }

    public Map<Class<?>, Session> getSessions() {
        return this.sessions;
    }

    public Throwable getException() {
        return this.exception;
    }
}

