/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.dmn.api.RuleEngineExecutionResult;
import org.activiti.dmn.engine.ActivitiDmnException;
import org.activiti.dmn.engine.ActivitiDmnExpressionException;
import org.activiti.dmn.engine.RuleEngineExecutor;
import org.activiti.dmn.engine.impl.ValidRuleOutputEntries;
import org.activiti.dmn.engine.impl.mvel.ExecutionVariableFactory;
import org.activiti.dmn.engine.impl.mvel.MvelExecutionContext;
import org.activiti.dmn.engine.impl.mvel.MvelExecutionContextBuilder;
import org.activiti.dmn.engine.impl.mvel.MvelExpressionExecutor;
import org.activiti.dmn.model.Decision;
import org.activiti.dmn.model.DecisionRule;
import org.activiti.dmn.model.DecisionTable;
import org.activiti.dmn.model.HitPolicy;
import org.activiti.dmn.model.LiteralExpression;
import org.activiti.dmn.model.RuleInputClauseContainer;
import org.activiti.dmn.model.RuleOutputClauseContainer;
import org.apache.commons.lang3.StringUtils;
import org.mvel2.integration.PropertyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEngineExecutorImpl
implements RuleEngineExecutor {
    private static final Logger logger = LoggerFactory.getLogger(RuleEngineExecutorImpl.class);

    @Override
    public RuleEngineExecutionResult execute(Decision decision, Map<String, Object> input, Map<String, Method> customExpressionFunctions, Map<Class<?>, PropertyHandler> propertyHandlers) {
        if (decision == null) {
            throw new IllegalArgumentException("no decision provided");
        }
        if (decision.getExpression() == null || !(decision.getExpression() instanceof DecisionTable)) {
            throw new IllegalArgumentException("no decision table present in decision");
        }
        DecisionTable currentDecisionTable = (DecisionTable)decision.getExpression();
        MvelExecutionContext executionContext = MvelExecutionContextBuilder.build(decision, input, customExpressionFunctions, propertyHandlers);
        Map<String, Object> resultVariables = this.evaluateDecisionTable(currentDecisionTable, executionContext);
        executionContext.getAuditContainer().stopAudit(resultVariables);
        RuleEngineExecutionResult executionResult = new RuleEngineExecutionResult(resultVariables, executionContext.getAuditContainer());
        return executionResult;
    }

    protected Map<String, Object> evaluateDecisionTable(DecisionTable decisionTable, MvelExecutionContext executionContext) {
        if (decisionTable == null || decisionTable.getRules().isEmpty()) {
            throw new IllegalArgumentException("no rules present in table");
        }
        if (executionContext == null) {
            throw new ActivitiDmnException("no execution context available");
        }
        logger.debug("Start table evaluation: " + decisionTable.getId());
        HashMap ruleResults = new HashMap();
        ArrayList<ValidRuleOutputEntries> validConclusionsStack = new ArrayList<ValidRuleOutputEntries>();
        int ruleRowCounter = 0;
        try {
            for (DecisionRule rule : decisionTable.getRules()) {
                Boolean ruleResult = this.executeRule(ruleRowCounter, rule, executionContext, validConclusionsStack);
                if (this.shouldContinueEvaluating(decisionTable.getHitPolicy(), ruleResult).booleanValue()) {
                    ++ruleRowCounter;
                    continue;
                }
                break;
            }
        }
        catch (ActivitiDmnException ade) {
            logger.error("decision table execution failed", (Throwable)ade);
            executionContext.getAuditContainer().setFailed();
            executionContext.getAuditContainer().setExceptionMessage(this.getExceptionMessage(ade));
        }
        logger.debug("End table evaluation: " + decisionTable.getId());
        return executionContext.getResultVariables();
    }

    protected Boolean shouldContinueEvaluating(HitPolicy hitPolicy, Boolean ruleResult) {
        Boolean shouldContinue = Boolean.TRUE;
        if (hitPolicy == HitPolicy.FIRST && ruleResult.booleanValue()) {
            logger.debug("Stopping execution: rule is valid and Hit Policy is FIRST");
            shouldContinue = Boolean.FALSE;
        }
        return shouldContinue;
    }

    protected Boolean executeRule(int ruleRowIndex, DecisionRule rule, MvelExecutionContext executionContext, List<ValidRuleOutputEntries> validOutputEntriesStack) {
        if (rule == null) {
            throw new ActivitiDmnException("rule cannot be null");
        }
        logger.debug("Start rule evaluation");
        executionContext.getAuditContainer().addRuleEntry();
        Boolean conditionResult = Boolean.FALSE;
        for (RuleInputClauseContainer conditionContainer : rule.getInputEntries()) {
            conditionResult = Boolean.FALSE;
            try {
                conditionResult = StringUtils.isEmpty((CharSequence)conditionContainer.getInputEntry().getText()) ? Boolean.TRUE : this.executeInputExpressionEvaluation(conditionContainer, executionContext);
                executionContext.getAuditContainer().addInputEntry(ruleRowIndex, conditionContainer.getInputEntry().getId(), conditionResult);
                logger.debug("input entry {} ( {} {} ): {} ", new Object[]{conditionContainer.getInputEntry().getId(), conditionContainer.getInputClause().getInputExpression().getText(), conditionContainer.getInputEntry().getText(), conditionResult});
            }
            catch (ActivitiDmnExpressionException adee) {
                executionContext.getAuditContainer().addInputEntry(ruleRowIndex, conditionContainer.getInputEntry().getId(), this.getExceptionMessage(adee), conditionResult);
            }
            catch (ActivitiDmnException ade) {
                executionContext.getAuditContainer().addInputEntry(ruleRowIndex, conditionContainer.getInputEntry().getId(), this.getExceptionMessage(ade), null);
                throw ade;
            }
            catch (Exception e) {
                executionContext.getAuditContainer().addInputEntry(ruleRowIndex, conditionContainer.getInputEntry().getId(), this.getExceptionMessage(e), null);
                throw new ActivitiDmnException(this.getExceptionMessage(e), e);
            }
            if (conditionResult.booleanValue()) continue;
            break;
        }
        if (conditionResult.booleanValue()) {
            this.executeOutputEntryAction(ruleRowIndex, rule.getOutputEntries(), executionContext);
        }
        executionContext.getAuditContainer().markRuleEnd(ruleRowIndex);
        logger.debug("End rule evaluation");
        return conditionResult;
    }

    protected Boolean executeInputExpressionEvaluation(RuleInputClauseContainer ruleContainer, MvelExecutionContext executionContext) {
        return MvelExpressionExecutor.executeInputExpression(ruleContainer.getInputClause(), ruleContainer.getInputEntry(), executionContext);
    }

    protected void executeOutputEntryAction(int ruleRowIndex, List<RuleOutputClauseContainer> ruleOutputContainers, MvelExecutionContext executionContext) {
        logger.debug("Start conclusion processing");
        for (RuleOutputClauseContainer clauseContainer : ruleOutputContainers) {
            if (!StringUtils.isNotEmpty((CharSequence)clauseContainer.getOutputEntry().getText())) continue;
            this.composeOutputEntryResult(ruleRowIndex, clauseContainer, executionContext);
        }
        logger.debug("End conclusion processing");
    }

    protected void composeOutputEntryResult(int ruleRowIndex, RuleOutputClauseContainer ruleClauseContainer, MvelExecutionContext executionContext) {
        String outputVariableId = ruleClauseContainer.getOutputClause().getName();
        String outputVariableType = ruleClauseContainer.getOutputClause().getTypeRef();
        LiteralExpression outputEntryExpression = ruleClauseContainer.getOutputEntry();
        Object executionVariable = null;
        try {
            Object resultVariable = MvelExpressionExecutor.executeOutputExpression(ruleClauseContainer.getOutputClause(), outputEntryExpression, executionContext);
            executionVariable = ExecutionVariableFactory.getExecutionVariable(outputVariableType, resultVariable);
            executionContext.getStackVariables().put(outputVariableId, executionVariable);
            executionContext.getResultVariables().put(outputVariableId, executionVariable);
            executionContext.getAuditContainer().addOutputEntry(ruleRowIndex, outputEntryExpression.getId(), executionVariable);
            if (executionVariable != null) {
                logger.debug("Created conclusion result: {} of type: {} with value {} ", new Object[]{outputVariableId, resultVariable.getClass(), resultVariable.toString()});
            } else {
                logger.warn("Could not create conclusion result");
            }
        }
        catch (ActivitiDmnException ade) {
            executionContext.getAuditContainer().addOutputEntry(ruleRowIndex, outputEntryExpression.getId(), this.getExceptionMessage(ade), executionVariable);
            throw ade;
        }
        catch (Exception e) {
            executionContext.getAuditContainer().addOutputEntry(ruleRowIndex, outputEntryExpression.getId(), this.getExceptionMessage(e), executionVariable);
            throw new ActivitiDmnException(this.getExceptionMessage(e), e);
        }
    }

    protected String getExceptionMessage(Exception exception) {
        String exceptionMessage = null;
        exceptionMessage = exception.getCause() != null && exception.getCause().getMessage() != null ? exception.getCause().getMessage() : exception.getMessage();
        return exceptionMessage;
    }
}

