/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.service.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.activiti.app.model.idm.GroupRepresentation;
import org.activiti.app.model.idm.UserRepresentation;
import org.activiti.app.model.runtime.TaskRepresentation;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.UserTask;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.history.HistoricIdentityLink;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.User;
import org.activiti.engine.task.TaskInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class TaskUtil {
    public static void fillPermissionInformation(TaskRepresentation taskRepresentation, TaskInfo task, User currentUser, IdentityService identityService, HistoryService historyService, RepositoryService repositoryService) {
        HistoricProcessInstance historicProcessInstance;
        String processInstanceStartUserId = null;
        boolean initiatorCanCompleteTask = true;
        boolean isMemberOfCandidateGroup = false;
        boolean isMemberOfCandidateUsers = false;
        if (task.getProcessInstanceId() != null && (historicProcessInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult()) != null) {
            processInstanceStartUserId = historicProcessInstance.getStartUserId();
            BpmnModel bpmnModel = repositoryService.getBpmnModel(task.getProcessDefinitionId());
            FlowElement flowElement = bpmnModel.getFlowElement(task.getTaskDefinitionKey());
            if (flowElement != null && flowElement instanceof UserTask) {
                List groups;
                List processVariables;
                String value;
                UserTask userTask = (UserTask)flowElement;
                List extensionElements = (List)userTask.getExtensionElements().get("initiator-can-complete");
                if (CollectionUtils.isNotEmpty((Collection)extensionElements) && StringUtils.isNotEmpty((CharSequence)(value = ((ExtensionElement)extensionElements.get(0)).getElementText()))) {
                    initiatorCanCompleteTask = Boolean.valueOf(value);
                }
                HashMap<String, Object> variableMap = new HashMap<String, Object>();
                if ((CollectionUtils.isNotEmpty((Collection)userTask.getCandidateGroups()) && userTask.getCandidateGroups().size() == 1 && ((String)userTask.getCandidateGroups().get(0)).contains("${taskAssignmentBean.assignTaskToCandidateGroups('") || CollectionUtils.isNotEmpty((Collection)userTask.getCandidateUsers()) && userTask.getCandidateUsers().size() == 1 && ((String)userTask.getCandidateUsers().get(0)).contains("${taskAssignmentBean.assignTaskToCandidateUsers('")) && CollectionUtils.isNotEmpty((Collection)(processVariables = historyService.createHistoricVariableInstanceQuery().processInstanceId(task.getProcessInstanceId()).list()))) {
                    for (HistoricVariableInstance historicVariableInstance : processVariables) {
                        variableMap.put(historicVariableInstance.getVariableName(), historicVariableInstance.getValue());
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)userTask.getCandidateGroups()) && CollectionUtils.isNotEmpty((Collection)(groups = identityService.createGroupQuery().groupMember(currentUser.getId()).list()))) {
                    ArrayList<String> groupIds = new ArrayList<String>();
                    if (userTask.getCandidateGroups().size() == 1 && ((String)userTask.getCandidateGroups().get(0)).contains("${taskAssignmentBean.assignTaskToCandidateGroups('")) {
                        String[] groupsArray;
                        String candidateGroupString = (String)userTask.getCandidateGroups().get(0);
                        candidateGroupString = candidateGroupString.replace("${taskAssignmentBean.assignTaskToCandidateGroups('", "");
                        candidateGroupString = candidateGroupString.replace("', execution)}", "");
                        for (String group : groupsArray = candidateGroupString.split(",")) {
                            if (group.contains("field(")) {
                                String fieldCandidate = group.trim().substring(6, group.length() - 1);
                                Object fieldValue = variableMap.get(fieldCandidate);
                                if (fieldValue == null || !NumberUtils.isNumber((String)fieldValue.toString())) continue;
                                groupIds.add(fieldValue.toString());
                                continue;
                            }
                            groupIds.add(group);
                        }
                    } else {
                        groupIds.addAll(userTask.getCandidateGroups());
                    }
                    for (Group group : groups) {
                        if (!groupIds.contains(String.valueOf(group.getId()))) continue;
                        isMemberOfCandidateGroup = true;
                        break;
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)userTask.getCandidateUsers())) {
                    if (userTask.getCandidateUsers().size() == 1 && ((String)userTask.getCandidateUsers().get(0)).contains("${taskAssignmentBean.assignTaskToCandidateUsers('")) {
                        String[] users;
                        String candidateUserString = (String)userTask.getCandidateUsers().get(0);
                        candidateUserString = candidateUserString.replace("${taskAssignmentBean.assignTaskToCandidateUsers('", "");
                        candidateUserString = candidateUserString.replace("', execution)}", "");
                        for (String user : users = candidateUserString.split(",")) {
                            if (user.contains("field(")) {
                                String fieldCandidate = user.substring(6, user.length() - 1);
                                Object fieldValue = variableMap.get(fieldCandidate);
                                if (fieldValue == null || !NumberUtils.isNumber((String)fieldValue.toString()) || !String.valueOf(currentUser.getId()).equals(fieldValue.toString())) continue;
                                isMemberOfCandidateGroup = true;
                            } else {
                                if (!user.equals(String.valueOf(currentUser.getId()))) continue;
                                isMemberOfCandidateGroup = true;
                            }
                            break;
                        }
                    } else if (userTask.getCandidateUsers().contains(String.valueOf(currentUser.getId()))) {
                        isMemberOfCandidateUsers = true;
                    }
                }
            }
            if (!isMemberOfCandidateGroup && !isMemberOfCandidateUsers) {
                ArrayList<String> candidateGroupIds = new ArrayList<String>();
                List links = historyService.getHistoricIdentityLinksForTask(task.getId());
                for (HistoricIdentityLink historicIdentityLink : links) {
                    if (!isMemberOfCandidateUsers && StringUtils.isNotEmpty((CharSequence)historicIdentityLink.getUserId()) && String.valueOf(currentUser.getId()).equals(historicIdentityLink.getUserId()) && "candidate".equalsIgnoreCase(historicIdentityLink.getType())) {
                        isMemberOfCandidateUsers = true;
                        continue;
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)historicIdentityLink.getGroupId()) || !"candidate".equalsIgnoreCase(historicIdentityLink.getType())) continue;
                    candidateGroupIds.add(historicIdentityLink.getGroupId());
                }
                List<GroupRepresentation> groups2 = new UserRepresentation(currentUser).getGroups();
                if (groups2 != null) {
                    for (GroupRepresentation group3 : groups2) {
                        if (!candidateGroupIds.contains(group3.getId().toString())) continue;
                        isMemberOfCandidateGroup = true;
                        break;
                    }
                }
            }
        }
        taskRepresentation.setProcessInstanceStartUserId(processInstanceStartUserId);
        taskRepresentation.setInitiatorCanCompleteTask(initiatorCanCompleteTask);
        taskRepresentation.setMemberOfCandidateGroup(isMemberOfCandidateGroup);
        taskRepresentation.setMemberOfCandidateUsers(isMemberOfCandidateUsers);
    }
}

