/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.service.runtime;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.app.domain.editor.AppDefinition;
import org.activiti.app.domain.editor.AppModelDefinition;
import org.activiti.app.domain.editor.Model;
import org.activiti.app.repository.editor.ModelRepository;
import org.activiti.app.service.api.AppDefinitionService;
import org.activiti.app.service.api.DeploymentService;
import org.activiti.app.service.api.ModelService;
import org.activiti.app.service.exception.BadRequestException;
import org.activiti.app.service.exception.InternalServerErrorException;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.UserTask;
import org.activiti.dmn.model.DmnDefinition;
import org.activiti.dmn.xml.converter.DmnXMLConverter;
import org.activiti.editor.dmn.converter.DmnJsonConverter;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.identity.User;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeploymentServiceImpl
implements DeploymentService {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentServiceImpl.class);
    @Autowired
    protected AppDefinitionService appDefinitionService;
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected ModelRepository modelRepository;
    @Autowired
    protected ObjectMapper objectMapper;
    protected DmnJsonConverter dmnJsonConverter = new DmnJsonConverter();
    protected DmnXMLConverter dmnXMLConverter = new DmnXMLConverter();

    @Override
    @Transactional
    public Deployment updateAppDefinition(Model appDefinitionModel, User user) {
        Deployment deployment = null;
        AppDefinition appDefinition = this.resolveAppDefinition(appDefinitionModel);
        if (CollectionUtils.isNotEmpty(appDefinition.getModels())) {
            DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().name(appDefinitionModel.getName()).key(appDefinitionModel.getKey());
            HashMap<String, Model> formMap = new HashMap<String, Model>();
            HashMap<String, Model> decisionTableMap = new HashMap<String, Model>();
            for (AppModelDefinition appModelDef : appDefinition.getModels()) {
                Model processModel = this.modelService.getModel(appModelDef.getId());
                if (processModel == null) {
                    logger.error("Model " + appModelDef.getId() + " for app definition " + appDefinitionModel.getId() + " could not be found");
                    throw new BadRequestException("Model for app definition could not be found");
                }
                List<Model> referencedModels = this.modelRepository.findModelsByParentModelId(processModel.getId());
                for (Model childModel : referencedModels) {
                    if (2 == childModel.getModelType()) {
                        formMap.put(childModel.getId(), childModel);
                        continue;
                    }
                    if (4 != childModel.getModelType()) continue;
                    decisionTableMap.put(childModel.getId(), childModel);
                }
                BpmnModel bpmnModel = this.modelService.getBpmnModel(processModel, formMap, decisionTableMap);
                Map<String, StartEvent> startEventMap = this.processNoneStartEvents(bpmnModel);
                for (Process process : bpmnModel.getProcesses()) {
                    this.processUserTasks(process.getFlowElements(), process, startEventMap);
                }
                byte[] modelXML = this.modelService.getBpmnXML(bpmnModel);
                deploymentBuilder.addInputStream(processModel.getKey().replaceAll(" ", "") + ".bpmn", (InputStream)new ByteArrayInputStream(modelXML));
            }
            if (formMap.size() > 0) {
                for (String formId : formMap.keySet()) {
                    Model formInfo = (Model)formMap.get(formId);
                    deploymentBuilder.addString("form-" + formInfo.getKey() + ".form", formInfo.getModelEditorJson());
                }
            }
            if (decisionTableMap.size() > 0) {
                for (String decisionTableId : decisionTableMap.keySet()) {
                    Model decisionTableInfo = (Model)decisionTableMap.get(decisionTableId);
                    try {
                        JsonNode decisionTableNode = this.objectMapper.readTree(decisionTableInfo.getModelEditorJson());
                        DmnDefinition dmnDefinition = this.dmnJsonConverter.convertToDmn(decisionTableNode, decisionTableInfo.getId(), decisionTableInfo.getVersion(), decisionTableInfo.getLastUpdated());
                        byte[] dmnXMLBytes = this.dmnXMLConverter.convertToXML(dmnDefinition);
                        deploymentBuilder.addBytes("dmn-" + decisionTableInfo.getKey() + ".dmn", dmnXMLBytes);
                    }
                    catch (Exception e) {
                        logger.error("Error converting decision table to XML " + decisionTableInfo.getName(), (Throwable)e);
                        throw new InternalServerErrorException("Error converting decision table to XML " + decisionTableInfo.getName());
                    }
                }
            }
            deployment = deploymentBuilder.deploy();
        }
        return deployment;
    }

    @Override
    @Transactional
    public void deleteAppDefinition(String appDefinitionId) {
        List deployments = this.repositoryService.createDeploymentQuery().deploymentKey(String.valueOf(appDefinitionId)).list();
        if (deployments != null) {
            for (Deployment deployment : deployments) {
                this.repositoryService.deleteDeployment(deployment.getId(), true);
            }
        }
    }

    protected Map<String, StartEvent> processNoneStartEvents(BpmnModel bpmnModel) {
        HashMap<String, StartEvent> startEventMap = new HashMap<String, StartEvent>();
        block0: for (Process process : bpmnModel.getProcesses()) {
            for (FlowElement flowElement : process.getFlowElements()) {
                StartEvent startEvent;
                if (!(flowElement instanceof StartEvent) || !CollectionUtils.isEmpty((Collection)(startEvent = (StartEvent)flowElement).getEventDefinitions())) continue;
                if (StringUtils.isEmpty((CharSequence)startEvent.getInitiator())) {
                    startEvent.setInitiator("initiator");
                }
                startEventMap.put(process.getId(), startEvent);
                continue block0;
            }
        }
        return startEventMap;
    }

    protected void processUserTasks(Collection<FlowElement> flowElements, Process process, Map<String, StartEvent> startEventMap) {
        for (FlowElement flowElement : flowElements) {
            if (flowElement instanceof UserTask) {
                UserTask userTask = (UserTask)flowElement;
                if (!"$INITIATOR".equals(userTask.getAssignee()) || startEventMap.get(process.getId()) == null) continue;
                userTask.setAssignee("${" + startEventMap.get(process.getId()).getInitiator() + "}");
                continue;
            }
            if (!(flowElement instanceof SubProcess)) continue;
            this.processUserTasks(((SubProcess)flowElement).getFlowElements(), process, startEventMap);
        }
    }

    protected AppDefinition resolveAppDefinition(Model appDefinitionModel) {
        try {
            AppDefinition appDefinition = (AppDefinition)this.objectMapper.readValue(appDefinitionModel.getModelEditorJson(), AppDefinition.class);
            return appDefinition;
        }
        catch (Exception e) {
            logger.error("Error deserializing app " + appDefinitionModel.getId(), (Throwable)e);
            throw new InternalServerErrorException("Could not deserialize app definition");
        }
    }
}

