/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.util;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.web.WebReportContext;
import net.sf.jasperreports.web.util.WebUtil;

public class ReportExecutionHyperlinkProducer
implements JRHyperlinkProducer {
    public static final String HYPERLINK_TYPE_REPORT_EXECUTION = "ReportExecution";
    public static final String PARAMETER_REPORT_URI = "jr.report";
    private static final String PARAMETER_REPORT_URI_OLD = "jr.uri";
    protected JasperReportsContext jasperReportsContext;
    private HttpServletRequest request;

    protected ReportExecutionHyperlinkProducer(JasperReportsContext jasperReportsContext, HttpServletRequest request) {
        this.jasperReportsContext = jasperReportsContext;
        this.request = request;
    }

    public static ReportExecutionHyperlinkProducer getInstance(JasperReportsContext jasperReportsContext, HttpServletRequest request) {
        return new ReportExecutionHyperlinkProducer(jasperReportsContext, request);
    }

    protected String getPath() {
        return WebUtil.getInstance(this.jasperReportsContext).getReportExecutionPath();
    }

    @Override
    public String getHyperlink(JRPrintHyperlink hyperlink) {
        List<JRPrintHyperlinkParameter> parameters;
        String applicationDomain = null;
        String servletPath = this.getPath();
        String reportUri = this.request.getParameter("jr_report_uri");
        WebReportContext webReportContext = WebReportContext.getInstance(this.request, false);
        if (webReportContext != null) {
            applicationDomain = (String)webReportContext.getParameterValue("jr_app_domain");
        }
        if (applicationDomain == null) {
            applicationDomain = this.request.getContextPath();
        }
        StringBuilder allParams = new StringBuilder();
        if (hyperlink.getHyperlinkParameters() != null && (parameters = hyperlink.getHyperlinkParameters().getParameters()) != null) {
            for (int i = 0; i < parameters.size(); ++i) {
                JRPrintHyperlinkParameter parameter = parameters.get(i);
                if (PARAMETER_REPORT_URI.equals(parameter.getName()) || PARAMETER_REPORT_URI_OLD.equals(parameter.getName())) {
                    reportUri = (String)parameter.getValue();
                    continue;
                }
                if (parameter.getValue() == null) continue;
                allParams.append("&").append(parameter.getName()).append("=").append(parameter.getValue());
            }
        }
        return applicationDomain + (servletPath != null ? servletPath : "") + "?" + "jr_report_uri" + "=" + reportUri + allParams.toString();
    }
}

