/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.activiti.dmn.converter.child.BaseChildElementParser;
import org.activiti.dmn.model.DecisionRule;
import org.activiti.dmn.model.DecisionTable;
import org.activiti.dmn.model.DmnElement;
import org.activiti.dmn.model.LiteralExpression;
import org.activiti.dmn.model.OutputClause;
import org.activiti.dmn.model.RuleOutputClauseContainer;

public class OutputEntryParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "outputEntry";
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, DmnElement parentElement, DecisionTable decisionTable) throws Exception {
        if (!(parentElement instanceof DecisionRule)) {
            return;
        }
        DecisionRule rule = (DecisionRule)parentElement;
        LiteralExpression outputEntry = new LiteralExpression();
        outputEntry.setId(xtr.getAttributeValue(null, "id"));
        boolean readyWithOutputEntry = false;
        try {
            while (!readyWithOutputEntry && xtr.hasNext()) {
                xtr.next();
                if (xtr.isStartElement() && "text".equalsIgnoreCase(xtr.getLocalName())) {
                    outputEntry.setText(xtr.getElementText());
                    continue;
                }
                if (!xtr.isEndElement() || !this.getElementName().equalsIgnoreCase(xtr.getLocalName())) continue;
                readyWithOutputEntry = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing output entry", (Throwable)e);
        }
        OutputClause outputClause = null;
        if (decisionTable.getOutputs() != null && decisionTable.getOutputs().get(rule.getOutputEntries().size()) != null) {
            outputClause = (OutputClause)decisionTable.getOutputs().get(rule.getOutputEntries().size());
        }
        if (outputClause == null) {
            LOGGER.warn("Error determine output clause for position: " + decisionTable.getOutputs());
        }
        RuleOutputClauseContainer outputContainer = new RuleOutputClauseContainer();
        outputContainer.setOutputClause(outputClause);
        outputContainer.setOutputEntry(outputEntry);
        if (outputEntry.getText() != null) {
            rule.addOutputEntry(outputContainer);
        }
    }
}

