/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.mc;

import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.mc.StructureItem;

public class StructureObject
extends StructureItem {
    protected PdfDictionary structElem;
    protected PdfIndirectReference ref;
    protected PdfObject obj;
    protected PdfIndirectReference objref;
    protected int structParent;

    public StructureObject(PdfDictionary structElem, PdfIndirectReference ref, PdfDictionary dict) {
        this.structElem = structElem;
        this.ref = ref;
        this.obj = dict.getDirectObject(PdfName.OBJ);
        this.objref = dict.getAsIndirectObject(PdfName.OBJ);
        this.structParent = ((PdfDictionary)this.obj).getAsNumber(PdfName.STRUCTPARENT).intValue();
        PdfIndirectReference pg = dict.getAsIndirectObject(PdfName.PG);
        if (pg == null) {
            pg = structElem.getAsIndirectObject(PdfName.PG);
        }
        this.pageref = pg.getNumber();
    }

    public PdfDictionary getStructElem() {
        return this.structElem;
    }

    public PdfIndirectReference getRef() {
        return this.ref;
    }

    public PdfDictionary getObjAsDict() {
        if (this.obj.isDictionary()) {
            return (PdfDictionary)this.obj;
        }
        return null;
    }

    public PdfIndirectReference getObjRef() {
        return this.objref;
    }

    public int checkStructParent(int pg, int sp) {
        if (pg == this.pageref && sp == this.structParent) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        return "StructParent " + this.structParent + " of object " + this.obj + " on page with reference " + this.pageref;
    }
}

