/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.dmn.service.api.repository;

import javax.servlet.http.HttpServletResponse;
import org.activiti.dmn.api.DmnDeployment;
import org.activiti.dmn.api.DmnRepositoryService;
import org.activiti.dmn.engine.ActivitiDmnObjectNotFoundException;
import org.activiti.rest.dmn.service.api.DmnRestResponseFactory;
import org.activiti.rest.dmn.service.api.repository.DmnDeploymentResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DmnDeploymentResource {
    @Autowired
    protected DmnRestResponseFactory dmnRestResponseFactory;
    @Autowired
    protected DmnRepositoryService dmnRepositoryService;

    @RequestMapping(value={"/dmn-repository/deployments/{deploymentId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public DmnDeploymentResponse getDmnDeployment(@PathVariable String deploymentId) {
        DmnDeployment deployment = (DmnDeployment)this.dmnRepositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
        if (deployment == null) {
            throw new ActivitiDmnObjectNotFoundException("Could not find a DMN deployment with id '" + deploymentId);
        }
        return this.dmnRestResponseFactory.createDmnDeploymentResponse(deployment);
    }

    @RequestMapping(value={"/dmn-repository/deployments/{deploymentId}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    public void deleteDmnDeployment(@PathVariable String deploymentId, HttpServletResponse response) {
        this.dmnRepositoryService.deleteDeployment(deploymentId);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

