/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.dmn.service.api.repository;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.dmn.api.DmnDeployment;
import org.activiti.dmn.api.DmnDeploymentBuilder;
import org.activiti.dmn.api.DmnDeploymentQuery;
import org.activiti.dmn.api.DmnRepositoryService;
import org.activiti.dmn.api.Query;
import org.activiti.dmn.api.QueryProperty;
import org.activiti.dmn.engine.ActivitiDmnException;
import org.activiti.dmn.engine.ActivitiDmnIllegalArgumentException;
import org.activiti.dmn.engine.impl.DeploymentQueryProperty;
import org.activiti.rest.dmn.common.DataResponse;
import org.activiti.rest.dmn.service.api.DmnRestResponseFactory;
import org.activiti.rest.dmn.service.api.repository.DmnDeploymentResponse;
import org.activiti.rest.dmn.service.api.repository.DmnDeploymentsDmnPaginateList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
public class DmnDeploymentCollectionResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();
    @Autowired
    protected DmnRestResponseFactory dmnRestResponseFactory;
    @Autowired
    protected DmnRepositoryService dmnRepositoryService;

    @RequestMapping(value={"/dmn-repository/deployments"}, method={RequestMethod.GET}, produces={"application/json"})
    public DataResponse getDeployments(@RequestParam Map<String, String> allRequestParams) {
        Boolean withoutTenantId;
        DmnDeploymentQuery deploymentQuery = this.dmnRepositoryService.createDeploymentQuery();
        if (allRequestParams.containsKey("name")) {
            deploymentQuery.deploymentName(allRequestParams.get("name"));
        }
        if (allRequestParams.containsKey("nameLike")) {
            deploymentQuery.deploymentNameLike(allRequestParams.get("nameLike"));
        }
        if (allRequestParams.containsKey("category")) {
            deploymentQuery.deploymentCategory(allRequestParams.get("category"));
        }
        if (allRequestParams.containsKey("categoryNotEquals")) {
            deploymentQuery.deploymentCategoryNotEquals(allRequestParams.get("categoryNotEquals"));
        }
        if (allRequestParams.containsKey("tenantId")) {
            deploymentQuery.deploymentTenantId(allRequestParams.get("tenantId"));
        }
        if (allRequestParams.containsKey("tenantIdLike")) {
            deploymentQuery.deploymentTenantIdLike(allRequestParams.get("tenantIdLike"));
        }
        if (allRequestParams.containsKey("withoutTenantId") && (withoutTenantId = Boolean.valueOf(allRequestParams.get("withoutTenantId"))).booleanValue()) {
            deploymentQuery.deploymentWithoutTenantId();
        }
        DataResponse response = new DmnDeploymentsDmnPaginateList(this.dmnRestResponseFactory).paginateList(allRequestParams, (Query)deploymentQuery, "id", allowedSortProperties);
        return response;
    }

    @RequestMapping(value={"/dmn-repository/deployments"}, method={RequestMethod.POST}, produces={"application/json"})
    public DmnDeploymentResponse uploadDeployment(@RequestParam(value="tenantId", required=false) String tenantId, HttpServletRequest request, HttpServletResponse response) {
        if (!(request instanceof MultipartHttpServletRequest)) {
            throw new ActivitiDmnIllegalArgumentException("Multipart request is required");
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        if (multipartRequest.getFileMap().size() == 0) {
            throw new ActivitiDmnIllegalArgumentException("Multipart request with file content is required");
        }
        MultipartFile file = (MultipartFile)multipartRequest.getFileMap().values().iterator().next();
        try {
            DmnDeploymentBuilder deploymentBuilder = this.dmnRepositoryService.createDeployment();
            String fileName = file.getOriginalFilename();
            if (StringUtils.isEmpty((CharSequence)fileName) || !fileName.endsWith(".dmn") && !fileName.endsWith(".xml")) {
                fileName = file.getName();
            }
            if (!fileName.endsWith(".dmn") && !fileName.endsWith(".xml")) {
                throw new ActivitiDmnIllegalArgumentException("File must be of type .xml or .dmn");
            }
            deploymentBuilder.addInputStream(fileName, file.getInputStream());
            deploymentBuilder.name(fileName);
            if (tenantId != null) {
                deploymentBuilder.tenantId(tenantId);
            }
            DmnDeployment deployment = deploymentBuilder.deploy();
            response.setStatus(HttpStatus.CREATED.value());
            return this.dmnRestResponseFactory.createDmnDeploymentResponse(deployment);
        }
        catch (Exception e) {
            if (e instanceof ActivitiDmnException) {
                throw (ActivitiDmnException)e;
            }
            throw new ActivitiDmnException(e.getMessage(), (Throwable)e);
        }
    }

    static {
        allowedSortProperties.put("id", (QueryProperty)DeploymentQueryProperty.DEPLOYMENT_ID);
        allowedSortProperties.put("name", (QueryProperty)DeploymentQueryProperty.DEPLOYMENT_NAME);
        allowedSortProperties.put("deployTime", (QueryProperty)DeploymentQueryProperty.DEPLOY_TIME);
        allowedSortProperties.put("tenantId", (QueryProperty)DeploymentQueryProperty.DEPLOYMENT_TENANT_ID);
    }
}

