/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.transform;

import java.sql.Connection;
import java.sql.SQLException;
import junit.framework.TestCase;
import org.olap4j.Axis;
import org.olap4j.CellSet;
import org.olap4j.OlapConnection;
import org.olap4j.OlapStatement;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.parser.MdxParser;
import org.olap4j.test.TestContext;
import org.olap4j.transform.MdxQueryTransform;
import org.olap4j.transform.StandardTransformLibrary;

public class TransformTest
extends TestCase {
    private TestContext testContext = TestContext.instance();
    private TestContext.Tester tester = this.testContext.getTester();
    private Connection connection = null;

    protected void tearDown() throws Exception {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
            this.connection = null;
        }
        this.testContext = null;
        this.tester = null;
    }

    protected OlapConnection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.tester.createConnection();
        }
        return this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
    }

    protected OlapStatement getStatement() throws SQLException {
        return this.getConnection().createStatement();
    }

    public void assertTransformTo(String initialMdx, String expectedMdx, MdxQueryTransform trans) throws SQLException {
        OlapConnection olapConnection = this.getConnection();
        MdxParser mdxParser = olapConnection.getParserFactory().createMdxParser(olapConnection);
        SelectNode before = mdxParser.parseSelect(initialMdx);
        SelectNode after = trans.apply(before);
        SelectNode expected = mdxParser.parseSelect(expectedMdx);
        TransformTest.assertEquals((String)expected.toString(), (String)after.toString());
    }

    public void testDrillReplaceTransform() throws SQLException {
        String initialMdx = "SELECT {[Measures].[Unit Sales],         [Measures].[Store Cost],         [Measures].[Store Sales]} ON COLUMNS,        {[Product].[All Products]} ON ROWS FROM Sales WHERE ([Time].[1997])";
        String expectedMdx = "SELECT {[Measures].[Unit Sales],         [Measures].[Store Cost],         [Measures].[Store Sales]} ON COLUMNS,        {[Product].[Product].[All Products].Children} ON ROWS FROM Sales WHERE ([Time].[1997])";
        CellSet cellSet = this.getStatement().executeOlapQuery("SELECT {[Measures].[Unit Sales],         [Measures].[Store Cost],         [Measures].[Store Sales]} ON COLUMNS,        {[Product].[All Products]} ON ROWS FROM Sales WHERE ([Time].[1997])");
        MdxQueryTransform transform = StandardTransformLibrary.createDrillReplaceTransform((Axis)Axis.ROWS, (int)0, (int)0, (CellSet)cellSet);
        this.assertTransformTo("SELECT {[Measures].[Unit Sales],         [Measures].[Store Cost],         [Measures].[Store Sales]} ON COLUMNS,        {[Product].[All Products]} ON ROWS FROM Sales WHERE ([Time].[1997])", "SELECT {[Measures].[Unit Sales],         [Measures].[Store Cost],         [Measures].[Store Sales]} ON COLUMNS,        {[Product].[Product].[All Products].Children} ON ROWS FROM Sales WHERE ([Time].[1997])", transform);
    }

    public void testRollUpLevelTransform() throws SQLException {
        String initialMdx = "SELECT {[Measures].[Unit Sales],         [Measures].[Store Cost],         [Measures].[Store Sales]} ON COLUMNS,        {[Product].[All Products].[Food].[Deli]} ON ROWS FROM Sales WHERE ([Time].[1997])";
        String expectedMdx = "SELECT {[Measures].[Unit Sales],         [Measures].[Store Cost],         [Measures].[Store Sales]} ON COLUMNS,        {[Product].[Product].[Food].[Deli].Parent.Level.Members} ON ROWS FROM Sales WHERE ([Time].[1997])";
        CellSet cellSet = this.getStatement().executeOlapQuery("SELECT {[Measures].[Unit Sales],         [Measures].[Store Cost],         [Measures].[Store Sales]} ON COLUMNS,        {[Product].[All Products].[Food].[Deli]} ON ROWS FROM Sales WHERE ([Time].[1997])");
        MdxQueryTransform transform = StandardTransformLibrary.createRollUpLevelTransform((Axis)Axis.ROWS, (int)0, (int)0, (CellSet)cellSet);
        this.assertTransformTo("SELECT {[Measures].[Unit Sales],         [Measures].[Store Cost],         [Measures].[Store Sales]} ON COLUMNS,        {[Product].[All Products].[Food].[Deli]} ON ROWS FROM Sales WHERE ([Time].[1997])", "SELECT {[Measures].[Unit Sales],         [Measures].[Store Cost],         [Measures].[Store Sales]} ON COLUMNS,        {[Product].[Product].[Food].[Deli].Parent.Level.Members} ON ROWS FROM Sales WHERE ([Time].[1997])", transform);
    }

    public void _testDrillDownOnPositionTransform() throws SQLException {
        String initialMdx = "SELECT {[Measures].[Unit Sales],         [Measures].[Store Cost],         [Measures].[Store Sales]} ON COLUMNS,        {[Product].[All Products]} ON ROWS FROM Sales WHERE ([Time].[1997])";
        String expectedMdx = "SELECT {[Measures].[Unit Sales],         [Measures].[Store Cost],         [Measures].[Store Sales]} ON COLUMNS,        {[Product].[All Products].Children} ON ROWS FROM Sales WHERE ([Time].[1997])";
        CellSet cellSet = this.getStatement().executeOlapQuery("SELECT {[Measures].[Unit Sales],         [Measures].[Store Cost],         [Measures].[Store Sales]} ON COLUMNS,        {[Product].[All Products]} ON ROWS FROM Sales WHERE ([Time].[1997])");
        MdxQueryTransform transform = StandardTransformLibrary.createDrillDownOnPositionTransform((Axis)Axis.ROWS, (int)0, (int)0, (CellSet)cellSet);
        this.assertTransformTo("SELECT {[Measures].[Unit Sales],         [Measures].[Store Cost],         [Measures].[Store Sales]} ON COLUMNS,        {[Product].[All Products]} ON ROWS FROM Sales WHERE ([Time].[1997])", "SELECT {[Measures].[Unit Sales],         [Measures].[Store Cost],         [Measures].[Store Sales]} ON COLUMNS,        {[Product].[All Products].Children} ON ROWS FROM Sales WHERE ([Time].[1997])", transform);
    }
}

