/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.olap4j.impl.CoordinateIterator;
import org.olap4j.impl.IdentifierParser;
import org.olap4j.impl.LcidLocale;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.impl.Spacer;
import org.olap4j.impl.UnmodifiableArrayList;
import org.olap4j.mdx.IdentifierSegment;
import org.olap4j.mdx.KeySegment;
import org.olap4j.mdx.NameSegment;
import org.olap4j.mdx.ParseRegion;
import org.olap4j.mdx.Quoting;

public class Olap4jUtilTest
extends TestCase {
    public void assertEqualsArray(int[] expected, int[] actual) {
        if (expected == null) {
            Olap4jUtilTest.assertEquals((Object)expected, (Object)actual);
        } else {
            ArrayList<Integer> expectedList = new ArrayList<Integer>();
            for (int i : expected) {
                expectedList.add(i);
            }
            ArrayList<Integer> actualList = new ArrayList<Integer>();
            for (int i : actual) {
                actualList.add(i);
            }
            Olap4jUtilTest.assertEquals(expectedList, actualList);
        }
    }

    public void testCamel() {
        Olap4jUtilTest.assertEquals((String)"FOO_BAR", (String)Olap4jUtil.camelToUpper((String)"FooBar"));
        Olap4jUtilTest.assertEquals((String)"FOO_BAR", (String)Olap4jUtil.camelToUpper((String)"fooBar"));
        Olap4jUtilTest.assertEquals((String)"URL", (String)Olap4jUtil.camelToUpper((String)"URL"));
        Olap4jUtilTest.assertEquals((String)"URLTO_CLICK_ON", (String)Olap4jUtil.camelToUpper((String)"URLtoClickOn"));
        Olap4jUtilTest.assertEquals((String)"", (String)Olap4jUtil.camelToUpper((String)""));
    }

    public void testEqual() {
        Olap4jUtilTest.assertTrue((boolean)Olap4jUtil.equal((Object)"x", (Object)"x"));
        Olap4jUtilTest.assertFalse((boolean)Olap4jUtil.equal((Object)"x", (Object)"y"));
        Olap4jUtilTest.assertTrue((boolean)Olap4jUtil.equal((Object)"xy", (Object)"xy"));
        Olap4jUtilTest.assertTrue((boolean)Olap4jUtil.equal(null, null));
        Olap4jUtilTest.assertFalse((boolean)Olap4jUtil.equal(null, (Object)"x"));
        Olap4jUtilTest.assertFalse((boolean)Olap4jUtil.equal((Object)"x", null));
        Integer TWO = 2;
        Olap4jUtilTest.assertTrue((boolean)Olap4jUtil.equal((Object)2, (Object)TWO));
    }

    public void testWildcard() {
        Olap4jUtilTest.assertEquals((String)".\\QFoo\\E.|\\QBar\\E.*\\QBAZ\\E", (String)Olap4jUtil.wildcardToRegexp(Arrays.asList("_Foo_", "Bar%BAZ")));
    }

    public void testCoordinateIterator() {
        CoordinateIterator iter = new CoordinateIterator(new int[0]);
        Olap4jUtilTest.assertTrue((boolean)iter.hasNext());
        this.assertEqualsArray(iter.next(), new int[0]);
        iter = new CoordinateIterator(new int[]{2});
        Olap4jUtilTest.assertTrue((boolean)iter.hasNext());
        this.assertEqualsArray(iter.next(), new int[]{0});
        Olap4jUtilTest.assertTrue((boolean)iter.hasNext());
        this.assertEqualsArray(iter.next(), new int[]{1});
        Olap4jUtilTest.assertFalse((boolean)iter.hasNext());
        iter = new CoordinateIterator(new int[]{0});
        Olap4jUtilTest.assertFalse((boolean)iter.hasNext());
        iter = new CoordinateIterator(new int[]{0, 0});
        Olap4jUtilTest.assertFalse((boolean)iter.hasNext());
        iter = new CoordinateIterator(new int[]{0, 0, 0, 0, 0});
        Olap4jUtilTest.assertFalse((boolean)iter.hasNext());
        iter = new CoordinateIterator(new int[]{2, 3});
        Olap4jUtilTest.assertTrue((boolean)iter.hasNext());
        this.assertEqualsArray(iter.next(), new int[]{0, 0});
        Olap4jUtilTest.assertTrue((boolean)iter.hasNext());
        this.assertEqualsArray(iter.next(), new int[]{0, 1});
        Olap4jUtilTest.assertTrue((boolean)iter.hasNext());
        this.assertEqualsArray(iter.next(), new int[]{0, 2});
        Olap4jUtilTest.assertTrue((boolean)iter.hasNext());
        this.assertEqualsArray(iter.next(), new int[]{1, 0});
        Olap4jUtilTest.assertTrue((boolean)iter.hasNext());
        this.assertEqualsArray(iter.next(), new int[]{1, 1});
        Olap4jUtilTest.assertTrue((boolean)iter.hasNext());
        this.assertEqualsArray(iter.next(), new int[]{1, 2});
        Olap4jUtilTest.assertFalse((boolean)iter.hasNext());
        iter = new CoordinateIterator(new int[]{10, 0, 2});
        Olap4jUtilTest.assertFalse((boolean)iter.hasNext());
        iter = new CoordinateIterator(new int[]{0, 10, 2});
        Olap4jUtilTest.assertFalse((boolean)iter.hasNext());
        iter = new CoordinateIterator(new int[]{3, 4, 5, -6, 7});
        Olap4jUtilTest.assertFalse((boolean)iter.hasNext());
        iter = new CoordinateIterator(new int[]{3, 4, 5, 6, -7});
        Olap4jUtilTest.assertFalse((boolean)iter.hasNext());
        iter = new CoordinateIterator(new int[]{-3, 4, 5, 6, 7});
        Olap4jUtilTest.assertFalse((boolean)iter.hasNext());
    }

    public void testCoordinateIteratorLittleEndian() {
        CoordinateIterator iter = new CoordinateIterator(new int[]{2, 3}, true);
        Olap4jUtilTest.assertTrue((boolean)iter.hasNext());
        this.assertEqualsArray(iter.next(), new int[]{0, 0});
        Olap4jUtilTest.assertTrue((boolean)iter.hasNext());
        this.assertEqualsArray(iter.next(), new int[]{1, 0});
        Olap4jUtilTest.assertTrue((boolean)iter.hasNext());
        this.assertEqualsArray(iter.next(), new int[]{0, 1});
        Olap4jUtilTest.assertTrue((boolean)iter.hasNext());
        this.assertEqualsArray(iter.next(), new int[]{1, 1});
        Olap4jUtilTest.assertTrue((boolean)iter.hasNext());
        this.assertEqualsArray(iter.next(), new int[]{0, 2});
        Olap4jUtilTest.assertTrue((boolean)iter.hasNext());
        this.assertEqualsArray(iter.next(), new int[]{1, 2});
        Olap4jUtilTest.assertFalse((boolean)iter.hasNext());
    }

    public void testUnmodifiableArrayList() {
        Object[] a = new String[]{"x", "y"};
        UnmodifiableArrayList list = new UnmodifiableArrayList(a);
        UnmodifiableArrayList copyList = UnmodifiableArrayList.asCopyOf((Object[])a);
        Olap4jUtilTest.assertEquals((int)2, (int)list.size());
        Olap4jUtilTest.assertEquals((String)"x", (String)((String)list.get(0)));
        Olap4jUtilTest.assertEquals((String)"y", (String)((String)list.get(1)));
        try {
            String s = (String)list.get(2);
            Olap4jUtilTest.fail((String)("expected error, got " + s));
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        Olap4jUtilTest.assertTrue((boolean)list.equals((Object)copyList));
        Olap4jUtilTest.assertTrue((boolean)copyList.equals((Object)list));
        Olap4jUtilTest.assertTrue((boolean)list.equals((Object)list));
        Olap4jUtilTest.assertEquals((int)list.hashCode(), (int)copyList.hashCode());
        Olap4jUtilTest.assertEquals(Arrays.asList(a), (Object)list);
        Olap4jUtilTest.assertEquals((Object)list, Arrays.asList(a));
        String sum = "";
        for (String s : list) {
            sum = sum + s;
        }
        Olap4jUtilTest.assertEquals((String)"xy", (String)sum);
        Iterator iterator = list.iterator();
        Olap4jUtilTest.assertTrue((boolean)iterator.hasNext());
        Olap4jUtilTest.assertEquals((String)"x", (String)((String)iterator.next()));
        try {
            iterator.remove();
            Olap4jUtilTest.fail((String)"expected error");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        a[1] = "z";
        Olap4jUtilTest.assertTrue((boolean)iterator.hasNext());
        Olap4jUtilTest.assertEquals((String)"z", (String)((String)iterator.next()));
        Olap4jUtilTest.assertFalse((boolean)iterator.hasNext());
        Olap4jUtilTest.assertEquals((String)"z", (String)((String)list.get(1)));
        Olap4jUtilTest.assertEquals((String)"y", (String)((String)copyList.get(1)));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("foo");
        arrayList.add("bar");
        UnmodifiableArrayList list3 = UnmodifiableArrayList.of(arrayList);
        Olap4jUtilTest.assertEquals((int)2, (int)list3.size());
        Olap4jUtilTest.assertEquals(arrayList, (Object)list3);
        Olap4jUtilTest.assertEquals((int)arrayList.hashCode(), (int)list3.hashCode());
    }

    public void testUniqueNameToStringArray() {
        List a = Olap4jUtil.parseUniqueName((String)"foo.bar");
        Olap4jUtilTest.assertEquals((int)2, (int)a.size());
        Olap4jUtilTest.assertEquals((String)"foo", (String)((String)a.get(0)));
        Olap4jUtilTest.assertEquals((String)"bar", (String)((String)a.get(1)));
        a = Olap4jUtil.parseUniqueName((String)"[foo bar].[baz]");
        Olap4jUtilTest.assertEquals((int)2, (int)a.size());
        Olap4jUtilTest.assertEquals((String)"foo bar", (String)((String)a.get(0)));
        Olap4jUtilTest.assertEquals((String)"baz", (String)((String)a.get(1)));
        a = Olap4jUtil.parseUniqueName((String)"[foo.bar].[baz]");
        Olap4jUtilTest.assertEquals((int)3, (int)a.size());
        Olap4jUtilTest.assertEquals((String)"foo", (String)((String)a.get(0)));
        Olap4jUtilTest.assertEquals((String)"bar", (String)((String)a.get(1)));
        Olap4jUtilTest.assertEquals((String)"baz", (String)((String)a.get(2)));
        a = Olap4jUtil.parseUniqueName((String)"[customers].&[baz]&[2]");
        Olap4jUtilTest.assertEquals((int)5, (int)a.size());
        Olap4jUtilTest.assertEquals((String)"customers", (String)((String)a.get(0)));
        Olap4jUtilTest.assertEquals((String)"&", (String)((String)a.get(1)));
        Olap4jUtilTest.assertEquals((String)"baz", (String)((String)a.get(2)));
        Olap4jUtilTest.assertEquals((String)"&", (String)((String)a.get(3)));
        Olap4jUtilTest.assertEquals((String)"2", (String)((String)a.get(4)));
    }

    public void testParseFormattedCellValue() {
        this.checkParseFormattedCellValue("123", "123", "{}");
        this.checkParseFormattedCellValue("12|3", "12|3", "{}");
        this.checkParseFormattedCellValue("", "", "{}");
        this.checkParseFormattedCellValue("|123|style=red|", "123", "{style=red}");
        this.checkParseFormattedCellValue("|123|style=red|arrow=up|", "123", "{arrow=up, style=red}");
        this.checkParseFormattedCellValue("|123|style=red|arrow=asdas|", "123", "{arrow=asdas, style=red}");
        this.checkParseFormattedCellValue("||style=red|", "", "{style=red}");
        this.checkParseFormattedCellValue("|abc|style=|foo=bar|", "abc", "{foo=bar, style=}");
        this.checkParseFormattedCellValue("|abc|style=xx|foo=bar  baz|", "abcfoo=bar  baz", "{style=xx}");
        this.checkParseFormattedCellValue("|abc|style=xx|foo='bar  baz'|", "abc", "{foo=bar  baz, style=xx}");
        this.checkParseFormattedCellValue("|abc|style=xx|foo=baz=zz|", "abc", "{foo=baz=zz, style=xx}");
        this.checkParseFormattedCellValue("|abc|foo=bar", "abc", "{foo=bar}");
        try {
            String s = Olap4jUtil.parseFormattedCellValue(null, new HashMap());
            Olap4jUtilTest.fail((String)("expected NPE, got " + s));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void checkParseFormattedCellValue(String formattedCellValue, String expectedCellValue, String expectedProperties) {
        TreeMap map = new TreeMap();
        String cellValue = Olap4jUtil.parseFormattedCellValue((String)formattedCellValue, map);
        Olap4jUtilTest.assertEquals((String)"cell value", (String)expectedCellValue, (String)cellValue);
        Olap4jUtilTest.assertEquals((String)"properties", (String)expectedProperties, (String)map.toString());
    }

    public void testParseIdentifier() {
        List segments = IdentifierParser.parseIdentifier((String)"[string].[with].[a [bracket]] in it]");
        Olap4jUtilTest.assertEquals((int)3, (int)segments.size());
        Olap4jUtilTest.assertEquals((String)"a [bracket] in it", (String)((IdentifierSegment)segments.get(2)).getName());
        segments = IdentifierParser.parseIdentifier((String)"[Worklog].[All].[calendar-[LANGUAGE]].js]");
        Olap4jUtilTest.assertEquals((int)3, (int)segments.size());
        Olap4jUtilTest.assertEquals((String)"calendar-[LANGUAGE].js", (String)((IdentifierSegment)segments.get(2)).getName());
        segments = IdentifierParser.parseIdentifier((String)"  [foo] . [bar].[baz]  ");
        Olap4jUtilTest.assertEquals((int)3, (int)segments.size());
        Olap4jUtilTest.assertEquals((String)"foo", (String)((IdentifierSegment)segments.get(0)).getName());
        segments = IdentifierParser.parseIdentifier((String)"Time.1997.[Q3]");
        Olap4jUtilTest.assertEquals((int)3, (int)segments.size());
        Olap4jUtilTest.assertEquals((String)"Time", (String)((IdentifierSegment)segments.get(0)).getName());
        Olap4jUtilTest.assertEquals((String)"1997", (String)((IdentifierSegment)segments.get(1)).getName());
        Olap4jUtilTest.assertEquals((String)"Q3", (String)((IdentifierSegment)segments.get(2)).getName());
        segments = IdentifierParser.parseIdentifier((String)"[Time . Weekly ] . 1997 . [Q3]");
        Olap4jUtilTest.assertEquals((int)3, (int)segments.size());
        Olap4jUtilTest.assertEquals((String)"Time . Weekly ", (String)((IdentifierSegment)segments.get(0)).getName());
        Olap4jUtilTest.assertEquals((String)"1997", (String)((IdentifierSegment)segments.get(1)).getName());
        Olap4jUtilTest.assertEquals((String)"Q3", (String)((IdentifierSegment)segments.get(2)).getName());
        try {
            segments = IdentifierParser.parseIdentifier((String)"[foo].[bar].");
            Olap4jUtilTest.fail((String)("expected exception, got " + segments));
        }
        catch (IllegalArgumentException e) {
            Olap4jUtilTest.assertEquals((String)"Expected identifier after '.', in member identifier '[foo].[bar].'", (String)e.getMessage());
        }
        try {
            segments = IdentifierParser.parseIdentifier((String)"[foo].[bar");
            Olap4jUtilTest.fail((String)("expected exception, got " + segments));
        }
        catch (IllegalArgumentException e) {
            Olap4jUtilTest.assertEquals((String)"Expected ']', in member identifier '[foo].[bar'", (String)e.getMessage());
        }
        try {
            segments = IdentifierParser.parseIdentifier((String)"[Foo].[Bar], [Baz]");
            Olap4jUtilTest.fail((String)("expected exception, got " + segments));
        }
        catch (IllegalArgumentException e) {
            Olap4jUtilTest.assertEquals((String)"Invalid member identifier '[Foo].[Bar], [Baz]'", (String)e.getMessage());
        }
        segments = IdentifierParser.parseIdentifier((String)"[ProductFilterDim].[Product Main Group Name].&[Maingroup (xyz)]");
        Olap4jUtilTest.assertEquals((int)3, (int)segments.size());
        IdentifierSegment s0 = (IdentifierSegment)segments.get(0);
        Olap4jUtilTest.assertEquals((String)"ProductFilterDim", (String)s0.getName());
        Olap4jUtilTest.assertEquals((Object)Quoting.QUOTED, (Object)s0.getQuoting());
        IdentifierSegment s1 = (IdentifierSegment)segments.get(1);
        Olap4jUtilTest.assertEquals((String)"Product Main Group Name", (String)s1.getName());
        Olap4jUtilTest.assertEquals((Object)Quoting.QUOTED, (Object)s1.getQuoting());
        Olap4jUtilTest.assertTrue((boolean)(segments.get(2) instanceof KeySegment));
        KeySegment s2 = (KeySegment)segments.get(2);
        Olap4jUtilTest.assertEquals((int)1, (int)s2.getKeyParts().size());
        NameSegment s2k0 = (NameSegment)s2.getKeyParts().get(0);
        Olap4jUtilTest.assertEquals((String)"Maingroup (xyz)", (String)s2k0.getName());
        Olap4jUtilTest.assertEquals((Object)Quoting.QUOTED, (Object)s2k0.getQuoting());
    }

    public void testParseIdentifierAdvanced() {
        List segments = IdentifierParser.parseIdentifier((String)"[Customers].[City].&[San Francisco]&CA&USA.&[cust1234]");
        Olap4jUtilTest.assertEquals((int)4, (int)segments.size());
        IdentifierSegment s0 = (IdentifierSegment)segments.get(0);
        Olap4jUtilTest.assertEquals((String)"Customers", (String)s0.getName());
        Olap4jUtilTest.assertEquals((Object)Quoting.QUOTED, (Object)s0.getQuoting());
        IdentifierSegment s1 = (IdentifierSegment)segments.get(1);
        Olap4jUtilTest.assertEquals((String)"City", (String)s1.getName());
        Olap4jUtilTest.assertEquals((Object)Quoting.QUOTED, (Object)s1.getQuoting());
        Olap4jUtilTest.assertTrue((boolean)(segments.get(2) instanceof KeySegment));
        KeySegment s2 = (KeySegment)segments.get(2);
        Olap4jUtilTest.assertEquals((int)3, (int)s2.getKeyParts().size());
        NameSegment s2k0 = (NameSegment)s2.getKeyParts().get(0);
        Olap4jUtilTest.assertEquals((String)"San Francisco", (String)s2k0.getName());
        Olap4jUtilTest.assertEquals((Object)Quoting.QUOTED, (Object)s2k0.getQuoting());
        NameSegment s2k1 = (NameSegment)s2.getKeyParts().get(1);
        Olap4jUtilTest.assertEquals((String)"CA", (String)s2k1.getName());
        Olap4jUtilTest.assertEquals((Object)Quoting.UNQUOTED, (Object)s2k1.getQuoting());
        NameSegment s2k2 = (NameSegment)s2.getKeyParts().get(2);
        Olap4jUtilTest.assertEquals((String)"USA", (String)s2k2.getName());
        Olap4jUtilTest.assertEquals((Object)Quoting.UNQUOTED, (Object)s2k2.getQuoting());
        KeySegment s3 = (KeySegment)segments.get(3);
        Olap4jUtilTest.assertNull((Object)s3.getName());
        Olap4jUtilTest.assertEquals((int)1, (int)s3.getKeyParts().size());
        NameSegment s3k0 = (NameSegment)s3.getKeyParts().get(0);
        Olap4jUtilTest.assertEquals((String)"cust1234", (String)s3k0.getName());
        Olap4jUtilTest.assertEquals((Object)Quoting.QUOTED, (Object)s3k0.getQuoting());
    }

    public void testParseIdentifierAdvanced2() {
        List segments = IdentifierParser.parseIdentifier((String)"[Customers].[City].&[San Francisco]&[CA]&[USA].&[cust1234]");
        Olap4jUtilTest.assertEquals((int)4, (int)segments.size());
        IdentifierSegment s0 = (IdentifierSegment)segments.get(0);
        Olap4jUtilTest.assertEquals((String)"Customers", (String)s0.getName());
        Olap4jUtilTest.assertEquals((Object)Quoting.QUOTED, (Object)s0.getQuoting());
        IdentifierSegment s1 = (IdentifierSegment)segments.get(1);
        Olap4jUtilTest.assertEquals((String)"City", (String)s1.getName());
        Olap4jUtilTest.assertEquals((Object)Quoting.QUOTED, (Object)s1.getQuoting());
        Olap4jUtilTest.assertTrue((boolean)(segments.get(2) instanceof KeySegment));
        KeySegment s2 = (KeySegment)segments.get(2);
        Olap4jUtilTest.assertEquals((int)3, (int)s2.getKeyParts().size());
        NameSegment s2k0 = (NameSegment)s2.getKeyParts().get(0);
        Olap4jUtilTest.assertEquals((String)"San Francisco", (String)s2k0.getName());
        Olap4jUtilTest.assertEquals((Object)Quoting.QUOTED, (Object)s2k0.getQuoting());
        NameSegment s2k1 = (NameSegment)s2.getKeyParts().get(1);
        Olap4jUtilTest.assertEquals((String)"CA", (String)s2k1.getName());
        Olap4jUtilTest.assertEquals((Object)Quoting.QUOTED, (Object)s2k1.getQuoting());
        NameSegment s2k2 = (NameSegment)s2.getKeyParts().get(2);
        Olap4jUtilTest.assertEquals((String)"USA", (String)s2k2.getName());
        Olap4jUtilTest.assertEquals((Object)Quoting.QUOTED, (Object)s2k2.getQuoting());
        KeySegment s3 = (KeySegment)segments.get(3);
        Olap4jUtilTest.assertNull((Object)s3.getName());
        Olap4jUtilTest.assertEquals((int)1, (int)s3.getKeyParts().size());
        NameSegment s3k0 = (NameSegment)s3.getKeyParts().get(0);
        Olap4jUtilTest.assertEquals((String)"cust1234", (String)s3k0.getName());
        Olap4jUtilTest.assertEquals((Object)Quoting.QUOTED, (Object)s3k0.getQuoting());
    }

    public void testParseIdentifierList() {
        List list = IdentifierParser.parseIdentifierList((String)"{foo, baz.baz}");
        Olap4jUtilTest.assertEquals((int)2, (int)list.size());
        Olap4jUtilTest.assertEquals((int)1, (int)((List)list.get(0)).size());
        Olap4jUtilTest.assertEquals((int)2, (int)((List)list.get(1)).size());
        list = IdentifierParser.parseIdentifierList((String)"foo, baz.baz");
        Olap4jUtilTest.assertEquals((int)2, (int)list.size());
        list = IdentifierParser.parseIdentifierList((String)" {  foo , baz.baz }   ");
        Olap4jUtilTest.assertEquals((int)2, (int)list.size());
        list = IdentifierParser.parseIdentifierList((String)" {  foo , baz.baz }   ");
        Olap4jUtilTest.assertEquals((int)2, (int)list.size());
        list = IdentifierParser.parseIdentifierList((String)"{foo , baz.&k0&k1.&m0 . boo}");
        Olap4jUtilTest.assertEquals((int)2, (int)list.size());
        Olap4jUtilTest.assertEquals((int)1, (int)((List)list.get(0)).size());
        Olap4jUtilTest.assertEquals((int)4, (int)((List)list.get(1)).size());
        Olap4jUtilTest.assertEquals((String)"baz", (String)((IdentifierSegment)((List)list.get(1)).get(0)).getName());
        IdentifierSegment id1s1 = (IdentifierSegment)((List)list.get(1)).get(1);
        Olap4jUtilTest.assertEquals((int)2, (int)id1s1.getKeyParts().size());
        Olap4jUtilTest.assertEquals((String)"k0", (String)((NameSegment)id1s1.getKeyParts().get(0)).getName());
        Olap4jUtilTest.assertEquals((String)"k1", (String)((NameSegment)id1s1.getKeyParts().get(1)).getName());
        IdentifierSegment id1s2 = (IdentifierSegment)((List)list.get(1)).get(2);
        Olap4jUtilTest.assertEquals((int)1, (int)id1s2.getKeyParts().size());
        Olap4jUtilTest.assertEquals((String)"m0", (String)((NameSegment)id1s2.getKeyParts().get(0)).getName());
        Olap4jUtilTest.assertEquals((String)"boo", (String)((IdentifierSegment)((List)list.get(1)).get(3)).getName());
        Olap4jUtilTest.assertEquals((String)"[baz, &k0&k1, &m0, boo]", (String)((List)list.get(1)).toString());
        try {
            list = IdentifierParser.parseIdentifierList((String)" {  foo , baz.baz ");
            Olap4jUtilTest.fail((String)("expected error, got " + list));
        }
        catch (RuntimeException e) {
            Olap4jUtilTest.assertEquals((String)"mismatched '{' and '}' in ' {  foo , baz.baz '", (String)e.getMessage());
        }
        try {
            list = IdentifierParser.parseIdentifierList((String)"  foo , baz.baz } ");
            Olap4jUtilTest.fail((String)("expected error, got " + list));
        }
        catch (RuntimeException e) {
            Olap4jUtilTest.assertEquals((String)"mismatched '{' and '}' in '  foo , baz.baz } '", (String)e.getMessage());
        }
        list = IdentifierParser.parseIdentifierList((String)"{}");
        Olap4jUtilTest.assertEquals((int)0, (int)list.size());
        list = IdentifierParser.parseIdentifierList((String)" {  } ");
        Olap4jUtilTest.assertEquals((int)0, (int)list.size());
        list = IdentifierParser.parseIdentifierList((String)"");
        Olap4jUtilTest.assertEquals((int)0, (int)list.size());
        list = IdentifierParser.parseIdentifierList((String)" \t\n");
        Olap4jUtilTest.assertEquals((int)0, (int)list.size());
    }

    public void testParseTupleList() {
        final StringBuilder buf = new StringBuilder();
        IdentifierParser.Builder builder = new IdentifierParser.Builder(){

            public void tupleComplete() {
                buf.append("<tuple>");
            }

            public void memberComplete() {
                buf.append("<member>");
            }

            public void segmentComplete(ParseRegion region, String name, Quoting quoting, IdentifierParser.Builder.Syntax syntax) {
                if (quoting == Quoting.QUOTED) {
                    buf.append("[").append(name).append("]");
                } else {
                    buf.append(name);
                }
                buf.append("<").append(syntax).append(">");
            }
        };
        buf.setLength(0);
        IdentifierParser.parseTupleList((IdentifierParser.Builder)builder, (String)"{([Foo]), ([Bar].[Baz].&k0&[k1].&[k2])}");
        Olap4jUtilTest.assertEquals((String)"[Foo]<NAME><member><tuple>[Bar]<NAME>[Baz]<NAME>k0<FIRST_KEY>[k1]<NEXT_KEY>[k2]<FIRST_KEY><member><tuple>", (String)buf.toString());
        buf.setLength(0);
        try {
            IdentifierParser.parseTupleList((IdentifierParser.Builder)builder, (String)"{[Foo], [Bar].[Baz]}");
            Olap4jUtilTest.fail((String)"expected error");
        }
        catch (IllegalArgumentException e) {
            Olap4jUtilTest.assertEquals((String)"expected '(' at position 2 in '{[Foo], [Bar].[Baz]}'", (String)e.getMessage());
        }
        buf.setLength(0);
        try {
            IdentifierParser.parseTupleList((IdentifierParser.Builder)builder, (String)"{ }");
            Olap4jUtilTest.fail((String)"expected error");
        }
        catch (IllegalArgumentException e) {
            Olap4jUtilTest.assertEquals((String)"expected '(' at position 3 in '{ }'", (String)e.getMessage());
        }
        buf.setLength(0);
        try {
            IdentifierParser.parseTupleList((IdentifierParser.Builder)builder, (String)"");
            Olap4jUtilTest.fail((String)"expected error");
        }
        catch (IllegalArgumentException e) {
            Olap4jUtilTest.assertEquals((String)"expected '{' at position 1 in ''", (String)e.getMessage());
        }
        buf.setLength(0);
        try {
            IdentifierParser.parseTupleList((IdentifierParser.Builder)builder, (String)"{([A], [Tuple]), [A].Member}");
        }
        catch (IllegalArgumentException e) {
            Olap4jUtilTest.assertEquals((String)"expected '(' at position 18 in '{([A], [Tuple]), [A].Member}'", (String)e.getMessage());
        }
        buf.setLength(0);
        try {
            IdentifierParser.parseTupleList((IdentifierParser.Builder)builder, (String)"([A], [Tuple]), [A].Member");
        }
        catch (IllegalArgumentException e) {
            Olap4jUtilTest.assertEquals((String)"expected '{' at position 1 in '([A], [Tuple]), [A].Member'", (String)e.getMessage());
        }
    }

    public void testLcidToLocale() {
        Olap4jUtilTest.assertEquals((String)"en_US", (String)LcidLocale.lcidToLocale((short)1033).toString());
        Olap4jUtilTest.assertEquals((String)"en_US", (String)LcidLocale.lcidToLocale((short)1033).toString());
        Olap4jUtilTest.assertEquals((String)"fr_FR", (String)LcidLocale.lcidToLocale((short)1036).toString());
        Olap4jUtilTest.assertEquals((String)"en_GB", (String)LcidLocale.lcidToLocale((short)2057).toString());
    }

    public void testLocaleToLcid() {
        Olap4jUtilTest.assertEquals((int)1033, (int)LcidLocale.localeToLcid((Locale)Locale.US));
        Olap4jUtilTest.assertEquals((int)1033, (int)LcidLocale.localeToLcid((Locale)Locale.US));
        Olap4jUtilTest.assertEquals((int)12, (int)LcidLocale.localeToLcid((Locale)Locale.FRENCH));
        Olap4jUtilTest.assertEquals((int)1036, (int)LcidLocale.localeToLcid((Locale)Locale.FRANCE));
        Olap4jUtilTest.assertEquals((int)2060, (int)LcidLocale.localeToLcid((Locale)new Locale("fr", "BE")));
        Olap4jUtilTest.assertEquals((int)2057, (int)LcidLocale.localeToLcid((Locale)Locale.UK));
        Olap4jUtilTest.assertEquals((int)7, (int)LcidLocale.localeToLcid((Locale)Locale.GERMAN));
        Olap4jUtilTest.assertEquals((int)1031, (int)LcidLocale.localeToLcid((Locale)Locale.GERMANY));
        String s = Integer.toHexString(18441);
        Olap4jUtilTest.assertEquals((String)"4809", (String)s);
        Olap4jUtilTest.assertEquals((int)18441, (int)LcidLocale.localeToLcid((Locale)new Locale("en", "SG")));
        Olap4jUtilTest.assertEquals((int)9, (int)LcidLocale.localeToLcid((Locale)new Locale("en", "XX")));
        Olap4jUtilTest.assertEquals((int)3082, (int)LcidLocale.localeToLcid((Locale)new Locale("es", "ES")));
        Olap4jUtilTest.assertEquals((String)"es_ES", (String)LcidLocale.lcidToLocale((short)3082).toString());
    }

    public void testParseLocale() {
        String[] localeNames;
        Locale[] locales;
        for (Locale locale : locales = new Locale[]{Locale.CANADA, Locale.CANADA_FRENCH, Locale.getDefault(), Locale.US, Locale.TRADITIONAL_CHINESE}) {
            Olap4jUtilTest.assertEquals((Object)locale, (Object)LcidLocale.parseLocale((String)locale.toString()));
        }
        for (String localeName : localeNames = new String[]{"en", "de_DE", "_GB", "en_US_WIN", "de__POSIX", "fr__MAC"}) {
            Olap4jUtilTest.assertEquals((String)localeName, (String)LcidLocale.parseLocale((String)localeName).toString());
        }
    }

    public void testSpacer() {
        Spacer spacer = new Spacer();
        Olap4jUtilTest.assertEquals((String)"", (String)spacer.toString());
        spacer.add(2);
        Olap4jUtilTest.assertEquals((int)2, (int)spacer.toString().length());
        StringWriter stringWriter = new StringWriter();
        spacer.spaces(stringWriter);
        Olap4jUtilTest.assertEquals((int)2, (int)stringWriter.toString().length());
        try {
            spacer.spaces((Writer)stringWriter);
        }
        catch (IOException e) {
            throw new RuntimeException("fail", e);
        }
        Olap4jUtilTest.assertEquals((int)4, (int)stringWriter.toString().length());
        PrintWriter printWriter = new PrintWriter(stringWriter);
        spacer.spaces(printWriter);
        printWriter.flush();
        Olap4jUtilTest.assertEquals((int)6, (int)stringWriter.toString().length());
        StringBuilder stringBuilder = new StringBuilder();
        spacer.spaces(stringBuilder);
        Olap4jUtilTest.assertEquals((int)2, (int)stringBuilder.toString().length());
        spacer.add(3);
        Olap4jUtilTest.assertEquals((int)5, (int)spacer.toString().length());
        spacer.subtract(1);
        Olap4jUtilTest.assertEquals((int)4, (int)spacer.toString().length());
    }
}

