/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.impl;

import java.util.Map;
import junit.framework.TestCase;
import org.olap4j.impl.ConnectStringParser;
import org.olap4j.impl.Olap4jUtil;

public class ConnectStringParserTest
extends TestCase {
    public ConnectStringParserTest(String s) {
        super(s);
    }

    public void testParseConnectStringSimple() {
        Map properties = ConnectStringParser.parseConnectString((String)"foo=x;bar=y;foo=z");
        ConnectStringParserTest.assertEquals((String)"y", (String)((String)properties.get("bar")));
        ConnectStringParserTest.assertEquals((String)"y", (String)((String)properties.get("BAR")));
        ConnectStringParserTest.assertNull(properties.get(" bar"));
        ConnectStringParserTest.assertEquals((String)"z", (String)((String)properties.get("foo")));
        ConnectStringParserTest.assertNull(properties.get("kipper"));
        ConnectStringParserTest.assertEquals((int)2, (int)properties.size());
        ConnectStringParserTest.assertEquals((String)"foo=z; bar=y", (String)properties.toString());
    }

    public void testParseConnectStringComplex() {
        Map properties = ConnectStringParser.parseConnectString((String)"normalProp=value;emptyValue=; spaceBeforeProp=abc; spaceBeforeAndAfterProp =def; space in prop = foo bar ;equalsInValue=foo=bar;semiInProp;Name=value; singleQuotedValue = 'single quoted value ending in space ' ; doubleQuotedValue = \"=double quoted value preceded by equals\" ; singleQuotedValueWithSemi = 'one; two'; singleQuotedValueWithSpecials = 'one; two \"three''four=five'");
        ConnectStringParserTest.assertEquals((int)11, (int)properties.size());
        String value = (String)properties.get("normalProp");
        ConnectStringParserTest.assertEquals((String)"value", (String)value);
        value = (String)properties.get("emptyValue");
        ConnectStringParserTest.assertEquals((String)"", (String)value);
        value = (String)properties.get("spaceBeforeProp");
        ConnectStringParserTest.assertEquals((String)"abc", (String)value);
        value = (String)properties.get("spaceBeforeAndAfterProp");
        ConnectStringParserTest.assertEquals((String)"def", (String)value);
        value = (String)properties.get("space in prop");
        ConnectStringParserTest.assertEquals((String)value, (String)"foo bar");
        value = (String)properties.get("equalsInValue");
        ConnectStringParserTest.assertEquals((String)"foo=bar", (String)value);
        value = (String)properties.get("semiInProp;Name");
        ConnectStringParserTest.assertEquals((String)"value", (String)value);
        value = (String)properties.get("singleQuotedValue");
        ConnectStringParserTest.assertEquals((String)"single quoted value ending in space ", (String)value);
        value = (String)properties.get("doubleQuotedValue");
        ConnectStringParserTest.assertEquals((String)"=double quoted value preceded by equals", (String)value);
        value = (String)properties.get("singleQuotedValueWithSemi");
        ConnectStringParserTest.assertEquals((String)value, (String)"one; two");
        value = (String)properties.get("singleQuotedValueWithSpecials");
        ConnectStringParserTest.assertEquals((String)value, (String)"one; two \"three'four=five");
    }

    public void testConnectStringMore() {
        this.p("singleQuote=''''", "singleQuote", "'");
        this.p("doubleQuote=\"\"\"\"", "doubleQuote", "\"");
        this.p("empty= ;foo=bar", "empty", "");
    }

    public void testBug1938151() {
        Map properties = ConnectStringParser.parseConnectString((String)"foo=true; bar=xxx;");
        ConnectStringParserTest.assertEquals((int)2, (int)properties.size());
        properties = ConnectStringParser.parseConnectString((String)"foo=true; bar=xxx; ");
        ConnectStringParserTest.assertEquals((int)2, (int)properties.size());
        properties = ConnectStringParser.parseConnectString((String)"   ");
        ConnectStringParserTest.assertEquals((int)0, (int)properties.size());
        properties = ConnectStringParser.parseConnectString((String)"provider=mondrian; JdbcDrivers=org.hsqldb.jdbcDriver;Jdbc=jdbc:hsqldb:./sql/sampledata;Catalog=C:\\cygwin\\home\\src\\jfreereport\\engines\\classic\\extensions-mondrian\\demo\\steelwheels.mondrian.xml;JdbcUser=sa; JdbcPassword=; ");
        ConnectStringParserTest.assertEquals((int)6, (int)properties.size());
        ConnectStringParserTest.assertEquals((String)"", (String)((String)properties.get("JdbcPassword")));
    }

    void p(String connectString, String name, String expectedValue) {
        Map properties = ConnectStringParser.parseConnectString((String)connectString);
        String value = (String)properties.get(name);
        ConnectStringParserTest.assertEquals((String)expectedValue, (String)value);
    }

    public void testOleDbSpec() {
        this.p("Provider='MSDASQL'", "Provider", "MSDASQL");
        this.p("Provider='MSDASQL.1'", "Provider", "MSDASQL.1");
        this.p("Provider='MSDASQL';Location='3Northwind'", "Location", "3Northwind");
        this.p("Jet OLE DB:System Database=c:\\system.mda", "Jet OLE DB:System Database", "c:\\system.mda");
        this.p("Authentication;Info=Column 5", "Authentication;Info", "Column 5");
        this.p("Verification==Security=True", "Verification=Security", "True");
        this.p("Many====One=Valid", "Many==One", "Valid");
        this.p("TooMany===False", "TooMany=", "False");
        this.p("ExtendedProperties=\"Integrated Security='SSPI';Initial Catalog='Northwind'\"", "ExtendedProperties", "Integrated Security='SSPI';Initial Catalog='Northwind'");
        this.p("ExtendedProperties='Integrated Security=\"SSPI\";Databse=\"My Northwind DB\"'", "ExtendedProperties", "Integrated Security=\"SSPI\";Databse=\"My Northwind DB\"");
        this.p("DataSchema='\"MyCustTable\"'", "DataSchema", "\"MyCustTable\"");
        this.p("DataSchema=\"'MyOtherCustTable'\"", "DataSchema", "'MyOtherCustTable'");
        this.p("NewRecordsCaption='\"Company''s \"new\" customer\"'", "NewRecordsCaption", "\"Company's \"new\" customer\"");
        this.p("NewRecordsCaption=\"\"\"Company's \"\"new\"\" customer\"\"\"", "NewRecordsCaption", "\"Company's \"new\" customer\"");
        this.p("MyKeyword=My Value", "MyKeyword", "My Value");
        this.p("MyKeyword= My Value ;MyNextValue=Value", "MyKeyword", "My Value");
        this.p("MyKeyword=' My Value  '", "MyKeyword", " My Value  ");
        this.p("MyKeyword=\"  My Value \"", "MyKeyword", "  My Value ");
        this.p("Provider='MSDASQL';Location='Northwind';Cache Authentication='True';Prompt='Complete';Location='Customers'", "Location", "Customers");
        this.p("Provider='MSDASQL';Location='Northwind'; Provider='SQLOLEDB'", "Provider", "MSDASQL");
    }

    public void testBufReplace() {
        ConnectStringParserTest.checkReplace("xoxox", "x", "yy", "yyoyyoyy");
        ConnectStringParserTest.checkReplace("xxoxxoxx", "xx", "z", "zozoz");
        ConnectStringParserTest.checkReplace("xxoxxoxx", "xx", "", "oo");
        ConnectStringParserTest.checkReplace("xox", "x", "xx", "xxoxx");
        ConnectStringParserTest.checkReplace("cacab", "cab", "bb", "cabb");
        ConnectStringParserTest.checkReplace("the quick brown fox", "coyote", "wolf", "the quick brown fox");
        ConnectStringParserTest.checkReplace("", "coyote", "wolf", "");
        ConnectStringParserTest.checkReplace("fox", "", "dog", "dogfdogodogxdog");
    }

    private static void checkReplace(String original, String seek, String replace, String expected) {
        ConnectStringParserTest.assertEquals((String)expected, (String)original.replaceAll(seek, replace));
        StringBuilder buf = new StringBuilder(original);
        StringBuilder buf2 = Olap4jUtil.replace((StringBuilder)buf, (int)0, (String)seek, (String)replace);
        ConnectStringParserTest.assertTrue((buf == buf2 ? 1 : 0) != 0);
        ConnectStringParserTest.assertEquals((String)expected, (String)buf.toString());
        ConnectStringParserTest.assertEquals((String)expected, (String)Olap4jUtil.replace((String)original, (String)seek, (String)replace));
    }
}

