/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;
import junit.framework.TestCase;
import org.olap4j.impl.Base64;

public class Base64Test
extends TestCase {
    private static final long SEED = 12345678L;
    private static Random s_random = new Random(12345678L);

    private byte[] createData(int length) throws Exception {
        byte[] bytes = new byte[length];
        s_random.nextBytes(bytes);
        return bytes;
    }

    private void runStreamTest(int length) throws Exception {
        byte[] data = this.createData(length);
        ByteArrayOutputStream out_bytes = new ByteArrayOutputStream();
        Base64.OutputStream out = new Base64.OutputStream((OutputStream)out_bytes);
        out.write(data);
        out.close();
        byte[] encoded = out_bytes.toByteArray();
        byte[] decoded = Base64.decode((byte[])encoded, (int)0, (int)encoded.length);
        Base64Test.assertTrue((boolean)Arrays.equals(data, decoded));
        Base64.InputStream in = new Base64.InputStream((InputStream)new ByteArrayInputStream(encoded));
        out_bytes = new ByteArrayOutputStream();
        byte[] buffer = new byte[3];
        int n = in.read(buffer);
        while (n > 0) {
            out_bytes.write(buffer, 0, n);
            n = in.read(buffer);
        }
        out_bytes.close();
        in.close();
        decoded = out_bytes.toByteArray();
        Base64Test.assertTrue((boolean)Arrays.equals(data, decoded));
    }

    public void testStreams() throws Exception {
        int i;
        for (i = 0; i < 100; ++i) {
            this.runStreamTest(i);
        }
        for (i = 100; i < 2000; i += 250) {
            this.runStreamTest(i);
        }
        for (i = 2000; i < 80000; i += 1000) {
            this.runStreamTest(i);
        }
    }

    public void testSimple() {
        String s = "Man is distinguished, not only by his reason, but by this singular passion from other animals, which is a lust of the mind, that by a perseverance of delight in the continued and indefatigable generation of knowledge, exceeds the short vehemence of any carnal pleasure.";
        String encoded = Base64.encodeBytes((byte[])s.getBytes());
        String expected = "TWFuIGlzIGRpc3Rpbmd1aXNoZWQsIG5vdCBvbmx5IGJ5IGhpcyByZWFzb24sIGJ1dCBieSB0aGlz\nIHNpbmd1bGFyIHBhc3Npb24gZnJvbSBvdGhlciBhbmltYWxzLCB3aGljaCBpcyBhIGx1c3Qgb2Yg\ndGhlIG1pbmQsIHRoYXQgYnkgYSBwZXJzZXZlcmFuY2Ugb2YgZGVsaWdodCBpbiB0aGUgY29udGlu\ndWVkIGFuZCBpbmRlZmF0aWdhYmxlIGdlbmVyYXRpb24gb2Yga25vd2xlZGdlLCBleGNlZWRzIHRo\nZSBzaG9ydCB2ZWhlbWVuY2Ugb2YgYW55IGNhcm5hbCBwbGVhc3VyZS4=";
        Base64Test.assertEquals((String)expected, (String)encoded);
        byte[] s1 = Base64.decode((String)encoded);
        this.assertEqualsByteArray(s.getBytes(), s1);
    }

    private void assertEqualsByteArray(byte[] bytes, byte[] bytes1) {
        Base64Test.assertEquals((int)bytes.length, (int)bytes1.length);
        for (int i = 0; i < bytes.length; ++i) {
            Base64Test.assertEquals((byte)bytes[i], (byte)bytes1[i]);
        }
    }
}

