/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.olap4j.driver.xmla.XmlaOlap4jDriver;
import org.olap4j.driver.xmla.proxy.XmlaOlap4jProxy;
import org.olap4j.test.TestContext;

public class XmlaTester
implements TestContext.Tester {
    private final TestContext testContext;
    final XmlaOlap4jProxy proxy;
    static final String cookie = XmlaOlap4jDriver.nextCookie();
    private Connection connection;
    public static final String DRIVER_CLASS_NAME = "org.olap4j.driver.xmla.XmlaOlap4jDriver";
    public static final String DRIVER_URL_PREFIX = "jdbc:xmla:";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static String PROXY_CLASS_NAME = "mondrian.olap4j.MondrianInprocProxy";

    public XmlaTester(TestContext testContext) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        this.testContext = testContext;
        Properties properties = testContext.getProperties();
        String catalogUrl = properties.getProperty(TestContext.Property.XMLA_CATALOG_URL.path, "http://foo");
        HashMap<String, String> catalogNameUrls = new HashMap<String, String>();
        catalogNameUrls.put("FoodMart", catalogUrl);
        catalogNameUrls.put("FoodMart2", catalogUrl);
        String urlString = properties.getProperty(TestContext.Property.CONNECT_URL.path, "jdbc:mondrian:");
        Class<?> clazz = Class.forName(XmlaTester.getProxyClassName());
        Constructor<?> constructor = clazz.getConstructor(Map.class, String.class);
        this.proxy = (XmlaOlap4jProxy)constructor.newInstance(catalogNameUrls, urlString);
        XmlaOlap4jDriver.PROXY_MAP.put(cookie, this.proxy);
    }

    public TestContext getTestContext() {
        return this.testContext;
    }

    public Connection createConnection() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        try {
            Class.forName(DRIVER_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("oops", e);
        }
        Properties info = new Properties();
        info.setProperty(XmlaOlap4jDriver.Property.CATALOG.name(), "FoodMart");
        this.connection = DriverManager.getConnection(this.getURL(), info);
        return this.connection;
    }

    public Connection createConnectionWithUserPassword() throws SQLException {
        Properties props = new Properties();
        return this.createConnectionWithUserPassword(props);
    }

    public Connection createConnectionWithUserPassword(Properties props) throws SQLException {
        try {
            Class.forName(DRIVER_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("oops", e);
        }
        props.setProperty(XmlaOlap4jDriver.Property.CATALOG.name(), "FoodMart");
        if (USER != null) {
            props.put(USER, USER);
        }
        if (PASSWORD != null) {
            props.put(PASSWORD, PASSWORD);
        }
        return DriverManager.getConnection(this.getURL(), props);
    }

    public String getDriverUrlPrefix() {
        return DRIVER_URL_PREFIX;
    }

    public String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    public String getURL() {
        return "jdbc:xmla:Server=http://foo;Catalog=FoodMart;TestProxyCookie=" + cookie;
    }

    public TestContext.Tester.Flavor getFlavor() {
        return TestContext.Tester.Flavor.XMLA;
    }

    public TestContext.Wrapper getWrapper() {
        return TestContext.Wrapper.NONE;
    }

    public static void setProxyClassName(String clazz) {
        PROXY_CLASS_NAME = clazz;
    }

    public static String getProxyClassName() {
        return PROXY_CLASS_NAME;
    }
}

