/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import mondrian.olap.MondrianProperties;
import org.olap4j.Axis;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.CellSetAxisMetaData;
import org.olap4j.CellSetMetaData;
import org.olap4j.OlapConnection;
import org.olap4j.OlapDatabaseMetaData;
import org.olap4j.OlapException;
import org.olap4j.OlapParameterMetaData;
import org.olap4j.OlapStatement;
import org.olap4j.OlapWrapper;
import org.olap4j.Position;
import org.olap4j.PreparedOlapStatement;
import org.olap4j.driver.xmla.XmlaOlap4jDriver;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.mdx.AxisNode;
import org.olap4j.mdx.CallNode;
import org.olap4j.mdx.CubeNode;
import org.olap4j.mdx.HierarchyNode;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.IdentifierSegment;
import org.olap4j.mdx.LiteralNode;
import org.olap4j.mdx.MemberNode;
import org.olap4j.mdx.NameSegment;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.mdx.PropertyValueNode;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.Syntax;
import org.olap4j.mdx.WithMemberNode;
import org.olap4j.mdx.parser.MdxParser;
import org.olap4j.mdx.parser.MdxParserFactory;
import org.olap4j.mdx.parser.MdxValidator;
import org.olap4j.metadata.Catalog;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Datatype;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.NamedSet;
import org.olap4j.metadata.Property;
import org.olap4j.metadata.Schema;
import org.olap4j.test.TestContext;
import org.olap4j.type.CubeType;
import org.olap4j.type.MemberType;
import org.olap4j.type.SetType;
import org.olap4j.type.TupleType;
import org.olap4j.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionTest
extends TestCase {
    private TestContext testContext = TestContext.instance();
    private TestContext.Tester tester = this.testContext.getTester();
    private static final boolean IS_JDK_16 = System.getProperty("java.version").startsWith("1.6.");
    private Connection connection;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
        this.connection = null;
        this.testContext = null;
        this.tester = null;
    }

    public void testDriver() throws ClassNotFoundException, SQLException {
        Class<?> clazz = Class.forName(this.tester.getDriverClassName());
        ConnectionTest.assertNotNull(clazz);
        ConnectionTest.assertTrue((boolean)Driver.class.isAssignableFrom(clazz));
        Driver driver = DriverManager.getDriver(this.tester.getDriverUrlPrefix());
        ConnectionTest.assertNotNull((Object)driver);
        DriverManager.deregisterDriver(driver);
        try {
            Driver driver2 = DriverManager.getDriver(this.tester.getDriverUrlPrefix());
            ConnectionTest.fail((String)("expected error, got " + driver2));
        }
        catch (SQLException e) {
            ConnectionTest.assertEquals((String)"No suitable driver", (String)e.getMessage());
        }
        DriverManager.registerDriver(driver);
        Driver driver3 = DriverManager.getDriver(this.tester.getDriverUrlPrefix());
        ConnectionTest.assertNotNull((Object)driver3);
        int majorVersion = driver.getMajorVersion();
        int minorVersion = driver.getMinorVersion();
        ConnectionTest.assertTrue((majorVersion >= 0 ? 1 : 0) != 0);
        ConnectionTest.assertTrue((minorVersion >= 0 ? 1 : 0) != 0);
        ConnectionTest.assertTrue((majorVersion > 0 || minorVersion > 0 ? 1 : 0) != 0);
        DriverPropertyInfo[] driverPropertyInfos = driver.getPropertyInfo(this.tester.getDriverUrlPrefix(), new Properties());
        switch (this.tester.getFlavor()) {
            case XMLA: 
            case REMOTE_XMLA: {
                break;
            }
            default: {
                ConnectionTest.assertTrue((driverPropertyInfos.length > 0 ? 1 : 0) != 0);
            }
        }
    }

    void assertIsValid(Connection connection, int timeout) {
        if (!IS_JDK_16) {
            return;
        }
        try {
            java.lang.reflect.Method method = Connection.class.getMethod("isValid", Integer.TYPE);
            Boolean b = (Boolean)method.invoke((Object)connection, timeout);
            ConnectionTest.assertTrue((boolean)b);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof AbstractMethodError) {
                Olap4jUtil.discard((Object)e);
            }
            throw new RuntimeException(e);
        }
        catch (AbstractMethodError e) {
            Olap4jUtil.discard((Object)e);
        }
    }

    void assertIsClosed(Object o, boolean b) {
        if (!IS_JDK_16) {
            return;
        }
        if (this.tester.getWrapper() == TestContext.Wrapper.DBCP) {
            return;
        }
        try {
            Class clazz;
            if (o instanceof Statement) {
                clazz = Statement.class;
            } else if (o instanceof ResultSet) {
                clazz = ResultSet.class;
            } else if (o instanceof Connection) {
                clazz = Connection.class;
            } else {
                throw new AssertionFailedError("not a statement, resultSet or connection");
            }
            java.lang.reflect.Method method = clazz.getMethod("isClosed", new Class[0]);
            Boolean closed = (Boolean)method.invoke(o, new Object[0]);
            if (b) {
                ConnectionTest.assertTrue((boolean)closed);
            } else {
                ConnectionTest.assertFalse((boolean)closed);
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void testConnection() throws ClassNotFoundException, SQLException {
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        ConnectionTest.assertNotNull((Object)this.connection);
        ConnectionTest.assertFalse((boolean)this.connection.isClosed());
        this.assertIsValid(this.connection, 0);
        this.assertIsValid(this.connection, 60);
        this.connection.close();
        ConnectionTest.assertTrue((boolean)this.connection.isClosed());
        switch (this.tester.getWrapper()) {
            case DBCP: {
                break;
            }
            default: {
                this.connection.close();
            }
        }
        switch (this.tester.getFlavor()) {
            case MONDRIAN: {
                this.connection = this.tester.createConnectionWithUserPassword();
                ConnectionTest.assertNotNull((Object)this.connection);
                this.connection.close();
                ConnectionTest.assertTrue((boolean)this.connection.isClosed());
                this.connection = DriverManager.getConnection(this.tester.getURL());
                ConnectionTest.assertNotNull((Object)this.connection);
                this.connection.close();
                break;
            }
            case XMLA: {
                break;
            }
            case REMOTE_XMLA: {
                this.connection = this.tester.createConnectionWithUserPassword();
                ConnectionTest.assertNotNull((Object)this.connection);
                this.connection = DriverManager.getConnection(this.tester.getURL());
                ConnectionTest.assertNotNull((Object)this.connection);
                this.connection.close();
            }
        }
        ConnectionTest.assertTrue((boolean)this.connection.isClosed());
    }

    public void testConnectionUnwrap() throws SQLException {
        switch (this.tester.getWrapper()) {
            case DBCP: {
                return;
            }
        }
        this.connection = this.tester.createConnection();
        ConnectionTest.assertTrue((boolean)((OlapWrapper)this.connection).isWrapperFor(Connection.class));
        Connection connection2 = (Connection)((OlapWrapper)this.connection).unwrap(Connection.class);
        ConnectionTest.assertEquals((Object)connection2, (Object)this.connection);
        ConnectionTest.assertTrue((boolean)((OlapWrapper)this.connection).isWrapperFor(Object.class));
        Object object = ((OlapWrapper)this.connection).unwrap(Object.class);
        ConnectionTest.assertEquals((Object)object, (Object)this.connection);
        ConnectionTest.assertFalse((boolean)((OlapWrapper)this.connection).isWrapperFor(Writer.class));
        try {
            Writer writer = (Writer)((OlapWrapper)this.connection).unwrap(Writer.class);
            ConnectionTest.fail((String)("expected exception, got writer" + writer));
        }
        catch (SQLException e) {
            ConnectionTest.assertTrue((boolean)e.getMessage().contains("does not implement"));
        }
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        Locale locale = olapConnection.getLocale();
        ConnectionTest.assertEquals((Object)locale, (Object)Locale.getDefault());
        olapConnection.setLocale(Locale.CANADA_FRENCH);
        ConnectionTest.assertEquals((Object)olapConnection.getLocale(), (Object)Locale.CANADA_FRENCH);
        OlapDatabaseMetaData metaData = olapConnection.getMetaData();
        String databaseName = metaData.getDatabaseProductName();
        String databaseVersion = metaData.getDatabaseProductVersion();
        if (databaseName.equals("Mondrian XML for Analysis Provider") && databaseVersion.compareTo("3.3") > 0) {
            olapConnection.setLocale(Locale.US);
            Cube salesCubeUs = (Cube)olapConnection.getOlapSchema().getCubes().get("Sales");
            ConnectionTest.assertEquals((String)"Sales", (String)salesCubeUs.getCaption());
            olapConnection.setLocale(Locale.GERMANY);
            Cube salesCubeGerman = (Cube)olapConnection.getOlapSchema().getCubes().get("Sales");
            ConnectionTest.assertEquals((String)"Verkaufen", (String)salesCubeGerman.getCaption());
            ConnectionTest.assertEquals((String)"Cube Verkaufen", (String)salesCubeGerman.getDescription());
            olapConnection.setLocale(Locale.FRANCE);
            Cube salesCubeFrance = (Cube)olapConnection.getOlapSchema().getCubes().get("Sales");
            ConnectionTest.assertEquals((String)"Ventes", (String)salesCubeFrance.getCaption());
            ConnectionTest.assertEquals((String)"Cube des ventes", (String)salesCubeFrance.getDescription());
            ConnectionTest.assertEquals((String)"Sales", (String)salesCubeUs.getCaption());
            olapConnection.setLocale(Locale.US);
        }
        try {
            olapConnection.setLocale(null);
            ConnectionTest.fail((String)"expected exception");
        }
        catch (IllegalArgumentException e) {
            olapConnection.setLocale(Locale.getDefault());
        }
        String s = olapConnection.getRoleName();
        olapConnection.setRoleName(null);
        ConnectionTest.assertNull((Object)olapConnection.getRoleName());
        olapConnection.setRoleName(s);
        List roleNames = olapConnection.getAvailableRoleNames();
        if (roleNames != null && s != null) {
            ConnectionTest.assertTrue((String)("role name " + s + " should be in available role names " + roleNames), (boolean)roleNames.contains(s));
        }
        switch (this.tester.getFlavor()) {
            case MONDRIAN: {
                Class<?> mondrianConnectionClass;
                try {
                    mondrianConnectionClass = Class.forName("mondrian.olap.Connection");
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                Object mondrianConnection = ((OlapWrapper)this.connection).unwrap(mondrianConnectionClass);
                ConnectionTest.assertNotNull((Object)mondrianConnection);
                assert (mondrianConnectionClass.isInstance(mondrianConnection));
                break;
            }
        }
    }

    public void testXmlaCatalogParameter() throws Exception {
        if (this.tester.getFlavor() == TestContext.Tester.Flavor.XMLA || this.tester.getFlavor() == TestContext.Tester.Flavor.REMOTE_XMLA) {
            Properties info = new Properties();
            this.connection = DriverManager.getConnection(this.tester.getURL().replaceFirst("\\;Catalog=FoodMart", ""), info);
            ConnectionTest.assertEquals((String)"FoodMart", (String)this.connection.getCatalog());
            NamedList catalogs = ((OlapConnection)this.connection).getOlapCatalogs();
            ConnectionTest.assertNotNull((Object)catalogs);
            Statement statement = this.connection.createStatement();
            OlapStatement olapStatement = TestContext.Wrapper.NONE.unwrap(statement, OlapStatement.class);
            ConnectionTest.assertSame((Object)this.connection, (Object)olapStatement.getConnection());
            CellSet cellSet = olapStatement.executeOlapQuery("SELECT FROM [Sales]");
            ConnectionTest.assertSame((Object)statement, (Object)cellSet.getStatement());
            List axesList = cellSet.getAxes();
            ConnectionTest.assertNotNull((Object)axesList);
            ConnectionTest.assertEquals((int)0, (int)axesList.size());
            info.setProperty(XmlaOlap4jDriver.Property.CATALOG.name(), "FoodMart");
            this.connection = DriverManager.getConnection(this.tester.getURL().replaceFirst("\\;Catalog=FoodMart", ""), info);
            ConnectionTest.assertEquals((String)"FoodMart", (String)this.connection.getCatalog());
            info.setProperty(XmlaOlap4jDriver.Property.CATALOG.name(), "FoodMartError");
            try {
                this.connection = DriverManager.getConnection(this.tester.getURL().replaceFirst("\\;Catalog=FoodMart", ""), info);
                Statement statement2 = this.connection.createStatement();
                OlapStatement olapStatement2 = TestContext.Wrapper.NONE.unwrap(statement2, OlapStatement.class);
                olapStatement2.executeOlapQuery("SELECT FROM [Sales]");
                ConnectionTest.fail();
            }
            catch (OlapException e) {
                // empty catch block
            }
        }
    }

    public void testDatabaseMetaData() throws SQLException {
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        OlapDatabaseMetaData databaseMetaData = olapConnection.getMetaData();
        Driver driver = DriverManager.getDriver(this.tester.getDriverUrlPrefix());
        ConnectionTest.assertNotNull((Object)driver);
        ConnectionTest.assertEquals((int)databaseMetaData.getDriverMajorVersion(), (int)driver.getMajorVersion());
        ConnectionTest.assertEquals((int)databaseMetaData.getDriverMinorVersion(), (int)driver.getMinorVersion());
        String driverName = databaseMetaData.getDriverName();
        ConnectionTest.assertTrue((driverName != null && driverName.length() > 10 ? 1 : 0) != 0);
        String driverVersion = databaseMetaData.getDriverVersion();
        ConnectionTest.assertTrue((driverVersion != null && driverName.length() > 2 ? 1 : 0) != 0);
    }

    public void testStatement() throws SQLException {
        this.connection = this.tester.createConnection();
        Statement statement = this.connection.createStatement();
        this.assertIsClosed(statement, false);
        statement.close();
        this.assertIsClosed(statement, true);
        statement.close();
        this.assertIsClosed(statement, true);
        statement = this.connection.createStatement();
        OlapStatement olapStatement = this.tester.getWrapper().unwrap(statement, OlapStatement.class);
        ConnectionTest.assertNotNull((Object)olapStatement);
        CellSet cellSet = olapStatement.executeOlapQuery("SELECT FROM [Sales]");
        List axesList = cellSet.getAxes();
        ConnectionTest.assertNotNull((Object)axesList);
        ConnectionTest.assertEquals((int)0, (int)axesList.size());
        this.assertIsClosed(statement, false);
        this.assertIsClosed(cellSet, false);
        CellSet cellSet2 = olapStatement.executeOlapQuery("SELECT FROM [Sales]");
        this.assertIsClosed(statement, false);
        this.assertIsClosed(cellSet, true);
        this.assertIsClosed(cellSet2, false);
        statement.close();
        this.assertIsClosed(statement, true);
        this.assertIsClosed(cellSet2, true);
        cellSet.close();
        this.assertIsClosed(statement, true);
        this.assertIsClosed(cellSet2, true);
        this.assertIsClosed(cellSet, true);
        this.connection.close();
    }

    public void testAxes() throws SQLException {
        this.connection = this.tester.createConnection();
        Statement statement = this.connection.createStatement();
        OlapStatement olapStatement = this.tester.getWrapper().unwrap(statement, OlapStatement.class);
        CellSet cellSet = olapStatement.executeOlapQuery("SELECT {[Measures].[Unit Sales]} on 0,\n{[Store].Children} on 1\nFROM [Sales]\nWHERE ([Time].[1997].[Q1], [Gender].[F])");
        List axesList = cellSet.getAxes();
        ConnectionTest.assertEquals((int)2, (int)axesList.size());
        Member rowsMember = (Member)((Position)((CellSetAxis)axesList.get(0)).getPositions().get(0)).getMembers().get(0);
        ConnectionTest.assertTrue((String)rowsMember.getUniqueName(), (boolean)(rowsMember instanceof Measure));
        Member columnsMember = (Member)((Position)((CellSetAxis)axesList.get(1)).getPositions().get(0)).getMembers().get(0);
        ConnectionTest.assertTrue((String)columnsMember.getUniqueName(), (!(columnsMember instanceof Measure) ? 1 : 0) != 0);
        CellSetAxis filterAxis = cellSet.getFilterAxis();
        ConnectionTest.assertEquals((int)1, (int)filterAxis.getPositionCount());
        List positions = filterAxis.getPositions();
        ConnectionTest.assertEquals((int)1, (int)positions.size());
        Position pos0 = (Position)positions.get(0);
        ConnectionTest.assertEquals((int)0, (int)pos0.getOrdinal());
        ConnectionTest.assertEquals((int)2, (int)pos0.getMembers().size());
        ConnectionTest.assertEquals((String)"Q1", (String)((Member)pos0.getMembers().get(0)).getName());
        ConnectionTest.assertEquals((String)"F", (String)((Member)pos0.getMembers().get(1)).getName());
        CellSet cellSetNoSlicer = olapStatement.executeOlapQuery("SELECT {[Measures].[Unit Sales]} on 0,\n{[Store].Children} on 1\nFROM [Sales]");
        ConnectionTest.assertEquals((int)2, (int)cellSetNoSlicer.getAxes().size());
        CellSetAxis filterAxisNoSlicer = cellSetNoSlicer.getFilterAxis();
        ConnectionTest.assertNotNull((Object)filterAxisNoSlicer);
        ConnectionTest.assertEquals((int)1, (int)filterAxisNoSlicer.getPositionCount());
        Position position = (Position)filterAxisNoSlicer.getPositions().get(0);
        ConnectionTest.assertEquals((int)0, (int)position.getMembers().size());
    }

    public void testCompoundFilter() throws SQLException {
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        OlapStatement statement = olapConnection.createStatement();
        CellSet cellSet = statement.executeOlapQuery("SELECT {[Measures].[Unit Sales]} on 0,\n{[Product].Children} on 1\nFROM [Sales]\nWHERE [Time].[1997].[Q1] * [Gender].Members");
        List axesList = cellSet.getAxes();
        ConnectionTest.assertEquals((int)2, (int)axesList.size());
        CellSetAxis filterAxis = cellSet.getFilterAxis();
        ConnectionTest.assertEquals((int)3, (int)filterAxis.getPositionCount());
        List filterPositions = filterAxis.getPositions();
        ConnectionTest.assertEquals((int)3, (int)filterPositions.size());
        Position filterPosition = (Position)filterPositions.get(2);
        ConnectionTest.assertEquals((int)2, (int)filterPosition.getMembers().size());
        ConnectionTest.assertEquals((String)"M", (String)((Member)filterPosition.getMembers().get(1)).getName());
    }

    public void testEmptyFilter() throws SQLException {
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        OlapStatement statement = olapConnection.createStatement();
        CellSet cellSet = statement.executeOlapQuery("SELECT {[Measures].[Unit Sales]} on 0,\n{[Product].Children} on 1\nFROM [Sales]\nWHERE [Time].[1997].[Q1] * [Gender].Parent");
        List axesList = cellSet.getAxes();
        ConnectionTest.assertEquals((int)2, (int)axesList.size());
        CellSetAxis filterAxis = cellSet.getFilterAxis();
        ConnectionTest.assertEquals((int)0, (int)filterAxis.getPositionCount());
        List filterPositions = filterAxis.getPositions();
        ConnectionTest.assertEquals((int)0, (int)filterPositions.size());
        ConnectionTest.assertEquals((int)2, (int)filterAxis.getAxisMetaData().getHierarchies().size());
        Cell cell = cellSet.getCell(Arrays.asList(0, 0));
        ConnectionTest.assertTrue((boolean)cell.isNull());
    }

    public void testMissingFilter() throws SQLException {
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        OlapStatement statement = olapConnection.createStatement();
        CellSet cellSet = statement.executeOlapQuery("SELECT {[Measures].[Unit Sales]} on 0,\n{[Product].Children} on 1\nFROM [Sales]\n");
        List axesList = cellSet.getAxes();
        ConnectionTest.assertEquals((int)2, (int)axesList.size());
        CellSetAxis filterAxis = cellSet.getFilterAxis();
        ConnectionTest.assertEquals((int)1, (int)filterAxis.getPositionCount());
        List filterPositions = filterAxis.getPositions();
        ConnectionTest.assertEquals((int)1, (int)filterPositions.size());
        Position position = (Position)filterPositions.get(0);
        ConnectionTest.assertEquals((int)0, (int)position.getMembers().size());
        ConnectionTest.assertEquals((int)0, (int)filterAxis.getAxisMetaData().getHierarchies().size());
        ConnectionTest.assertTrue((boolean)filterAxis.getAxisMetaData().getHierarchies().isEmpty());
        Cell cell = cellSet.getCell(Arrays.asList(0, 0));
        ConnectionTest.assertEquals((String)"24,597", (String)cell.getFormattedValue());
    }

    public void testMeasureVersusMemberCasting() throws Exception {
        this.connection = this.tester.createConnection();
        Statement statement = this.connection.createStatement();
        OlapStatement olapStatement = this.tester.getWrapper().unwrap(statement, OlapStatement.class);
        CellSet cellSet = olapStatement.executeOlapQuery("SELECT {[Measures].[Unit Sales]} on 0,\n{[Store].Children} on 1\nFROM [Sales]\nWHERE ([Time].[1997].[Q1], [Gender].[F])");
        List axesList = cellSet.getAxes();
        ConnectionTest.assertEquals((int)2, (int)axesList.size());
        Member rowsMember = (Member)((Position)((CellSetAxis)axesList.get(0)).getPositions().get(0)).getMembers().get(0);
        ConnectionTest.assertTrue((String)rowsMember.getUniqueName(), (boolean)(rowsMember instanceof Measure));
        Member columnsMember = (Member)((Position)((CellSetAxis)axesList.get(1)).getPositions().get(0)).getMembers().get(0);
        ConnectionTest.assertTrue((String)columnsMember.getUniqueName(), (!(columnsMember instanceof Measure) ? 1 : 0) != 0);
    }

    public void testInvalidStatement() throws SQLException {
        this.connection = this.tester.createConnection();
        Statement statement = this.connection.createStatement();
        OlapStatement olapStatement = this.tester.getWrapper().unwrap(statement, OlapStatement.class);
        try {
            CellSet cellSet = olapStatement.executeOlapQuery("SELECT an error FROM [Sales]");
            ConnectionTest.fail((String)("expected error, got " + cellSet));
        }
        catch (OlapException e) {
            switch (this.tester.getFlavor()) {
                case XMLA: 
                case REMOTE_XMLA: {
                    ConnectionTest.assertTrue((String)e.getMessage(), (e.getMessage().indexOf("XMLA MDX parse failed") >= 0 ? 1 : 0) != 0);
                    break;
                }
                default: {
                    ConnectionTest.assertTrue((TestContext.getStackTrace(e).indexOf("Failed to parse query") >= 0 ? 1 : 0) != 0);
                }
            }
        }
        this.assertIsClosed(olapStatement, false);
        olapStatement.close();
        this.connection.close();
    }

    public void testPreparedStatement() throws SQLException {
        int[] paramIndexes;
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        PreparedOlapStatement pstmt = olapConnection.prepareOlapStatement("SELECT {\n   Parameter(\"P1\", [Store], [Store].[USA].[CA]).Parent,\n   ParamRef(\"P1\").Children} ON 0\nFROM [Sales]\nWHERE [Gender].[M]");
        OlapParameterMetaData parameterMetaData = pstmt.getParameterMetaData();
        int paramCount = parameterMetaData.getParameterCount();
        switch (this.tester.getFlavor()) {
            case XMLA: 
            case REMOTE_XMLA: {
                ConnectionTest.assertEquals((int)0, (int)paramCount);
                return;
            }
        }
        ConnectionTest.assertEquals((int)1, (int)paramCount);
        for (int paramIndex : paramIndexes = new int[]{0, 1, 2}) {
            for (Method method : Method.values()) {
                try {
                    switch (method) {
                        case ClassName: {
                            String className = parameterMetaData.getParameterClassName(paramIndex);
                            ConnectionTest.assertEquals((String)"org.olap4j.metadata.Member", (String)className);
                            break;
                        }
                        case Mode: {
                            int mode = parameterMetaData.getParameterMode(paramIndex);
                            ConnectionTest.assertEquals((int)1, (int)mode);
                            break;
                        }
                        case Type: {
                            int type = parameterMetaData.getParameterType(paramIndex);
                            ConnectionTest.assertEquals((int)1111, (int)type);
                            break;
                        }
                        case TypeName: {
                            String typeName = parameterMetaData.getParameterTypeName(paramIndex);
                            ConnectionTest.assertEquals((String)"MemberType<hierarchy=[Store].[Store]>", (String)typeName);
                            break;
                        }
                        case OlapType: {
                            Type olapType = parameterMetaData.getParameterOlapType(paramIndex);
                            ConnectionTest.assertEquals((String)"MemberType<hierarchy=[Store].[Store]>", (String)olapType.toString());
                            break;
                        }
                        default: {
                            throw Olap4jUtil.unexpected((Enum)method);
                        }
                    }
                    if (paramIndex == 1) continue;
                    ConnectionTest.fail((String)"expected exception");
                }
                catch (SQLException e) {
                    if (paramIndex != 1) continue;
                    throw e;
                }
            }
        }
        if (this.tester.getFlavor() == TestContext.Tester.Flavor.XMLA) {
            ConnectionTest.assertEquals((String)"Sales", (String)pstmt.getCube().getName());
        }
        CellSetMetaData metaData = pstmt.getMetaData();
        ConnectionTest.assertEquals((String)"Sales", (String)metaData.getCube().getName());
        CellSet cellSet = pstmt.executeQuery();
        ConnectionTest.assertEquals((Object)metaData, (Object)cellSet.getMetaData());
        ConnectionTest.assertEquals((String)"Sales", (String)metaData.getCube().getName());
        String s = TestContext.toString(cellSet);
        String expected = "Axis #0:\n{[Gender].[Gender].[M]}\nAxis #1:\n{[Store].[Store].[USA]}\n{[Store].[Store].[USA].[CA].[Alameda]}\n{[Store].[Store].[USA].[CA].[Beverly Hills]}\n{[Store].[Store].[USA].[CA].[Los Angeles]}\n{[Store].[Store].[USA].[CA].[San Diego]}\n{[Store].[Store].[USA].[CA].[San Francisco]}\nRow #0: 135,215\nRow #0: \nRow #0: 10,562\nRow #0: 13,574\nRow #0: 12,800\nRow #0: 1,053\n";
        TestContext.assertEqualsVerbose("Axis #0:\n{[Gender].[Gender].[M]}\nAxis #1:\n{[Store].[Store].[USA]}\n{[Store].[Store].[USA].[CA].[Alameda]}\n{[Store].[Store].[USA].[CA].[Beverly Hills]}\n{[Store].[Store].[USA].[CA].[Los Angeles]}\n{[Store].[Store].[USA].[CA].[San Diego]}\n{[Store].[Store].[USA].[CA].[San Francisco]}\nRow #0: 135,215\nRow #0: \nRow #0: 10,562\nRow #0: 13,574\nRow #0: 12,800\nRow #0: 1,053\n", s);
        List positions = ((CellSetAxis)cellSet.getAxes().get(0)).getPositions();
        Member member = (Member)((Position)positions.get(positions.size() - 1)).getMembers().get(0);
        ConnectionTest.assertFalse((boolean)pstmt.isSet(1));
        pstmt.setObject(1, null);
        ConnectionTest.assertTrue((boolean)pstmt.isSet(1));
        pstmt.unset(1);
        ConnectionTest.assertFalse((boolean)pstmt.isSet(1));
        pstmt.setObject(1, (Object)member);
        ConnectionTest.assertTrue((boolean)pstmt.isSet(1));
        CellSet cellSet2 = pstmt.executeQuery();
        this.assertIsClosed(cellSet, true);
        this.assertIsClosed(cellSet2, false);
        s = TestContext.toString(cellSet2);
        String expected2 = "Axis #0:\n{[Gender].[Gender].[M]}\nAxis #1:\n{[Store].[Store].[USA].[CA]}\n{[Store].[Store].[USA].[CA].[San Francisco].[Store 14]}\nRow #0: 37,989\nRow #0: 1,053\n";
        TestContext.assertEqualsVerbose("Axis #0:\n{[Gender].[Gender].[M]}\nAxis #1:\n{[Store].[Store].[USA].[CA]}\n{[Store].[Store].[USA].[CA].[San Francisco].[Store 14]}\nRow #0: 37,989\nRow #0: 1,053\n", s);
        pstmt.unset(1);
        cellSet = pstmt.executeQuery();
        s = TestContext.toString(cellSet);
        TestContext.assertEqualsVerbose("Axis #0:\n{[Gender].[Gender].[M]}\nAxis #1:\n{[Store].[Store].[USA]}\n{[Store].[Store].[USA].[CA].[Alameda]}\n{[Store].[Store].[USA].[CA].[Beverly Hills]}\n{[Store].[Store].[USA].[CA].[Los Angeles]}\n{[Store].[Store].[USA].[CA].[San Diego]}\n{[Store].[Store].[USA].[CA].[San Francisco]}\nRow #0: 135,215\nRow #0: \nRow #0: 10,562\nRow #0: 13,574\nRow #0: 12,800\nRow #0: 1,053\n", s);
        CellSet cellSet3 = pstmt.executeOlapQuery("SELECT FROM [Sales] WHERE [Time].[Weekly].[1997].[3]");
        TestContext.assertEqualsVerbose("Axis #0:\n{[Time].[Weekly].[1997].[3]}\n9,518", TestContext.toString(cellSet3));
        OlapParameterMetaData parameterMetaData1 = pstmt.getParameterMetaData();
        ConnectionTest.assertEquals((int)0, (int)parameterMetaData1.getParameterCount());
        try {
            pstmt.setInt(1, 100);
            ConnectionTest.fail((String)"expected exception");
        }
        catch (SQLException e) {
            // empty catch block
        }
        CellSet cellSet4 = pstmt.executeQuery();
        this.assertIsClosed(cellSet4, false);
        this.assertIsClosed(cellSet3, true);
        ConnectionTest.assertEquals((int)0, (int)cellSet4.getAxes().size());
        ConnectionTest.assertEquals((Object)9518.0, (Object)cellSet4.getCell(0).getValue());
        MdxParser mdxParser = olapConnection.getParserFactory().createMdxParser(olapConnection);
        SelectNode select = mdxParser.parseSelect("select {[Gender]} on columns from [sales]\nwhere [Time].[Time].[1997].[Q4]");
        CellSet cellSet5 = pstmt.executeOlapQuery(select);
        TestContext.assertEqualsVerbose("Axis #0:\n{[Time].[Time].[1997].[Q4]}\nAxis #1:\n{[Gender].[Gender].[All Gender]}\nRow #0: 72,024\n", TestContext.toString(cellSet5));
        CellSet cellSet6 = pstmt.executeQuery();
        this.assertIsClosed(cellSet6, false);
        this.assertIsClosed(cellSet5, true);
        ConnectionTest.assertEquals((int)1, (int)cellSet6.getAxes().size());
        ConnectionTest.assertEquals((Object)72024.0, (Object)cellSet6.getCell(0).getDoubleValue());
        this.assertIsClosed(pstmt, false);
        pstmt.close();
        this.assertIsClosed(pstmt, true);
        this.assertIsClosed(cellSet, true);
        this.assertIsClosed(cellSet2, true);
        this.assertIsClosed(cellSet6, true);
    }

    public void testCellSetMetaData() throws SQLException {
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        this.checkCellSetMetaData1(olapConnection, "select {[Gender]} on columns from [sales]\nwhere [Time].[1997].[Q4]");
        this.checkCellSetMetaData1(olapConnection, "select {[Gender]} on columns from [sales]");
    }

    private void checkCellSetMetaData1(OlapConnection olapConnection, String mdx) throws SQLException {
        PreparedOlapStatement pstmt = olapConnection.prepareOlapStatement(mdx);
        CellSetMetaData cellSetMetaData = pstmt.getMetaData();
        this.checkCellSetMetaData(cellSetMetaData, 1, null);
        CellSet cellSet = pstmt.executeQuery();
        this.checkCellSetMetaData(cellSet.getMetaData(), 1, cellSet);
        OlapStatement stmt = olapConnection.createStatement();
        CellSet cellSet1 = stmt.executeOlapQuery(mdx);
        this.checkCellSetMetaData(cellSet1.getMetaData(), 1, cellSet1);
        MdxParser mdxParser = olapConnection.getParserFactory().createMdxParser(olapConnection);
        SelectNode select = mdxParser.parseSelect(mdx);
        OlapStatement stmt2 = olapConnection.createStatement();
        CellSet cellSet2 = stmt2.executeOlapQuery(select);
        this.checkCellSetMetaData(cellSet2.getMetaData(), 1, cellSet2);
    }

    private void checkCellSetMetaData(CellSetMetaData cellSetMetaData, int axesCount, CellSet cellSet) throws OlapException {
        ConnectionTest.assertNotNull((Object)cellSetMetaData);
        ConnectionTest.assertEquals((int)axesCount, (int)cellSetMetaData.getAxesMetaData().size());
        ConnectionTest.assertEquals((String)"Sales", (String)cellSetMetaData.getCube().getName());
        int k = -1;
        HashSet unseenHierarchies = new HashSet(cellSetMetaData.getCube().getHierarchies());
        for (CellSetAxisMetaData axisMetaData : cellSetMetaData.getAxesMetaData()) {
            ConnectionTest.assertEquals((Object)Axis.Factory.forOrdinal((int)(++k)), (Object)axisMetaData.getAxisOrdinal());
            ConnectionTest.assertEquals((int)k, (int)axisMetaData.getAxisOrdinal().axisOrdinal());
            ConnectionTest.assertTrue((axisMetaData.getHierarchies().size() > 0 ? 1 : 0) != 0);
            unseenHierarchies.removeAll(axisMetaData.getHierarchies());
            ConnectionTest.assertTrue((axisMetaData.getProperties().size() == 0 ? 1 : 0) != 0);
            if (cellSet == null) continue;
            CellSetAxisMetaData cellSetAxisMetaData = ((CellSetAxis)cellSet.getAxes().get(k)).getAxisMetaData();
            ConnectionTest.assertEquals((Object)cellSetAxisMetaData, (Object)axisMetaData);
        }
        CellSetAxisMetaData axisMetaData = cellSetMetaData.getFilterAxisMetaData();
        ConnectionTest.assertNotNull((Object)axisMetaData);
        ConnectionTest.assertEquals((Object)Axis.FILTER, (Object)axisMetaData.getAxisOrdinal());
        ConnectionTest.assertTrue((axisMetaData.getHierarchies().size() >= 0 ? 1 : 0) != 0);
        for (Hierarchy hierarchy : axisMetaData.getHierarchies()) {
            ConnectionTest.assertTrue((boolean)unseenHierarchies.contains(hierarchy));
        }
        ConnectionTest.assertTrue((axisMetaData.getProperties().size() == 0 ? 1 : 0) != 0);
        if (cellSet != null) {
            ConnectionTest.assertEquals((Object)cellSet.getFilterAxis().getAxisMetaData(), (Object)axisMetaData);
            ConnectionTest.assertEquals((int)1, (int)cellSet.getFilterAxis().getPositionCount());
            ConnectionTest.assertEquals((int)1, (int)cellSet.getFilterAxis().getPositions().size());
        }
    }

    public void testCellSetAxisMetaData() throws Exception {
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        String mdx = "SELECT\n   {[Measures].Members} ON COLUMNS,\n   CrossJoin([Store].Members, [Gender].Children)\n   DIMENSION PROPERTIES\n      MEMBER_ORDINAL,\n      MEMBER_UNIQUE_NAME,\n      DISPLAY_INFO ON ROWS\n FROM [Sales]";
        PreparedOlapStatement preparedStmt = olapConnection.prepareOlapStatement("SELECT\n   {[Measures].Members} ON COLUMNS,\n   CrossJoin([Store].Members, [Gender].Children)\n   DIMENSION PROPERTIES\n      MEMBER_ORDINAL,\n      MEMBER_UNIQUE_NAME,\n      DISPLAY_INFO ON ROWS\n FROM [Sales]");
        CellSetMetaData cellSetMetaData = preparedStmt.getMetaData();
        this.checkAxisMetaData((CellSetAxisMetaData)cellSetMetaData.getAxesMetaData().get(1));
        OlapStatement olapStatement = olapConnection.createStatement();
        CellSet cellSet = olapStatement.executeOlapQuery("SELECT\n   {[Measures].Members} ON COLUMNS,\n   CrossJoin([Store].Members, [Gender].Children)\n   DIMENSION PROPERTIES\n      MEMBER_ORDINAL,\n      MEMBER_UNIQUE_NAME,\n      DISPLAY_INFO ON ROWS\n FROM [Sales]");
        this.checkAxisMetaData(((CellSetAxis)cellSet.getAxes().get(1)).getAxisMetaData());
        this.checkAxisMetaData((CellSetAxisMetaData)cellSet.getMetaData().getAxesMetaData().get(1));
    }

    private void checkAxisMetaData(CellSetAxisMetaData cellSetAxisMetaData) {
        List hierarchies = cellSetAxisMetaData.getHierarchies();
        ConnectionTest.assertEquals((int)2, (int)hierarchies.size());
        ConnectionTest.assertEquals((String)"Store", (String)((Hierarchy)hierarchies.get(0)).getName());
        ConnectionTest.assertEquals((String)"Gender", (String)((Hierarchy)hierarchies.get(1)).getName());
        List properties = cellSetAxisMetaData.getProperties();
        switch (this.tester.getFlavor()) {
            case MONDRIAN: {
                ConnectionTest.assertEquals((int)3, (int)properties.size());
                break;
            }
            default: {
                ConnectionTest.assertEquals((int)6, (int)properties.size());
            }
        }
        ConnectionTest.assertEquals((String)"MEMBER_ORDINAL", (String)((Property)properties.get(0)).getName());
        ConnectionTest.assertEquals((String)"MEMBER_UNIQUE_NAME", (String)((Property)properties.get(1)).getName());
        ConnectionTest.assertEquals((String)"DISPLAY_INFO", (String)((Property)properties.get(2)).getName());
    }

    public void testCellSet() throws SQLException {
        this.connection = this.tester.createConnection();
        Statement statement = this.connection.createStatement();
        OlapStatement olapStatement = this.tester.getWrapper().unwrap(statement, OlapStatement.class);
        CellSet cellSet = olapStatement.executeOlapQuery("SELECT\n {[Measures].[Unit Sales],\n    [Measures].[Store Sales]} ON COLUMNS\n, Crossjoin({[Gender].[M]}, [Product].Children) ON ROWS\nFROM [Sales]\nWHERE [Time].[1997].[Q2]");
        String s = TestContext.toString(cellSet);
        TestContext.assertEqualsVerbose("Axis #0:\n{[Time].[Time].[1997].[Q2]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Sales]}\nAxis #2:\n{[Gender].[Gender].[M], [Product].[Product].[Drink]}\n{[Gender].[Gender].[M], [Product].[Product].[Food]}\n{[Gender].[Gender].[M], [Product].[Product].[Non-Consumable]}\nRow #0: 3,023\nRow #0: 6,004.80\nRow #1: 22,558\nRow #1: 47,869.17\nRow #2: 6,037\nRow #2: 12,935.16\n", s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCell() throws Exception {
        Cell cell2;
        this.connection = this.tester.createConnection();
        Statement statement = this.connection.createStatement();
        OlapStatement olapStatement = this.tester.getWrapper().unwrap(statement, OlapStatement.class);
        CellSet cellSet = olapStatement.executeOlapQuery("SELECT\n {[Measures].[Unit Sales],\n    [Measures].[Store Sales]} ON COLUMNS\n, Crossjoin({[Gender].[M]}, [Product].Children) ON ROWS\nFROM [Sales]\nWHERE [Time].[1997].[Q2]");
        Cell cell = cellSet.getCell(5);
        ConnectionTest.assertEquals((int)5, (int)cell.getOrdinal());
        if (this.tester.getFlavor() != TestContext.Tester.Flavor.XMLA || this.tester.getFlavor() != TestContext.Tester.Flavor.REMOTE_XMLA) {
            ConnectionTest.assertEquals((Object)12935.16, (Object)cell.getValue());
        }
        ConnectionTest.assertEquals((Object)12935.16, (Object)cell.getDoubleValue());
        ConnectionTest.assertEquals((String)"12,935.16", (String)cell.getFormattedValue());
        ConnectionTest.assertEquals((Object)cellSet, (Object)cell.getCellSet());
        cell = cellSet.getCell(Arrays.asList(1, 2));
        ConnectionTest.assertEquals((int)5, (int)cell.getOrdinal());
        cell = cellSet.getCell(new Position[]{(Position)((CellSetAxis)cellSet.getAxes().get(0)).getPositions().get(1), (Position)((CellSetAxis)cellSet.getAxes().get(1)).getPositions().get(2)});
        ConnectionTest.assertEquals((int)5, (int)cell.getOrdinal());
        ConnectionTest.assertEquals(Arrays.asList(1, 2), (Object)cell.getCoordinateList());
        ConnectionTest.assertEquals((Object)"#,###.00", (Object)cell.getPropertyValue((Property)Property.StandardCellProperty.FORMAT_STRING));
        ConnectionTest.assertFalse((boolean)cell.isEmpty());
        ConnectionTest.assertFalse((boolean)cell.isError());
        ConnectionTest.assertFalse((boolean)cell.isNull());
        ConnectionTest.assertNull((Object)cell.getErrorText());
        switch (this.tester.getFlavor()) {
            case XMLA: 
            case REMOTE_XMLA: {
                break;
            }
            default: {
                ResultSet resultSet = cell.drillThrough();
                try {
                    ResultSetMetaData metaData = resultSet.getMetaData();
                    ConnectionTest.assertTrue((metaData.getColumnCount() >= 5 ? 1 : 0) != 0);
                    ConnectionTest.assertEquals((String)"Quarter", (String)metaData.getColumnLabel(1));
                    ConnectionTest.assertEquals((String)"Quarter_0", (String)metaData.getColumnLabel(2));
                    ConnectionTest.assertEquals((String)"Month", (String)metaData.getColumnLabel(3));
                    ConnectionTest.assertEquals((String)"Store Sales", (String)metaData.getColumnLabel(11));
                    break;
                }
                finally {
                    resultSet.close();
                }
            }
        }
        try {
            cell2 = cellSet.getCell(-5);
            ConnectionTest.fail((String)("expected exception, got " + cell2));
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            cell2 = cellSet.getCell(105);
            ConnectionTest.fail((String)("expected exception, got " + cell2));
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            cell2 = cellSet.getCell(Arrays.asList(2, 1));
            ConnectionTest.fail((String)("expected exception, got " + cell2));
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            cell2 = cellSet.getCell(new Position[]{(Position)((CellSetAxis)cellSet.getAxes().get(0)).getPositions().get(0)});
            ConnectionTest.fail((String)("expected exception, got " + cell2));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            cell2 = cellSet.getCell(new Position[]{(Position)((CellSetAxis)cellSet.getAxes().get(0)).getPositions().get(0), (Position)((CellSetAxis)cellSet.getAxes().get(1)).getPositions().get(0), (Position)((CellSetAxis)cellSet.getAxes().get(0)).getPositions().get(0)});
            ConnectionTest.fail((String)("expected exception, got " + cell2));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        cell = cellSet.getCell(new Position[]{(Position)((CellSetAxis)cellSet.getAxes().get(1)).getPositions().get(1), (Position)((CellSetAxis)cellSet.getAxes().get(0)).getPositions().get(1)});
        ConnectionTest.assertEquals((int)3, (int)cell.getOrdinal());
        cellSet = olapStatement.executeOlapQuery("with member [Measures].[X] as 'IIF([Measures].[Store Sales]>10000,[Measures].[Store Sales],Null)'\nselect\n{[Measures].[X]} on columns,\n{[Product].[Product Department].members} on rows\nfrom Sales");
        cell = cellSet.getCell(0);
        ConnectionTest.assertFalse((boolean)cell.isNull());
        cell = cellSet.getCell(2);
        ConnectionTest.assertTrue((boolean)cell.isNull());
        cellSet = olapStatement.executeOlapQuery("select from [Sales]\nwhere ([Time].[1997].[Q4].[12],\n  [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Portsmouth].[Portsmouth Imported Beer],\n  [Store].[All Stores].[USA].[WA].[Bellingham])");
        cell = cellSet.getCell(0);
        ConnectionTest.assertTrue((boolean)cell.isEmpty());
        cellSet = olapStatement.executeOlapQuery("with member [Measures].[Foo] as ' Dimensions(-1).Name '\nselect {[Measures].[Foo]} on columns from [Sales]");
        cell = cellSet.getCell(0);
        switch (this.tester.getFlavor()) {
            case XMLA: 
            case REMOTE_XMLA: {
                break;
            }
            default: {
                ConnectionTest.assertTrue((boolean)cell.isError());
                ConnectionTest.assertEquals((String)"Index '-1' out of bounds", (String)cell.getErrorText());
            }
        }
    }

    public void testScrolling() {
        int x = 1004;
        int y = 1003;
    }

    public void testParsing() throws SQLException {
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        MdxParser mdxParser = olapConnection.getParserFactory().createMdxParser(olapConnection);
        SelectNode select = mdxParser.parseSelect("with member [Measures].[Foo] as ' [Measures].[Bar] ', FORMAT_STRING='xxx'\n select {[Gender]} on columns, {[Store].Children} on rows\nfrom [sales]\nwhere [Time].[1997].[Q4]");
        this.checkUnparsedMdx(select);
        select = mdxParser.parseSelect("select {[Gender]} on columns, {[Store].Children} on columns\nfrom [sales]");
        if (this.tester.getFlavor() == TestContext.Tester.Flavor.XMLA || this.tester.getFlavor() != TestContext.Tester.Flavor.XMLA) {
            return;
        }
        MdxValidator validator = olapConnection.getParserFactory().createMdxValidator(olapConnection);
        try {
            select = validator.validateSelect(select);
            ConnectionTest.fail((String)("expected exception, got " + select));
        }
        catch (Exception e) {
            ConnectionTest.assertTrue((TestContext.getStackTrace(e).indexOf("Duplicate axis name 'COLUMNS'.") >= 0 ? 1 : 0) != 0);
        }
    }

    private void checkUnparsedMdx(SelectNode select) {
        this.checkUnparsedMdx(select, "WITH\nMEMBER [Measures].[Foo] AS\n    [Measures].[Bar], FORMAT_STRING = \"xxx\"\nSELECT\n{[Gender]} ON COLUMNS,\n{[Store].Children} ON ROWS\nFROM [sales]\nWHERE [Time].[1997].[Q4]");
    }

    private void checkUnparsedMdx(SelectNode select, String expectedMdx) {
        StringWriter sw = new StringWriter();
        ParseTreeWriter parseTreeWriter = new ParseTreeWriter((Writer)sw);
        select.unparse(parseTreeWriter);
        String mdx = sw.toString();
        TestContext.assertEqualsVerbose(expectedMdx, mdx);
    }

    public void testUnparsing() {
        IdentifierNode cubeName = new IdentifierNode(new IdentifierSegment[]{new NameSegment("sales")});
        SelectNode select = new SelectNode(null, new ArrayList(), new ArrayList(), (ParseTreeNode)cubeName, new AxisNode(null, false, (Axis)Axis.FILTER, new ArrayList(), null), new ArrayList());
        select.getWithList().add(new WithMemberNode(null, new IdentifierNode(new IdentifierSegment[]{new NameSegment("Measures"), new NameSegment("Foo")}), (ParseTreeNode)new IdentifierNode(new IdentifierSegment[]{new NameSegment("Measures"), new NameSegment("Bar")}), Arrays.asList(new PropertyValueNode(null, "FORMAT_STRING", (ParseTreeNode)LiteralNode.createString(null, (String)"xxx")))));
        select.getAxisList().add(new AxisNode(null, false, (Axis)Axis.COLUMNS, new ArrayList(), (ParseTreeNode)new CallNode(null, "{}", Syntax.Braces, Arrays.asList(new IdentifierNode(new IdentifierSegment[]{new NameSegment("Gender")})))));
        select.getAxisList().add(new AxisNode(null, false, (Axis)Axis.ROWS, new ArrayList(), (ParseTreeNode)new CallNode(null, "{}", Syntax.Braces, new ParseTreeNode[]{new CallNode(null, "Children", Syntax.Property, new ParseTreeNode[]{new IdentifierNode(new IdentifierSegment[]{new NameSegment("Store")})})})));
        select.getFilterAxis().setExpression((ParseTreeNode)new IdentifierNode(new IdentifierSegment[]{new NameSegment("Time"), new NameSegment("1997"), new NameSegment("Q4")}));
        ConnectionTest.assertEquals((Object)select.getFrom(), (Object)cubeName);
        this.checkUnparsedMdx(select);
        SelectNode subSelect = new SelectNode(null, new ArrayList(), new ArrayList(), (ParseTreeNode)new IdentifierNode(new IdentifierSegment[]{new NameSegment("warehouse")}), new AxisNode(null, false, (Axis)Axis.FILTER, new ArrayList(), null), new ArrayList());
        select.setFrom((ParseTreeNode)subSelect);
        ConnectionTest.assertEquals((Object)select.getFrom(), (Object)subSelect);
        this.checkUnparsedMdx(select, "WITH\nMEMBER [Measures].[Foo] AS\n    [Measures].[Bar], FORMAT_STRING = \"xxx\"\nSELECT\n{[Gender]} ON COLUMNS,\n{[Store].Children} ON ROWS\nFROM (\n    SELECT\n    FROM [warehouse])\nWHERE [Time].[1997].[Q4]");
    }

    public void testBuildParseTree() {
        SelectNode select;
        try {
            select = new SelectNode(null, new ArrayList(), new ArrayList(), (ParseTreeNode)new IdentifierNode(new IdentifierSegment[]{new NameSegment("sales")}), new AxisNode(null, false, (Axis)Axis.COLUMNS, new ArrayList(), null), new ArrayList());
            ConnectionTest.fail((String)("expected error, got " + select));
        }
        catch (IllegalArgumentException e) {
            TestContext.checkThrowable(e, "Filter axis must have type FILTER");
        }
        select = new SelectNode(null, new ArrayList(), new ArrayList(), (ParseTreeNode)new IdentifierNode(new IdentifierSegment[]{new NameSegment("sales")}), new AxisNode(null, false, (Axis)Axis.FILTER, new ArrayList(), null), new ArrayList());
        AxisNode filterAxis = select.getFilterAxis();
        ConnectionTest.assertNotNull((Object)filterAxis);
        ConnectionTest.assertNull((Object)filterAxis.getExpression());
        ConnectionTest.assertEquals((Object)Axis.FILTER, (Object)filterAxis.getAxis());
        this.checkUnparsedMdx(select, "SELECT\nFROM [sales]");
        select.getFilterAxis().setExpression((ParseTreeNode)new CallNode(null, "()", Syntax.Parentheses, new ParseTreeNode[]{new IdentifierNode(new IdentifierSegment[]{new NameSegment("Measures"), new NameSegment("Store Sales")}), new IdentifierNode(new IdentifierSegment[]{new NameSegment("Gender"), new NameSegment("M")})}));
        this.checkUnparsedMdx(select, "SELECT\nFROM [sales]\nWHERE ([Measures].[Store Sales], [Gender].[M])");
        select.getFilterAxis().setExpression(null);
        this.checkUnparsedMdx(select, "SELECT\nFROM [sales]");
    }

    public void testCubeLookupMember() throws Exception {
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        Cube cube = (Cube)((Schema)((Catalog)olapConnection.getOlapCatalogs().get("FoodMart")).getSchemas().get("FoodMart")).getCubes().get("Sales Ragged");
        Member member = cube.lookupMember(TestContext.nameList("Time", "1997", "Q2"));
        ConnectionTest.assertEquals((String)"[Time].[Time].[1997].[Q2]", (String)member.getUniqueName());
        ConnectionTest.assertEquals((int)3, (int)member.getChildMemberCount());
        NamedList childMembers = member.getChildMembers();
        ConnectionTest.assertEquals((int)3, (int)childMembers.size());
        ConnectionTest.assertEquals((String)"[Time].[Time].[1997].[Q2].[4]", (String)((Member)childMembers.get(0)).getUniqueName());
        ConnectionTest.assertEquals((int)0, (int)((Member)childMembers.get(0)).getChildMemberCount());
        ConnectionTest.assertEquals((String)"[Time].[Time].[1997].[Q2].[6]", (String)((Member)childMembers.get("6")).getUniqueName());
        ConnectionTest.assertNull((Object)childMembers.get("1"));
        member = cube.lookupMember(TestContext.nameList("Time", "1997", "Q5"));
        ConnectionTest.assertNull((Object)member);
        member = cube.lookupMember(TestContext.nameList("Customers"));
        ConnectionTest.assertNull((Object)member);
        member = cube.lookupMember(TestContext.nameList("Customers", "All Customers"));
        ConnectionTest.assertTrue((boolean)member.isAll());
    }

    public void testCubeLookupMembers() throws Exception {
        String expected;
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        Cube cube = (Cube)((Schema)((Catalog)olapConnection.getOlapCatalogs().get("FoodMart")).getSchemas().get("FoodMart")).getCubes().get("Sales");
        List memberList = cube.lookupMembers(Olap4jUtil.enumSetOf((Enum)Member.TreeOp.ANCESTORS, (Enum[])new Member.TreeOp[]{Member.TreeOp.CHILDREN}), TestContext.nameList("Time", "1997", "Q2"));
        switch (this.tester.getFlavor()) {
            case XMLA: 
            case REMOTE_XMLA: {
                expected = "[Time].[Time].[1997].[Q2].[4]\n[Time].[Time].[1997].[Q2].[5]\n[Time].[Time].[1997].[Q2].[6]\n[Time].[Time].[1997]\n";
                break;
            }
            default: {
                expected = "[Time].[Time].[1997]\n[Time].[Time].[1997].[Q2].[4]\n[Time].[Time].[1997].[Q2].[5]\n[Time].[Time].[1997].[Q2].[6]\n";
            }
        }
        TestContext.assertEqualsVerbose(expected, ConnectionTest.memberListToString(memberList));
        memberList = cube.lookupMembers(Olap4jUtil.enumSetOf((Enum)Member.TreeOp.ANCESTORS, (Enum[])new Member.TreeOp[]{Member.TreeOp.CHILDREN}), TestContext.nameList("Time", "1997", "Q5"));
        ConnectionTest.assertTrue((boolean)memberList.isEmpty());
        memberList = cube.lookupMembers(Olap4jUtil.enumSetOf((Enum)Member.TreeOp.ANCESTORS, (Enum[])new Member.TreeOp[]{Member.TreeOp.PARENT}), TestContext.nameList("Time", "1997", "Q2"));
        TestContext.assertEqualsVerbose("[Time].[Time].[1997]\n", ConnectionTest.memberListToString(memberList));
        memberList = cube.lookupMembers(Olap4jUtil.enumSetOf((Enum)Member.TreeOp.ANCESTORS, (Enum[])new Member.TreeOp[]{Member.TreeOp.PARENT}), TestContext.nameList("Product"));
        ConnectionTest.assertTrue((boolean)memberList.isEmpty());
        memberList = cube.lookupMembers(Olap4jUtil.enumSetOf((Enum)Member.TreeOp.SIBLINGS, (Enum[])new Member.TreeOp[]{Member.TreeOp.CHILDREN}), TestContext.nameList("Time", "1997", "Q2"));
        switch (this.tester.getFlavor()) {
            case XMLA: 
            case REMOTE_XMLA: {
                expected = "[Time].[Time].[1997].[Q2].[4]\n[Time].[Time].[1997].[Q2].[5]\n[Time].[Time].[1997].[Q2].[6]\n[Time].[Time].[1997].[Q1]\n[Time].[Time].[1997].[Q3]\n[Time].[Time].[1997].[Q4]\n";
                break;
            }
            default: {
                expected = "[Time].[Time].[1997].[Q1]\n[Time].[Time].[1997].[Q2].[4]\n[Time].[Time].[1997].[Q2].[5]\n[Time].[Time].[1997].[Q2].[6]\n[Time].[Time].[1997].[Q3]\n[Time].[Time].[1997].[Q4]\n";
            }
        }
        TestContext.assertEqualsVerbose(expected, ConnectionTest.memberListToString(memberList));
        memberList = cube.lookupMembers(Olap4jUtil.enumSetOf((Enum)Member.TreeOp.SIBLINGS, (Enum[])new Member.TreeOp[0]), TestContext.nameList("Time", "1997"));
        TestContext.assertEqualsVerbose("[Time].[Time].[1998]\n", ConnectionTest.memberListToString(memberList));
        memberList = cube.lookupMembers(Olap4jUtil.enumSetOf((Enum)Member.TreeOp.SIBLINGS, (Enum[])new Member.TreeOp[]{Member.TreeOp.SELF}), TestContext.nameList("Customers", "USA", "OR"));
        TestContext.assertEqualsVerbose("[Customers].[Customers].[USA].[CA]\n[Customers].[Customers].[USA].[OR]\n[Customers].[Customers].[USA].[WA]\n", ConnectionTest.memberListToString(memberList));
    }

    public void testMetadata() throws Exception {
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        OlapDatabaseMetaData metadata = olapConnection.getMetaData();
        switch (this.tester.getFlavor()) {
            case REMOTE_XMLA: {
                ConnectionTest.assertEquals((int)1, (int)olapConnection.getOlapCatalogs().size());
                break;
            }
            case XMLA: {
                ConnectionTest.assertEquals((int)2, (int)olapConnection.getOlapCatalogs().size());
                break;
            }
            case MONDRIAN: {
                ConnectionTest.assertEquals((int)1, (int)olapConnection.getOlapCatalogs().size());
            }
        }
        Cube cube = (Cube)((Schema)((Catalog)olapConnection.getOlapCatalogs().get("FoodMart")).getSchemas().get("FoodMart")).getCubes().get("Sales");
        int z = 0;
        int hierarchyCount = 0;
        for (Dimension dimension : cube.getDimensions()) {
            ConnectionTest.assertNotNull((Object)dimension.getCaption());
            dimension.getDescription();
            ConnectionTest.assertNotNull((Object)dimension.getDefaultHierarchy());
            ConnectionTest.assertEquals((Object)(dimension.getName().equals("Time") ? Dimension.Type.TIME : (dimension.getName().equals("Measures") ? Dimension.Type.MEASURE : Dimension.Type.OTHER)), (Object)dimension.getDimensionType());
            ConnectionTest.assertNotNull((Object)dimension.getName());
            ConnectionTest.assertNotNull((Object)dimension.getUniqueName());
            for (Hierarchy hierarchy : dimension.getHierarchies()) {
                ++hierarchyCount;
                NamedList rootMemberList = hierarchy.getRootMembers();
                if (hierarchy.hasAll()) {
                    ConnectionTest.assertEquals((int)1, (int)rootMemberList.size());
                }
                for (Member rootMember : rootMemberList) {
                    ConnectionTest.assertNull((Object)rootMember.getParentMember());
                }
                ConnectionTest.assertEquals((Object)rootMemberList, (Object)((Level)hierarchy.getLevels().get(0)).getMembers());
                ConnectionTest.assertNotNull((Object)hierarchy.getDefaultMember());
                ConnectionTest.assertNotNull((Object)hierarchy.getName());
                ConnectionTest.assertNotNull((Object)hierarchy.getUniqueName());
                hierarchy.getDescription();
                ConnectionTest.assertNotNull((Object)hierarchy.getCaption());
                ConnectionTest.assertEquals((Object)dimension, (Object)hierarchy.getDimension());
                for (Level level : hierarchy.getLevels()) {
                    if (level.getCardinality() >= 100) continue;
                    if (level.getName().equals("Year")) {
                        ConnectionTest.assertEquals((Object)Level.Type.TIME_YEARS, (Object)level.getLevelType());
                        ConnectionTest.assertFalse((boolean)level.isCalculated());
                        ++z;
                    }
                    if (level.getName().equals("Gender")) {
                        ConnectionTest.assertEquals((Object)Level.Type.REGULAR, (Object)level.getLevelType());
                        ConnectionTest.assertFalse((boolean)level.isCalculated());
                        ++z;
                    }
                    if (!level.getName().equals("Measures")) continue;
                    ConnectionTest.assertEquals((Object)Level.Type.REGULAR, (Object)level.getLevelType());
                    ConnectionTest.assertFalse((boolean)level.isCalculated());
                    ++z;
                }
            }
        }
        for (Hierarchy hierarchy : cube.getHierarchies()) {
            --hierarchyCount;
            ConnectionTest.assertNotNull((Object)hierarchy.getName());
        }
        ConnectionTest.assertEquals((int)0, (int)hierarchyCount);
        ConnectionTest.assertEquals((String)"found Year, Measures, Gender levels", (int)3, (int)z);
        Hierarchy timeWeeklyHierarchy = (Hierarchy)cube.getHierarchies().get("Weekly");
        ConnectionTest.assertNotNull((Object)timeWeeklyHierarchy);
        ConnectionTest.assertEquals((String)"Time", (String)timeWeeklyHierarchy.getDimension().getName());
        ConnectionTest.assertEquals((int)2, (int)timeWeeklyHierarchy.getDimension().getHierarchies().size());
        Cube warehouseCube = (Cube)((Schema)((Catalog)olapConnection.getOlapCatalogs().get("FoodMart")).getSchemas().get("FoodMart")).getCubes().get("Warehouse");
        int count = 0;
        block13: for (NamedSet namedSet : warehouseCube.getSets()) {
            ++count;
            ConnectionTest.assertNotNull((Object)namedSet.getName());
            ConnectionTest.assertNotNull((Object)namedSet.getUniqueName());
            ConnectionTest.assertNotNull((Object)namedSet.getCaption());
            namedSet.getDescription();
            switch (this.tester.getFlavor()) {
                case XMLA: 
                case REMOTE_XMLA: {
                    continue block13;
                }
            }
            ConnectionTest.assertTrue((boolean)(namedSet.getExpression().getType() instanceof SetType));
        }
        ConnectionTest.assertTrue((count > 0 ? 1 : 0) != 0);
        Member member = cube.lookupMember(TestContext.nameList("Product", "Food", "Marshmallows"));
        ConnectionTest.assertNull((Object)member);
        member = cube.lookupMember(TestContext.nameList("Product", "Food"));
        ConnectionTest.assertNotNull((Object)member);
        Member member2 = cube.lookupMember(TestContext.nameList("Product", "All Products", "Food"));
        ConnectionTest.assertEquals((Object)member, (Object)member2);
        Member bread = cube.lookupMember(TestContext.nameList("Product", "Food", "Baked Goods", "Bread"));
        ConnectionTest.assertEquals((String)"[Product].[Product].[Food]", (String)member.getUniqueName());
        ConnectionTest.assertEquals((String)"Food", (String)member.getName());
        ConnectionTest.assertEquals((String)"[Product].[Product].[Product Family]", (String)member.getLevel().getUniqueName());
        ConnectionTest.assertEquals((Object)Member.Type.REGULAR, (Object)member.getMemberType());
        ConnectionTest.assertEquals((String)"[Product].[Product].[Food].[Baked Goods]", (String)bread.getParentMember().getUniqueName());
        List list = bread.getAncestorMembers();
        ConnectionTest.assertEquals((int)3, (int)list.size());
        ConnectionTest.assertEquals((String)"[Product].[Product].[Food].[Baked Goods]", (String)((Member)list.get(0)).getUniqueName());
        ConnectionTest.assertEquals((String)"[Product].[Product].[Food]", (String)((Member)list.get(1)).getUniqueName());
        ConnectionTest.assertEquals((String)"[Product].[Product].[All Products]", (String)((Member)list.get(2)).getUniqueName());
        ConnectionTest.assertEquals((String)"Food", (String)member.getCaption());
        ConnectionTest.assertTrue((boolean)ConnectionTest.isNullOrEmpty(member.getDescription()));
        ConnectionTest.assertEquals((int)1, (int)member.getDepth());
        ConnectionTest.assertEquals((int)-1, (int)member.getSolveOrder());
        ConnectionTest.assertFalse((boolean)member.isHidden());
        ConnectionTest.assertNull((Object)member.getDataMember());
        ConnectionTest.assertFalse((boolean)member.isCalculatedInQuery());
        NamedList propertyList = member.getProperties();
        Property property = (Property)propertyList.get("MEMBER_CAPTION");
        ConnectionTest.assertEquals((String)"Food", (String)member.getPropertyFormattedValue(property));
        ConnectionTest.assertEquals((Object)"Food", (Object)member.getPropertyValue(property));
        ConnectionTest.assertFalse((boolean)member.isAll());
        Member allProductsMember = member.getParentMember();
        ConnectionTest.assertEquals((String)"[Product].[Product].[All Products]", (String)allProductsMember.getUniqueName());
        ConnectionTest.assertEquals((String)"(All)", (String)allProductsMember.getLevel().getName());
        ConnectionTest.assertEquals((String)"[Product].[Product].[(All)]", (String)allProductsMember.getLevel().getUniqueName());
        ConnectionTest.assertEquals((int)1, (int)allProductsMember.getLevel().getMembers().size());
        ConnectionTest.assertTrue((boolean)allProductsMember.isAll());
        ConnectionTest.assertNull((Object)allProductsMember.getParentMember());
        ConnectionTest.assertEquals((String)"MEMBER_CAPTION", (String)property.getName());
        ConnectionTest.assertEquals((String)"MEMBER_CAPTION", (String)property.getUniqueName());
        ConnectionTest.assertEquals((Object)Olap4jUtil.enumSetOf((Enum)Property.TypeFlag.MEMBER, (Enum[])new Property.TypeFlag[0]), (Object)property.getType());
        ConnectionTest.assertEquals((Object)Datatype.STRING, (Object)property.getDatatype());
        Property parentLevelProperty = (Property)propertyList.get("PARENT_LEVEL");
        ConnectionTest.assertNotNull((Object)parentLevelProperty);
        ConnectionTest.assertEquals((Object)0, (Object)allProductsMember.getPropertyValue(parentLevelProperty));
        ConnectionTest.assertEquals((Object)0, (Object)member.getPropertyValue(parentLevelProperty));
        ConnectionTest.assertEquals((Object)2, (Object)bread.getPropertyValue(parentLevelProperty));
        Property parentUniqueNameProperty = (Property)propertyList.get("PARENT_UNIQUE_NAME");
        ConnectionTest.assertNotNull((Object)parentUniqueNameProperty);
        ConnectionTest.assertNull((Object)allProductsMember.getPropertyValue(parentUniqueNameProperty));
        ConnectionTest.assertEquals((Object)"[Product].[Product].[All Products]", (Object)member.getPropertyValue(parentUniqueNameProperty));
        ConnectionTest.assertEquals((Object)"[Product].[Product].[Food].[Baked Goods]", (Object)bread.getPropertyValue(parentUniqueNameProperty));
        int k = -1;
        HashSet<String> measureNameSet = new HashSet<String>();
        for (Measure measure : cube.getMeasures()) {
            if (++k == 0) {
                ConnectionTest.assertEquals((String)"Unit Sales", (String)measure.getName());
            }
            if (measure.getName().equals("Profit Growth") || measure.getName().equals("Profit last Period") || measure.getName().equals("Profit")) {
                ConnectionTest.assertEquals((Object)Member.Type.FORMULA, (Object)measure.getMemberType());
                ConnectionTest.assertTrue((boolean)measure.isCalculated());
            } else {
                ConnectionTest.assertEquals((Object)Member.Type.MEASURE, (Object)measure.getMemberType());
                ConnectionTest.assertFalse((boolean)measure.isCalculated());
            }
            ConnectionTest.assertNotNull((Object)measure.getName());
            ConnectionTest.assertNotNull((Object)measure.getAggregator());
            ConnectionTest.assertTrue((measure.getDatatype() != null ? 1 : 0) != 0);
            if (measure.getName().equals("Profit last Period")) {
                ConnectionTest.assertFalse((boolean)measure.isVisible());
                continue;
            }
            measureNameSet.add(measure.getName());
        }
        ConnectionTest.assertEquals(new HashSet<String>(Arrays.asList("Unit Sales", "Customer Count", "Profit", "Profit Growth", "Promotion Sales", "Sales Count", "Store Sales", "Store Cost")), measureNameSet);
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.equals("");
    }

    public void testSchemaGetSharedDimensions() throws Exception {
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        ArrayList<String> list = new ArrayList<String>();
        NamedList sharedDimensions = olapConnection.getOlapSchema().getSharedDimensions();
        for (Dimension dimension : sharedDimensions) {
            list.add(dimension.getName());
        }
        ConnectionTest.assertEquals(Arrays.asList("Product", "Store", "Store Size in SQFT", "Store Type", "Time", "Warehouse"), list);
        int hierarchyCount = 0;
        int levelCount = 0;
        for (Dimension sharedDimension : sharedDimensions) {
            for (Hierarchy hierarchy : sharedDimension.getHierarchies()) {
                ++hierarchyCount;
                for (Level level : hierarchy.getLevels()) {
                    ++levelCount;
                }
            }
        }
        ConnectionTest.assertTrue((hierarchyCount > 0 ? 1 : 0) != 0);
        ConnectionTest.assertTrue((levelCount > 0 ? 1 : 0) != 0);
    }

    public void testVirtualCubeCmBug() throws Exception {
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        Cube warehouseSalesCube = (Cube)((Schema)((Catalog)olapConnection.getOlapCatalogs().get("FoodMart")).getSchemas().get("FoodMart")).getCubes().get("Warehouse and Sales");
        HashSet<String> measureVcNameSet = new HashSet<String>();
        for (Measure measure : warehouseSalesCube.getMeasures()) {
            measureVcNameSet.add(measure.getName());
        }
        ConnectionTest.assertEquals(new HashSet<String>(Arrays.asList("Warehouse Sales", "Profit last Period", "Warehouse Cost", "Store Cost", "Units Shipped", "Store Sales", "Profit Growth", "Sales Count", "Supply Time", "Store Invoice", "Units Ordered", "Average Warehouse Sale", "Profit Per Unit Shipped", "Profit", "Warehouse Profit", "Unit Sales")), measureVcNameSet);
    }

    public void testRagged() throws SQLException {
        this.connection = this.tester.createConnection();
        Statement statement = this.connection.createStatement();
        OlapStatement olapStatement = this.tester.getWrapper().unwrap(statement, OlapStatement.class);
        CellSet cellSet = olapStatement.executeOlapQuery("SELECT\n{[Product].[All Products].[Drink].[Alcoholic Beverages].Children,\n[Product].[All Products].[Food].[Baked Goods].Children} ON COLUMNS,\nCrossJoin([Store].[All Stores].[USA].[CA].Children,\n[Time].[1997].[Q1].Children) ON ROWS\nFROM [Sales Ragged]");
        String s = TestContext.toString(cellSet);
        TestContext.assertEqualsVerbose("Axis #0:\n{}\nAxis #1:\n{[Product].[Product].[Drink].[Alcoholic Beverages].[Beer and Wine]}\n{[Product].[Product].[Food].[Baked Goods].[Bread]}\nAxis #2:\n{[Store].[Store].[USA].[CA].[Alameda], [Time].[Time].[1997].[Q1].[1]}\n{[Store].[Store].[USA].[CA].[Alameda], [Time].[Time].[1997].[Q1].[2]}\n{[Store].[Store].[USA].[CA].[Alameda], [Time].[Time].[1997].[Q1].[3]}\n{[Store].[Store].[USA].[CA].[Beverly Hills], [Time].[Time].[1997].[Q1].[1]}\n{[Store].[Store].[USA].[CA].[Beverly Hills], [Time].[Time].[1997].[Q1].[2]}\n{[Store].[Store].[USA].[CA].[Beverly Hills], [Time].[Time].[1997].[Q1].[3]}\n{[Store].[Store].[USA].[CA].[Los Angeles], [Time].[Time].[1997].[Q1].[1]}\n{[Store].[Store].[USA].[CA].[Los Angeles], [Time].[Time].[1997].[Q1].[2]}\n{[Store].[Store].[USA].[CA].[Los Angeles], [Time].[Time].[1997].[Q1].[3]}\n{[Store].[Store].[USA].[CA].[San Francisco], [Time].[Time].[1997].[Q1].[1]}\n{[Store].[Store].[USA].[CA].[San Francisco], [Time].[Time].[1997].[Q1].[2]}\n{[Store].[Store].[USA].[CA].[San Francisco], [Time].[Time].[1997].[Q1].[3]}\nRow #0: \nRow #0: \nRow #1: \nRow #1: \nRow #2: \nRow #2: \nRow #3: 22\nRow #3: 63\nRow #4: 28\nRow #4: 59\nRow #5: 28\nRow #5: 39\nRow #6: 70\nRow #6: 51\nRow #7: 89\nRow #7: 51\nRow #8: 27\nRow #8: 54\nRow #9: 6\nRow #9: 2\nRow #10: 3\nRow #10: 7\nRow #11: 2\nRow #11: 10\n", s);
    }

    public void _testParentChild() throws ClassNotFoundException, SQLException {
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        CellSet cellSet = olapConnection.createStatement().executeOlapQuery("select {[Measures].[Org Salary]} on 0,\n Head([Employees].Members, 10) DIMENSION PROPERTIES DEPTH ON 1\nfrom [HR]");
        CellSetAxis rowsAxis = (CellSetAxis)cellSet.getAxes().get(1);
        ConnectionTest.assertEquals((int)10, (int)rowsAxis.getPositionCount());
        Member member0 = (Member)((Position)rowsAxis.getPositions().get(0)).getMembers().get(0);
        ConnectionTest.assertEquals((String)"All Employees", (String)member0.getName());
        ConnectionTest.assertEquals((int)0, (int)member0.getDepth());
        Member member1 = (Member)((Position)rowsAxis.getPositions().get(1)).getMembers().get(0);
        ConnectionTest.assertEquals((String)"[Employees].[Employees].[Sheri Nowmer]", (String)member1.getUniqueName());
        ConnectionTest.assertEquals((int)1, (int)member1.getDepth());
        ConnectionTest.assertEquals((int)1, (int)member1.getLevel().getDepth());
        ConnectionTest.assertEquals((String)member0.getUniqueName(), (String)member1.getParentMember().getUniqueName());
        ConnectionTest.assertEquals((Object)member0, (Object)member1.getParentMember());
        Member member2 = (Member)((Position)rowsAxis.getPositions().get(2)).getMembers().get(0);
        ConnectionTest.assertTrue((member2.getUniqueName().equals("[Employees].[Employees].[Derrick Whelply]") || member2.getUniqueName().equals("[Employees].[Employees].[Sheri Nowmer].[Derrick Whelply]") ? 1 : 0) != 0);
        ConnectionTest.assertEquals((int)2, (int)member2.getDepth());
        ConnectionTest.assertEquals((int)1, (int)member2.getLevel().getDepth());
        Member parent = member2.getParentMember();
        ConnectionTest.assertNotNull((Object)parent);
        ConnectionTest.assertEquals((String)"[Employees].[Employees].[Sheri Nowmer]", (String)parent.getUniqueName());
        ConnectionTest.assertEquals((int)1, (int)parent.getDepth());
        ConnectionTest.assertEquals((Object)member2.getLevel(), (Object)parent.getLevel());
        ConnectionTest.assertEquals((Object)member1, (Object)parent);
        CellSetAxis filterAxis = cellSet.getFilterAxis();
        ConnectionTest.assertEquals((int)1, (int)filterAxis.getPositionCount());
        List positions = filterAxis.getPositions();
        ConnectionTest.assertEquals((int)1, (int)positions.size());
        ConnectionTest.assertEquals((int)0, (int)((Position)positions.get(0)).getOrdinal());
        ConnectionTest.assertEquals((int)0, (int)((Position)positions.get(0)).getMembers().size());
    }

    public void testCalculatedMemberParent() throws ClassNotFoundException, SQLException {
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        HashMap<String, String> tests = new HashMap<String, String>();
        tests.put("Time.[1997].calc", "Time.[1997]");
        tests.put("[Time].[Time].[calc]", null);
        tests.put("[Store].[All Stores].calc", "[Store].[All Stores]");
        tests.put("[Store].[Store Country].[USA].calc", "[Store].[All Stores].[USA]");
        tests.put("[Employees].[Employees].[All Employees].calc", "[Employees].[Employees].[All Employees]");
        tests.put("[Pay Type].[All Pay Types].calc", "[Pay Type].[All Pay Types]");
        String mdxWith = "with member %s as '1' ";
        String mdxSelect = "select {%s} on 0 from hr";
        for (String calcMember : tests.keySet()) {
            String calcMemberQuery = String.format(mdxWith + mdxSelect, calcMember, calcMember);
            CellSet calcCell = olapConnection.createStatement().executeOlapQuery(calcMemberQuery);
            Member calc = (Member)((Position)((CellSetAxis)calcCell.getAxes().get(0)).getPositions().get(0)).getMembers().get(0);
            String parentMemberName = (String)tests.get(calcMember);
            if (parentMemberName != null) {
                String parentMemberQuery = String.format(mdxSelect, parentMemberName);
                CellSet parentCell = olapConnection.createStatement().executeOlapQuery(parentMemberQuery);
                Member parent = (Member)((Position)((CellSetAxis)parentCell.getAxes().get(0)).getPositions().get(0)).getMembers().get(0);
                ConnectionTest.assertEquals((String)("Parent member of " + calcMember + " is unexpected."), (Object)parent, (Object)calc.getParentMember());
                continue;
            }
            ConnectionTest.assertEquals((String)("Expecting a null parent member for " + calcMember), null, (Object)calc.getParentMember());
        }
    }

    public void testCubeType() throws Throwable {
        if (this.tester.getFlavor() == TestContext.Tester.Flavor.XMLA || this.tester.getFlavor() == TestContext.Tester.Flavor.REMOTE_XMLA) {
            return;
        }
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        MdxParserFactory parserFactory = olapConnection.getParserFactory();
        MdxParser mdxParser = parserFactory.createMdxParser(olapConnection);
        MdxValidator mdxValidator = parserFactory.createMdxValidator(olapConnection);
        SelectNode select = mdxParser.parseSelect("select {[Gender]} on columns from [sales]\nwhere [Time].[1997].[Q4]");
        try {
            ParseTreeNode from = select.getFrom();
            ConnectionTest.assertTrue((boolean)(from instanceof IdentifierNode));
            Type type = from.getType();
            ConnectionTest.fail((String)("expected error, got " + type));
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        select = mdxValidator.validateSelect(select);
        CubeType cubeType = (CubeType)select.getFrom().getType();
        ConnectionTest.assertEquals((String)"Sales", (String)cubeType.getCube().getName());
        ConnectionTest.assertNull((Object)cubeType.getDimension());
        ConnectionTest.assertNull((Object)cubeType.getHierarchy());
        ConnectionTest.assertNull((Object)cubeType.getLevel());
        select = mdxParser.parseSelect("select from [sales]");
        select = mdxValidator.validateSelect(select);
        ConnectionTest.assertEquals((Object)cubeType, (Object)select.getFrom().getType());
        select = mdxParser.parseSelect("select from [warehouse and sales]");
        select = mdxValidator.validateSelect(select);
        ConnectionTest.assertNotSame((Object)cubeType, (Object)select.getFrom().getType());
    }

    public void testAxisType() throws Throwable {
        if (this.tester.getFlavor() == TestContext.Tester.Flavor.XMLA || this.tester.getFlavor() == TestContext.Tester.Flavor.REMOTE_XMLA) {
            return;
        }
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        MdxParserFactory parserFactory = olapConnection.getParserFactory();
        MdxParser mdxParser = parserFactory.createMdxParser(olapConnection);
        MdxValidator mdxValidator = parserFactory.createMdxValidator(olapConnection);
        SelectNode select = mdxParser.parseSelect("select ([Gender], [Store]) on columns\n,{[Customers].[City].Members} on rows\nfrom [sales]\nwhere ([Time].[1997].[Q4], [Marital Status].[S])");
        select = mdxValidator.validateSelect(select);
        ConnectionTest.assertNull((Object)select.getType());
        AxisNode columnsAxis = (AxisNode)select.getAxisList().get(0);
        ConnectionTest.assertNull((Object)columnsAxis.getType());
        SetType setType = (SetType)columnsAxis.getExpression().getType();
        ConnectionTest.assertNull((Object)setType.getDimension());
        ConnectionTest.assertNull((Object)setType.getHierarchy());
        ConnectionTest.assertNull((Object)setType.getLevel());
        ConnectionTest.assertNotNull((Object)setType.toString());
        Type elementType = setType.getElementType();
        ConnectionTest.assertTrue((boolean)(elementType instanceof TupleType));
        TupleType tupleType = (TupleType)elementType;
        ConnectionTest.assertNotNull((Object)tupleType.toString());
        ConnectionTest.assertNull((Object)tupleType.getDimension());
        ConnectionTest.assertNull((Object)tupleType.getHierarchy());
        ConnectionTest.assertNull((Object)tupleType.getLevel());
        Cube cube = ((CubeType)select.getFrom().getType()).getCube();
        Dimension storeDimension = (Dimension)cube.getDimensions().get("Store");
        Dimension genderDimension = (Dimension)cube.getDimensions().get("Gender");
        Dimension measuresDimension = (Dimension)cube.getDimensions().get("Measures");
        Dimension customersDimension = (Dimension)cube.getDimensions().get("Customers");
        ConnectionTest.assertTrue((boolean)tupleType.usesDimension(storeDimension, false));
        ConnectionTest.assertTrue((boolean)tupleType.usesDimension(genderDimension, false));
        ConnectionTest.assertFalse((boolean)tupleType.usesDimension(measuresDimension, false));
        AxisNode rowsAxis = (AxisNode)select.getAxisList().get(1);
        Type rowsType = rowsAxis.getExpression().getType();
        ConnectionTest.assertTrue((boolean)(rowsType instanceof SetType));
        MemberType memberType = (MemberType)((SetType)rowsType).getElementType();
        ConnectionTest.assertNotNull((Object)memberType.toString());
        ConnectionTest.assertNull((String)"Customers", (Object)memberType.getMember());
        ConnectionTest.assertEquals((String)"City", (String)memberType.getLevel().getName());
        ConnectionTest.assertEquals((String)"Customers", (String)memberType.getHierarchy().getName());
        ConnectionTest.assertEquals((String)"Customers", (String)memberType.getDimension().getName());
        ConnectionTest.assertFalse((boolean)memberType.usesDimension(storeDimension, false));
        ConnectionTest.assertTrue((boolean)memberType.usesDimension(customersDimension, false));
        ConnectionTest.assertTrue((boolean)memberType.usesDimension(customersDimension, true));
        AxisNode filterAxis = select.getFilterAxis();
        ConnectionTest.assertNull((Object)filterAxis.getType());
        Type filterType = filterAxis.getExpression().getType();
        ConnectionTest.assertTrue((boolean)(filterType instanceof TupleType));
        ConnectionTest.assertEquals((String)"TupleType<MemberType<member=[Time].[Time].[1997].[Q4]>, MemberType<member=[Marital Status].[Marital Status].[S]>>", (String)filterType.toString());
    }

    public void testParseQueryWithNoFilter() throws Exception {
        if (this.tester.getFlavor() == TestContext.Tester.Flavor.XMLA || this.tester.getFlavor() != TestContext.Tester.Flavor.REMOTE_XMLA) {
            return;
        }
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        MdxParserFactory parserFactory = olapConnection.getParserFactory();
        MdxParser mdxParser = parserFactory.createMdxParser(olapConnection);
        MdxValidator mdxValidator = parserFactory.createMdxValidator(olapConnection);
        SelectNode select = mdxParser.parseSelect("select ([Gender], [Store]) on columns\n,{[Customers].[City].Members} on rows\nfrom [sales]");
        select = mdxValidator.validateSelect(select);
        AxisNode filterAxis = select.getFilterAxis();
        ConnectionTest.assertNotNull((Object)filterAxis);
        ConnectionTest.assertNull((Object)filterAxis.getExpression());
        try {
            select = mdxParser.parseSelect("select ([Gender], [Store]) on columns\n,{[Customers].[City].Members} on rows\nfrom [sales]\nwhere ()");
            ConnectionTest.fail((String)("expected parse error, got " + select));
        }
        catch (RuntimeException e) {
            ConnectionTest.assertTrue((TestContext.getStackTrace(e).indexOf("Syntax error at [4:10], token ')'") >= 0 ? 1 : 0) != 0);
        }
    }

    public void testValidateError() throws Exception {
        if (this.tester.getFlavor() == TestContext.Tester.Flavor.XMLA || this.tester.getFlavor() != TestContext.Tester.Flavor.XMLA) {
            return;
        }
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        MdxParserFactory parserFactory = olapConnection.getParserFactory();
        MdxParser mdxParser = parserFactory.createMdxParser(olapConnection);
        MdxValidator mdxValidator = parserFactory.createMdxValidator(olapConnection);
        SelectNode select = mdxParser.parseSelect("select ([Gender], [Store]) on columns\n,crossjoin([Customers].[City].Members, [Gender].members) on rows\nfrom [sales]");
        AxisNode filterAxis = select.getFilterAxis();
        ConnectionTest.assertNotNull((Object)filterAxis);
        ConnectionTest.assertNull((Object)filterAxis.getExpression());
        try {
            select = mdxValidator.validateSelect(select);
            ConnectionTest.fail((String)("expected parse error, got " + select));
        }
        catch (OlapException e) {
            ConnectionTest.assertEquals((String)"Validation error", (String)e.getMessage());
            String stackTrace = TestContext.getStackTrace(e);
            ConnectionTest.assertTrue((String)stackTrace, (boolean)stackTrace.contains("Hierarchy '[Gender]' appears in more than one independent axis."));
        }
    }

    static String memberListToString(List<Member> list) {
        StringBuilder buf = new StringBuilder();
        for (Member member : list) {
            buf.append(member.getUniqueName()).append(TestContext.NL);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStatementCancel() throws Throwable {
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        final OlapStatement olapStatement = olapConnection.createStatement();
        final Throwable[] exceptions = new Throwable[]{null};
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                    olapStatement.cancel();
                }
                catch (Throwable e) {
                    exceptions[0] = e;
                }
            }
        }).start();
        try {
            if (this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.XMLA) || this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.REMOTE_XMLA)) {
                MondrianProperties.instance().QueryTimeout.set(5);
            }
            CellSet cellSet = olapStatement.executeOlapQuery("SELECT Filter(\n [Product].Members *\n [Customers].Members *\n [Time].[Time].Members,\n 1 = 0) on columns\nfrom [Sales]");
            ConnectionTest.fail((String)("expected exception indicating stmt had been canceled, got cellSet " + cellSet));
        }
        catch (OlapException e) {
            ConnectionTest.assertTrue((String)e.getMessage(), (e.getMessage().indexOf("Query canceled") >= 0 ? 1 : 0) != 0);
        }
        finally {
            if (this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.XMLA) || this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.REMOTE_XMLA)) {
                MondrianProperties.instance().QueryTimeout.set(0);
            }
        }
        if (exceptions[0] != null) {
            throw exceptions[0];
        }
    }

    public void testStatementTimeout() throws Throwable {
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        OlapStatement olapStatement = olapConnection.createStatement();
        try {
            olapStatement.setQueryTimeout(-1);
            ConnectionTest.fail((String)"expected exception");
        }
        catch (SQLException e) {
            ConnectionTest.assertTrue((e.getMessage().indexOf("illegal timeout value ") >= 0 ? 1 : 0) != 0);
        }
        olapStatement.setQueryTimeout(1);
        if (this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.XMLA) || this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.REMOTE_XMLA)) {
            MondrianProperties.instance().QueryTimeout.set(1);
        }
        try {
            CellSet cellSet = olapStatement.executeOlapQuery("SELECT Filter(\n [Store].Members * \n [Customers].Members * \n [Time].[Time].Members, 1 = 0) on columns\nfrom [Sales]");
            ConnectionTest.fail((String)("expected exception indicating timeout, got cellSet " + cellSet));
        }
        catch (OlapException e) {
            if (this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.XMLA) || this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.REMOTE_XMLA)) {
                MondrianProperties.instance().QueryTimeout.set(0);
            }
            ConnectionTest.assertTrue((String)e.getMessage(), (e.getMessage().indexOf("Query timeout of ") >= 0 ? 1 : 0) != 0);
        }
    }

    public void testCellSetBug() throws SQLException {
    }

    public void testCellSetWithCalcMember() throws SQLException {
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        OlapStatement olapStatement = olapConnection.createStatement();
        CellSet cellSet = olapStatement.executeOlapQuery("WITH MEMBER [Measures].[Average Profit] AS'[Measures].[Profit] / [Measures].[Sales Count]'SELECT {[Measures].[Average Profit]} ON 0,\n{[Product].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].Children} ON 1\nFROM [Sales] WHERE ([Time.Weekly].[Week].[5])");
        TestContext.assertEqualsVerbose("Axis #0:\n{[Time].[Weekly].[1997].[5]}\nAxis #1:\n{[Measures].[Average Profit]}\nAxis #2:\n{[Product].[Product].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good]}\n{[Product].[Product].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Pearl]}\n{[Product].[Product].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Portsmouth]}\n{[Product].[Product].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Top Measure]}\n{[Product].[Product].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Walrus]}\nRow #0: $2.17\nRow #1: $2.60\nRow #2: $6.03\nRow #3: $1.54\nRow #4: $5.11\n", TestContext.toString(cellSet));
    }

    public void testBuildQuery() throws SQLException {
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        this.buildQuery(olapConnection, true);
        this.buildQuery(olapConnection, false);
    }

    private void buildQuery(OlapConnection olapConnection, boolean useCubeObject) throws OlapException {
        Catalog catalog = (Catalog)olapConnection.getOlapCatalogs().get("FoodMart");
        Schema schema = (Schema)catalog.getSchemas().get("FoodMart");
        Cube cube = (Cube)schema.getCubes().get("Sales");
        SelectNode query = new SelectNode();
        Object cubeNode = useCubeObject ? IdentifierNode.parseIdentifier((String)cube.getUniqueName()) : new CubeNode(null, cube);
        query.setFrom((ParseTreeNode)cubeNode);
        AxisNode columnAxis = new AxisNode(null, false, (Axis)Axis.COLUMNS, null, (ParseTreeNode)new CallNode(null, "MEMBERS", Syntax.Property, new ParseTreeNode[]{IdentifierNode.parseIdentifier((String)"[Gender]")}));
        AxisNode rowAxis = new AxisNode(null, false, (Axis)Axis.ROWS, null, (ParseTreeNode)new CallNode(null, "CHILDREN", Syntax.Property, new ParseTreeNode[]{IdentifierNode.parseIdentifier((String)"[Customers].[USA]")}));
        query.getAxisList().add(columnAxis);
        query.getAxisList().add(rowAxis);
        OlapStatement statement = olapConnection.createStatement();
        CellSet cellSet = statement.executeOlapQuery(query);
        TestContext.assertEqualsVerbose("Axis #0:\n{}\nAxis #1:\n{[Gender].[Gender].[All Gender]}\n{[Gender].[Gender].[F]}\n{[Gender].[Gender].[M]}\nAxis #2:\n{[Customers].[Customers].[USA].[CA]}\n{[Customers].[Customers].[USA].[OR]}\n{[Customers].[Customers].[USA].[WA]}\nRow #0: 74,748\nRow #0: 36,759\nRow #0: 37,989\nRow #1: 67,659\nRow #1: 33,036\nRow #1: 34,623\nRow #2: 124,366\nRow #2: 61,763\nRow #2: 62,603\n", TestContext.toString(cellSet));
    }

    public void testBuildQuery2() throws ClassNotFoundException, SQLException {
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        Schema schema = (Schema)((Catalog)olapConnection.getOlapCatalogs().get("FoodMart")).getSchemas().get("FoodMart");
        Cube cube = (Cube)schema.getCubes().get("Sales");
        Measure measure = (Measure)cube.getMeasures().get(0);
        ConnectionTest.assertEquals((String)"Unit Sales", (String)measure.getName());
        Dimension dimPromotionMedia = (Dimension)cube.getDimensions().get("Promotion Media");
        CubeNode cubeNode = new CubeNode(null, cube);
        MemberNode measuresQuantity = new MemberNode(null, (Member)measure);
        HierarchyNode promotionHierarchyNode = new HierarchyNode(null, dimPromotionMedia.getDefaultHierarchy());
        CallNode promotionChildren = new CallNode(null, "children", Syntax.Property, new ParseTreeNode[]{promotionHierarchyNode});
        ArrayList columnDimensionProperties = new ArrayList();
        AxisNode columnAxis = new AxisNode(null, false, (Axis)Axis.COLUMNS, columnDimensionProperties, (ParseTreeNode)new CallNode(null, "{}", Syntax.Braces, new ParseTreeNode[]{measuresQuantity}));
        ArrayList rowDimensionProperties = new ArrayList();
        AxisNode rowAxis = new AxisNode(null, false, (Axis)Axis.ROWS, rowDimensionProperties, (ParseTreeNode)new CallNode(null, "{}", Syntax.Braces, new ParseTreeNode[]{promotionChildren}));
        SelectNode query = new SelectNode();
        query.setFrom((ParseTreeNode)cubeNode);
        query.getAxisList().add(columnAxis);
        query.getAxisList().add(rowAxis);
        OlapStatement statement = olapConnection.createStatement();
        CellSet cellSet = statement.executeOlapQuery(query);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Position row : (CellSetAxis)cellSet.getAxes().get(1)) {
            for (Position column : (CellSetAxis)cellSet.getAxes().get(0)) {
                pw.print("ROW:");
                for (Member member : row.getMembers()) {
                    pw.print("[" + member.getName() + "]");
                }
                pw.print(" COL:");
                for (Member member : column.getMembers()) {
                    pw.print("[" + member.getName() + "]");
                }
                Cell cell = cellSet.getCell(new Position[]{column, row});
                pw.println(" CELL:" + cell.getFormattedValue());
            }
        }
        pw.flush();
        TestContext.assertEqualsVerbose("ROW:[Bulk Mail] COL:[Unit Sales] CELL:4,320\nROW:[Cash Register Handout] COL:[Unit Sales] CELL:6,697\nROW:[Daily Paper] COL:[Unit Sales] CELL:7,738\nROW:[Daily Paper, Radio] COL:[Unit Sales] CELL:6,891\nROW:[Daily Paper, Radio, TV] COL:[Unit Sales] CELL:9,513\nROW:[In-Store Coupon] COL:[Unit Sales] CELL:3,798\nROW:[No Media] COL:[Unit Sales] CELL:195,448\nROW:[Product Attachment] COL:[Unit Sales] CELL:7,544\nROW:[Radio] COL:[Unit Sales] CELL:2,454\nROW:[Street Handout] COL:[Unit Sales] CELL:5,753\nROW:[Sunday Paper] COL:[Unit Sales] CELL:4,339\nROW:[Sunday Paper, Radio] COL:[Unit Sales] CELL:5,945\nROW:[Sunday Paper, Radio, TV] COL:[Unit Sales] CELL:2,726\nROW:[TV] COL:[Unit Sales] CELL:3,607\n", sw.toString());
    }

    public void testCubeDimensionsOrder() throws Exception {
        String dimNames = "[Measures];[Store];[Store Size in SQFT];[Store Type];[Time];[Product];[Promotion Media];[Promotions];[Customers];[Education Level];[Gender];[Marital Status];[Yearly Income];";
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        Cube cube = (Cube)((Schema)((Catalog)olapConnection.getOlapCatalogs().get("FoodMart")).getSchemas().get("FoodMart")).getCubes().get("Sales");
        StringBuilder sb = new StringBuilder();
        for (Dimension dimension : cube.getDimensions()) {
            sb.append(dimension.getUniqueName()).append(";");
        }
        TestContext.assertEqualsVerbose(dimNames, sb.toString());
    }

    public void testCubesDrillthrough() throws Exception {
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        Cube cube = (Cube)((Schema)((Catalog)olapConnection.getOlapCatalogs().get("FoodMart")).getSchemas().get("FoodMart")).getCubes().get("Sales");
        switch (this.tester.getFlavor()) {
            case MONDRIAN: {
                ConnectionTest.assertTrue((boolean)cube.isDrillThroughEnabled());
                break;
            }
            case XMLA: 
            case REMOTE_XMLA: {
                ConnectionTest.assertFalse((boolean)cube.isDrillThroughEnabled());
                break;
            }
            default: {
                ConnectionTest.fail();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCubesDrillthroughReturnClause() throws Exception {
        if (this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.XMLA) || this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.REMOTE_XMLA)) {
            return;
        }
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        ResultSet rs = olapConnection.createStatement().executeQuery("DRILLTHROUGH\nSELECT {[Measures].[Unit Sales]} on columns\nfrom [Sales]\nwhere ([Promotions].[One Day Sale],\n [Store].[Store City].[Walla Walla],\n [Product].[Product Category].[Bread])\nRETURN [Customers].[Name], [Gender].[Gender]");
        try {
            this.assertDrillRowsEquals(rs, new String[]{"ROW:5956.0,M,", "ROW:6013.0,M,", "ROW:7293.0,M,", "ROW:7683.0,F,", "ROW:7683.0,F,"});
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCubesDrillthroughReturnClause2() throws Exception {
        if (this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.XMLA) || this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.REMOTE_XMLA)) {
            return;
        }
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        ResultSet rs = olapConnection.createStatement().executeQuery("DRILLTHROUGH\nSELECT {[Measures].[Unit Sales]} on columns\nfrom [Sales]\nwhere ([Promotions].[One Day Sale],\n [Store].[Store City].[Walla Walla],\n [Product].[Product Category].[Bread])\nRETURN [Customers].[Name]");
        try {
            this.assertDrillRowsEquals(rs, new String[]{"ROW:5956.0,", "ROW:6013.0,", "ROW:7293.0,", "ROW:7683.0,", "ROW:7683.0,"});
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCubesDrillthroughReturnClause3() throws Exception {
        if (this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.XMLA) || this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.REMOTE_XMLA)) {
            return;
        }
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        ResultSet rs = olapConnection.createStatement().executeQuery("DRILLTHROUGH\nSELECT\nfrom [Sales]\nwhere ([Promotions].[One Day Sale],\n [Store].[Store City].[Walla Walla],\n [Product].[Product Category].[Bread])\nRETURN [Customers].[Name]");
        try {
            this.assertDrillRowsEquals(rs, new String[]{"ROW:5956.0,", "ROW:6013.0,", "ROW:7293.0,", "ROW:7683.0,", "ROW:7683.0,"});
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCubesDrillthroughReturnClause4() throws Exception {
        if (this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.XMLA) || this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.REMOTE_XMLA)) {
            return;
        }
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        ResultSet rs = olapConnection.createStatement().executeQuery("DRILLTHROUGH\nSELECT {[Promotions].[One Day Sale]} on columns,\n{[Store].[Store City].[Walla Walla]} on rows\nfrom [Sales]\nwhere ([Product].[Product Category].[Pizza])\nRETURN [Measures].[Unit Sales], [Measures].[Store Sales]");
        try {
            this.assertDrillRowsEquals(rs, new String[]{"ROW:1.0,0.8,"});
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCubesDrillthroughReturnClause5() throws Exception {
        if (this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.XMLA) || this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.REMOTE_XMLA)) {
            return;
        }
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        ResultSet rs = olapConnection.createStatement().executeQuery("DRILLTHROUGH\nSELECT {[Promotions].[One Day Sale]} on columns,\n{[Store].[Store City].[Walla Walla]} on rows\nfrom [Sales]\nwhere ([Product].[Product Category].[Pizza])\nRETURN [Measures].[Store Sales]");
        try {
            this.assertDrillRowsEquals(rs, new String[]{"ROW:0.8,"});
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCubesDrillthroughReturnClause6() throws Exception {
        if (this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.XMLA) || this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.REMOTE_XMLA)) {
            return;
        }
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        ResultSet rs = olapConnection.createStatement().executeQuery("DRILLTHROUGH\nSELECT {[Measures].[Unit Sales]} on columns\nfrom [Sales]\nwhere ([Promotions].[One Day Sale],\n [Store].[Store City].[Walla Walla],\n [Product].[Product Category].[Bread])\nRETURN [Measures].[Store Sales]");
        try {
            this.assertDrillRowsEquals(rs, new String[]{"ROW:12.34,"});
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCubesDrillthroughReturnClause7() throws Exception {
        if (this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.XMLA) || this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.REMOTE_XMLA)) {
            return;
        }
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        ResultSet rs = olapConnection.createStatement().executeQuery("DRILLTHROUGH\nSELECT {[Measures].[Unit Sales]} on columns\nfrom [Sales]\nwhere ([Promotions].[One Day Sale],\n [Store].[Store City].[Walla Walla],\n [Product].[Product Category].[Bread])\nRETURN [Customers], [Measures].[Promotion Sales]");
        try {
            this.assertDrillRowsEquals(rs, new String[]{"ROW:USA,12.34,"});
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCubesDrillthroughReturnClause8() throws Exception {
        if (this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.XMLA) || this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.REMOTE_XMLA)) {
            return;
        }
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        ResultSet rs = olapConnection.createStatement().executeQuery("DRILLTHROUGH\nSELECT {[Measures].[Unit Sales]} on columns\nfrom [Sales]\nwhere ([Promotions].[One Day Sale],\n [Store].[Store City].[Walla Walla],\n [Product].[Product Category].[Bread])\nRETURN [Customers].[City], [Measures].[Promotion Sales]");
        try {
            this.assertDrillRowsEquals(rs, new String[]{"ROW:WA,Walla Walla,12.34,"});
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCubesDrillthroughReturnClause9() throws Exception {
        if (this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.XMLA) || this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.REMOTE_XMLA)) {
            return;
        }
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        ResultSet rs = olapConnection.createStatement().executeQuery("DRILLTHROUGH\nSELECT {[Measures].[Unit Sales]} on columns\nfrom [Sales]\nwhere ([Promotions].[One Day Sale],\n [Store].[Store City].[Walla Walla],\n [Product].[Product Category].[Bread])");
        try {
            this.assertDrillRowsEquals(rs, new String[]{"ROW:WA,Walla Walla,Store 22,1997.0,Q3,8.0,Food,Baked Goods,Bread,Muffins,Great,Great Muffins,One Day Sale,1.0,", "ROW:WA,Walla Walla,Store 22,1997.0,Q3,8.0,Food,Baked Goods,Bread,Muffins,Modell,Modell Cranberry Muffins,One Day Sale,1.0,", "ROW:WA,Walla Walla,Store 22,1997.0,Q3,8.0,Food,Baked Goods,Bread,Sliced Bread,Colony,Colony White Bread,One Day Sale,2.0,", "ROW:WA,Walla Walla,Store 22,1997.0,Q3,9.0,Food,Baked Goods,Bread,Muffins,Modell,Modell Blueberry Muffins,One Day Sale,1.0,", "ROW:WA,Walla Walla,Store 22,1997.0,Q3,9.0,Food,Baked Goods,Bread,Sliced Bread,Sphinx,Sphinx Wheat Bread,One Day Sale,1.0,"});
        }
        finally {
            rs.close();
        }
    }

    public void testCubesDrillthroughReturnClause10() throws Exception {
        if (this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.XMLA) || this.tester.getFlavor().equals((Object)TestContext.Tester.Flavor.REMOTE_XMLA)) {
            return;
        }
        Class.forName(this.tester.getDriverClassName());
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        ResultSet rs = olapConnection.createStatement().executeQuery("DRILLTHROUGH SELECT from [Sales] where ([Promotions].[One Day Sale], [Store].[Store City].[Walla Walla], [Product].[Product Category].[Bread]) RETURN [Time].[Day], [Measures].[Store Sales], [Measures].[Store Cost]");
        this.assertDrillRowsEquals(rs, new String[]{"ROW:1997.0,34.0,14.0,9.12,3.443,", "ROW:1997.0,38.0,10.0,3.22,1.288,"});
    }

    private void assertDrillRowsEquals(ResultSet rs, String[] expected) throws Exception {
        int i;
        ArrayList<String> rows = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        while (rs.next()) {
            sb.setLength(0);
            sb.append("ROW:");
            for (i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                sb.append(this.normalizeTrailingZeros(rs.getObject(i + 1)));
                sb.append(",");
            }
            rows.add(sb.toString());
        }
        Collections.sort(rows);
        Arrays.sort(expected);
        for (i = 0; i < rows.size(); ++i) {
            ConnectionTest.assertEquals((String)expected[i], (String)((String)rows.get(i)));
        }
    }

    private String normalizeTrailingZeros(Object str) {
        Double number;
        if (str == null) {
            return null;
        }
        try {
            number = Double.parseDouble(String.valueOf(str));
        }
        catch (NumberFormatException e) {
            return String.valueOf(str);
        }
        return String.valueOf(number);
    }

    public void _testDimensionProperties() throws SQLException {
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        String mdx = "select {[Product].[Product Family].Members} ON COLUMNS,\n{[Store].[Store Name].Members}\n  DIMENSION PROPERTIES [Store].[Store Name].[Store Sqft] ON ROWS\nfrom [Sales]\nwhere [Measures].[Unit Sales]";
        PreparedOlapStatement pstmt = olapConnection.prepareOlapStatement(mdx);
        pstmt.executeQuery();
    }

    public void testTransactionIsolation() throws SQLException {
        this.connection = this.tester.createConnection();
        ConnectionTest.assertEquals((int)0, (int)this.connection.getTransactionIsolation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSchemaAccessControl() throws Exception {
        if (this.tester.getFlavor() == TestContext.Tester.Flavor.XMLA || this.tester.getFlavor() == TestContext.Tester.Flavor.REMOTE_XMLA) {
            return;
        }
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        try {
            olapConnection.setRoleName("California manager");
            ArrayList<String> list = new ArrayList<String>();
            for (Schema schema : olapConnection.getOlapSchemas()) {
                list.add(schema.getName());
            }
            this.assertListsEquals(Arrays.asList("FoodMart"), list);
        }
        finally {
            olapConnection.setRoleName(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCubeAccessControl() throws Exception {
        if (this.tester.getFlavor() == TestContext.Tester.Flavor.XMLA || this.tester.getFlavor() == TestContext.Tester.Flavor.REMOTE_XMLA) {
            return;
        }
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        try {
            olapConnection.setRoleName("California manager");
            ArrayList<String> list = new ArrayList<String>();
            for (Cube cube : olapConnection.getOlapSchema().getCubes()) {
                list.add(cube.getName());
            }
            this.assertListsEquals(Arrays.asList("Sales"), list);
            olapConnection.setRoleName("No HR Cube");
            list.clear();
            for (Cube cube : olapConnection.getOlapSchema().getCubes()) {
                list.add(cube.getName());
            }
            this.assertListsEquals(Arrays.asList("Sales Ragged", "Warehouse", "Warehouse and Sales", "Sales 2", "Store", "Sales"), list);
        }
        finally {
            olapConnection.setRoleName(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDimensionAccessControl() throws Exception {
        if (this.tester.getFlavor() == TestContext.Tester.Flavor.XMLA || this.tester.getFlavor() == TestContext.Tester.Flavor.REMOTE_XMLA) {
            return;
        }
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        try {
            olapConnection.setRoleName("California manager");
            ArrayList<String> list = new ArrayList<String>();
            for (Dimension dimension : ((Cube)olapConnection.getOlapSchema().getCubes().get("Sales")).getDimensions()) {
                list.add(dimension.getName());
            }
            this.assertListsEquals(Arrays.asList("Measures", "Store", "Store Size in SQFT", "Store Type", "Time", "Product", "Promotion Media", "Promotions", "Customers", "Gender", "Education Level", "Marital Status", "Yearly Income"), list);
        }
        finally {
            olapConnection.setRoleName(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLevelAccessControl() throws Exception {
        if (this.tester.getFlavor() == TestContext.Tester.Flavor.XMLA || this.tester.getFlavor() == TestContext.Tester.Flavor.REMOTE_XMLA) {
            return;
        }
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        try {
            olapConnection.setRoleName("California manager");
            ArrayList<String> list = new ArrayList<String>();
            for (Level level : ((Hierarchy)((Dimension)((Cube)olapConnection.getOlapSchema().getCubes().get("Sales")).getDimensions().get("Customers")).getHierarchies().get(0)).getLevels()) {
                list.add(level.getName());
            }
            this.assertListsEquals(Arrays.asList("State Province", "City"), list);
        }
        finally {
            olapConnection.setRoleName(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLevelMembersAccessControl() throws Exception {
        if (this.tester.getFlavor() == TestContext.Tester.Flavor.XMLA || this.tester.getFlavor() == TestContext.Tester.Flavor.REMOTE_XMLA) {
            return;
        }
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        try {
            olapConnection.setRoleName("California manager");
            ArrayList<String> list = new ArrayList<String>();
            for (Member member : ((Level)((Hierarchy)((Dimension)((Cube)olapConnection.getOlapSchema().getCubes().get("Sales")).getDimensions().get("Store")).getHierarchies().get(0)).getLevels().get(0)).getMembers()) {
                list.add(member.getName());
            }
            ConnectionTest.assertEquals(Arrays.asList("USA"), list);
            list.clear();
            for (Member member : ((Level)((Hierarchy)((Dimension)((Cube)olapConnection.getOlapSchema().getCubes().get("Sales")).getDimensions().get("Store")).getHierarchies().get(0)).getLevels().get(1)).getMembers()) {
                list.add(member.getName());
            }
            this.assertListsEquals(Arrays.asList("CA"), list);
            list.clear();
            for (Member member : ((Level)((Hierarchy)((Dimension)((Cube)olapConnection.getOlapSchema().getCubes().get("Sales")).getDimensions().get("Store")).getHierarchies().get(0)).getLevels().get(2)).getMembers()) {
                list.add(member.getName());
            }
            this.assertListsEquals(Arrays.asList("Alameda", "Beverly Hills", "San Diego", "San Francisco"), list);
        }
        finally {
            olapConnection.setRoleName(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentChildAccessControl() throws Exception {
        if (this.tester.getFlavor() == TestContext.Tester.Flavor.XMLA || this.tester.getFlavor() == TestContext.Tester.Flavor.REMOTE_XMLA) {
            return;
        }
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        try {
            olapConnection.setRoleName("California manager");
            Member city = (Member)((Level)((Hierarchy)((Dimension)((Cube)olapConnection.getOlapSchema().getCubes().get("Sales")).getDimensions().get("Customers")).getHierarchies().get(0)).getLevels().get("City")).getMembers().get(0);
            ConnectionTest.assertEquals((int)0, (int)city.getChildMembers().size());
            Member state = (Member)((Level)((Hierarchy)((Dimension)((Cube)olapConnection.getOlapSchema().getCubes().get("Sales")).getDimensions().get("Customers")).getHierarchies().get(0)).getLevels().get("State Province")).getMembers().get(0);
            ConnectionTest.assertNull((Object)state.getParentMember());
        }
        finally {
            olapConnection.setRoleName(null);
        }
    }

    public void testLevelMembersIncludeCalculatedMembers() throws Exception {
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        List measures = ((Cube)olapConnection.getOlapSchema().getCubes().get("Sales")).getMeasures();
        for (Measure m : measures) {
            if (!m.getUniqueName().equals("[Measures].[Profit]") || !m.isCalculated()) continue;
            return;
        }
        ConnectionTest.fail((String)"Calculated measures not returned.");
    }

    protected void assertListsEquals(List<String> list1, List<String> list2) {
        Collections.sort(list1);
        Collections.sort(list2);
        ConnectionTest.assertEquals(list1, list2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Method {
        ClassName,
        Mode,
        Type,
        TypeName,
        OlapType;

    }
}

