/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.cmd;

import java.io.Serializable;
import org.activiti5.engine.ActivitiIllegalArgumentException;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti5.engine.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnlockExclusiveJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(UnlockExclusiveJobCmd.class);
    protected JobEntity job;

    public UnlockExclusiveJobCmd(JobEntity job) {
        this.job = job;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        ExecutionEntity execution;
        if (this.job == null) {
            throw new ActivitiIllegalArgumentException("job is null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Unlocking exclusive job {}", (Object)this.job.getId());
        }
        if (this.job.isExclusive() && this.job.getProcessInstanceId() != null && (execution = commandContext.getExecutionEntityManager().findExecutionById(this.job.getProcessInstanceId())) != null) {
            commandContext.getExecutionEntityManager().clearProcessInstanceLockTime(execution.getId());
        }
        return null;
    }
}

