/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.cmd;

import java.io.Serializable;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.ActivitiIllegalArgumentException;
import org.activiti5.engine.ActivitiObjectNotFoundException;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti5.engine.runtime.ProcessInstance;

public class SetProcessInstanceNameCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;
    protected String name;

    public SetProcessInstanceNameCmd(String processInstanceId, String name) {
        this.processInstanceId = processInstanceId;
        this.name = name;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.processInstanceId == null) {
            throw new ActivitiIllegalArgumentException("processInstanceId is null");
        }
        ExecutionEntity execution = commandContext.getExecutionEntityManager().findExecutionById(this.processInstanceId);
        if (execution == null) {
            throw new ActivitiObjectNotFoundException("process instance " + this.processInstanceId + " doesn't exist", ProcessInstance.class);
        }
        if (!execution.isProcessInstanceType()) {
            throw new ActivitiObjectNotFoundException("process instance " + this.processInstanceId + " doesn't exist, the given ID references an execution, though", ProcessInstance.class);
        }
        if (execution.isSuspended()) {
            throw new ActivitiException("process instance " + this.processInstanceId + " is suspended, cannot set name");
        }
        execution.setName(this.name);
        commandContext.getHistoryManager().recordProcessInstanceNameChange(this.processInstanceId, this.name);
        return null;
    }
}

