/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.cmd;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventDispatcher;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.impl.calendar.DurationHelper;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ClockReader;
import org.activiti.engine.runtime.Job;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti5.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.jobexecutor.TimerEventHandler;
import org.activiti5.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti5.engine.impl.persistence.entity.AbstractJobEntity;
import org.activiti5.engine.impl.persistence.entity.DeadLetterJobEntity;
import org.activiti5.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti5.engine.impl.persistence.entity.JobEntity;
import org.activiti5.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti5.engine.impl.persistence.entity.TimerJobEntity;
import org.activiti5.engine.impl.pvm.process.ActivityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRetryCmd
implements Command<Object> {
    private static final Logger log = LoggerFactory.getLogger((String)JobRetryCmd.class.getName());
    protected String jobId;
    protected Throwable exception;

    public JobRetryCmd(String jobId, Throwable exception) {
        this.jobId = jobId;
        this.exception = exception;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        JobEntity job = commandContext.getJobEntityManager().findJobById(this.jobId);
        if (job == null) {
            return null;
        }
        ActivityImpl activity = this.getCurrentActivity(commandContext, job);
        ProcessEngineConfigurationImpl processEngineConfig = commandContext.getProcessEngineConfiguration();
        AbstractJobEntity newJobEntity = null;
        if (activity == null || activity.getFailedJobRetryTimeCycleValue() == null) {
            log.debug("activitiy or FailedJobRetryTimerCycleValue is null in job " + this.jobId + "'. only decrementing retries.");
            if (job.getRetries() <= 1) {
                DeadLetterJobEntity deadLetterJob = new DeadLetterJobEntity(job);
                deadLetterJob.insert();
                newJobEntity = deadLetterJob;
            } else {
                TimerJobEntity timerJob = new TimerJobEntity(job);
                timerJob.insert();
                newJobEntity = timerJob;
            }
            newJobEntity.setRetries(job.getRetries() - 1);
            if (job.getDuedate() == null) {
                newJobEntity.setDuedate(this.calculateDueDate(commandContext, processEngineConfig.getAsyncFailedJobWaitTime(), null));
            } else {
                newJobEntity.setDuedate(this.calculateDueDate(commandContext, processEngineConfig.getDefaultFailedJobWaitTime(), job.getDuedate()));
            }
        } else {
            String failedJobRetryTimeCycle = activity.getFailedJobRetryTimeCycleValue();
            try {
                DurationHelper durationHelper = new DurationHelper(failedJobRetryTimeCycle, (ClockReader)processEngineConfig.getClock());
                int jobRetries = job.getRetries();
                if (job.getExceptionMessage() == null) {
                    jobRetries = durationHelper.getTimes();
                }
                if (job.getRetries() <= 1) {
                    DeadLetterJobEntity deadLetterJob = new DeadLetterJobEntity(job);
                    deadLetterJob.insert();
                    newJobEntity = deadLetterJob;
                } else {
                    TimerJobEntity timerJob = new TimerJobEntity(job);
                    timerJob.insert();
                    newJobEntity = timerJob;
                }
                newJobEntity.setDuedate(durationHelper.getDateAfter());
                if (job.getExceptionMessage() == null) {
                    log.debug("Applying JobRetryStrategy '" + failedJobRetryTimeCycle + "' the first time for job " + job.getId() + " with " + durationHelper.getTimes() + " retries");
                } else {
                    log.debug("Decrementing retries of JobRetryStrategy '" + failedJobRetryTimeCycle + "' for job " + job.getId());
                }
                newJobEntity.setRetries(jobRetries - 1);
            }
            catch (Exception e) {
                throw new ActivitiException("failedJobRetryTimeCylcle has wrong format:" + failedJobRetryTimeCycle, this.exception);
            }
        }
        if (this.exception != null) {
            newJobEntity.setExceptionMessage(this.exception.getMessage());
            newJobEntity.setExceptionStacktrace(this.getExceptionStacktrace());
        }
        job.delete();
        ActivitiEventDispatcher eventDispatcher = commandContext.getEventDispatcher();
        if (eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, newJobEntity));
            eventDispatcher.dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_RETRIES_DECREMENTED, newJobEntity));
        }
        return null;
    }

    protected Date calculateDueDate(CommandContext commandContext, int waitTimeInSeconds, Date oldDate) {
        GregorianCalendar newDateCal = new GregorianCalendar();
        if (oldDate != null) {
            newDateCal.setTime(oldDate);
        } else {
            newDateCal.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        }
        ((Calendar)newDateCal).add(13, waitTimeInSeconds);
        return newDateCal.getTime();
    }

    private ActivityImpl getCurrentActivity(CommandContext commandContext, Job job) {
        ExecutionEntity execution;
        String type = job.getJobHandlerType();
        ActivityImpl activity = null;
        if ("timer-transition".equals(type) || "timer-intermediate-transition".equals(type)) {
            ExecutionEntity execution2 = this.fetchExecutionEntity(commandContext, job.getExecutionId());
            if (execution2 != null) {
                activity = execution2.getProcessDefinition().findActivity(job.getJobHandlerConfiguration());
            }
        } else if ("timer-start-event".equals(type)) {
            DeploymentManager deploymentManager = commandContext.getProcessEngineConfiguration().getDeploymentManager();
            if (TimerEventHandler.hasRealActivityId(job.getJobHandlerConfiguration())) {
                ProcessDefinition processDefinition = deploymentManager.findDeployedProcessDefinitionById(job.getProcessDefinitionId());
                String activityId = TimerEventHandler.getActivityIdFromConfiguration(job.getJobHandlerConfiguration());
                activity = ((ProcessDefinitionEntity)processDefinition).findActivity(activityId);
            } else {
                String processId = job.getJobHandlerConfiguration();
                if (job instanceof TimerJobEntity) {
                    processId = TimerEventHandler.getActivityIdFromConfiguration(job.getJobHandlerConfiguration());
                }
                ProcessDefinition processDefinition = null;
                processDefinition = job.getTenantId() != null && job.getTenantId().length() > 0 ? deploymentManager.findDeployedLatestProcessDefinitionByKeyAndTenantId(processId, job.getTenantId()) : deploymentManager.findDeployedLatestProcessDefinitionByKey(processId);
                if (processDefinition != null) {
                    activity = ((ProcessDefinitionEntity)processDefinition).getInitial();
                }
            }
        } else if ("async-continuation".equals(type) && (execution = this.fetchExecutionEntity(commandContext, job.getExecutionId())) != null) {
            activity = execution.getActivity();
        }
        return activity;
    }

    private String getExceptionStacktrace() {
        StringWriter stringWriter = new StringWriter();
        this.exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private ExecutionEntity fetchExecutionEntity(CommandContext commandContext, String executionId) {
        return commandContext.getExecutionEntityManager().findExecutionById(executionId);
    }
}

