/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti5.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti5.engine.impl.cmd.ActivateProcessDefinitionCmd;
import org.activiti5.engine.impl.cmd.SuspendProcessDefinitionCmd;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti5.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti5.engine.impl.persistence.entity.ResourceEntity;
import org.activiti5.engine.impl.repository.DeploymentBuilderImpl;
import org.activiti5.engine.repository.Deployment;
import org.activiti5.engine.repository.DeploymentQuery;

public class DeployCmd<T>
implements Command<Deployment>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected DeploymentBuilderImpl deploymentBuilder;

    public DeployCmd(DeploymentBuilderImpl deploymentBuilder) {
        this.deploymentBuilder = deploymentBuilder;
    }

    @Override
    public Deployment execute(CommandContext commandContext) {
        DeploymentEntity deployment = this.deploymentBuilder.getDeployment();
        deployment.setDeploymentTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        if (this.deploymentBuilder.isDuplicateFilterEnabled()) {
            DeploymentEntity existingDeployment;
            ArrayList<DeploymentEntity> existingDeployments = new ArrayList<DeploymentEntity>();
            if (deployment.getTenantId() == null || "".equals(deployment.getTenantId())) {
                existingDeployment = commandContext.getDeploymentEntityManager().findLatestDeploymentByName(deployment.getName());
                if (existingDeployment != null) {
                    existingDeployments.add(existingDeployment);
                }
            } else {
                List deploymentList = ((DeploymentQuery)commandContext.getProcessEngineConfiguration().getRepositoryService().createDeploymentQuery().deploymentName(deployment.getName()).deploymentTenantId(deployment.getTenantId()).orderByDeploymentId().desc()).list();
                if (!deploymentList.isEmpty()) {
                    existingDeployments.addAll(deploymentList);
                }
            }
            existingDeployment = null;
            if (!existingDeployments.isEmpty()) {
                existingDeployment = (DeploymentEntity)existingDeployments.get(0);
            }
            if (existingDeployment != null && !this.deploymentsDiffer(deployment, existingDeployment)) {
                return existingDeployment;
            }
        }
        deployment.setNew(true);
        commandContext.getDeploymentEntityManager().insertDeployment(deployment);
        if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, deployment));
        }
        HashMap<String, Object> deploymentSettings = new HashMap<String, Object>();
        deploymentSettings.put("isBpmn20XsdValidationEnabled", this.deploymentBuilder.isBpmn20XsdValidationEnabled());
        deploymentSettings.put("isProcessValidationEnabled", this.deploymentBuilder.isProcessValidationEnabled());
        commandContext.getProcessEngineConfiguration().getDeploymentManager().deploy(deployment, deploymentSettings);
        if (this.deploymentBuilder.getProcessDefinitionsActivationDate() != null) {
            this.scheduleProcessDefinitionActivation(commandContext, deployment);
        }
        if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, deployment));
        }
        return deployment;
    }

    protected boolean deploymentsDiffer(DeploymentEntity deployment, DeploymentEntity saved) {
        if (deployment.getResources() == null || saved.getResources() == null) {
            return true;
        }
        Map<String, ResourceEntity> resources = deployment.getResources();
        Map<String, ResourceEntity> savedResources = saved.getResources();
        for (String resourceName : resources.keySet()) {
            byte[] savedBytes;
            ResourceEntity resource;
            byte[] bytes;
            ResourceEntity savedResource = savedResources.get(resourceName);
            if (savedResource == null) {
                return true;
            }
            if (savedResource.isGenerated() || Arrays.equals(bytes = (resource = resources.get(resourceName)).getBytes(), savedBytes = savedResource.getBytes())) continue;
            return true;
        }
        return false;
    }

    protected void scheduleProcessDefinitionActivation(CommandContext commandContext, DeploymentEntity deployment) {
        for (ProcessDefinitionEntity processDefinitionEntity : deployment.getDeployedArtifacts(ProcessDefinitionEntity.class)) {
            SuspendProcessDefinitionCmd suspendProcessDefinitionCmd = new SuspendProcessDefinitionCmd(processDefinitionEntity, false, null, deployment.getTenantId());
            suspendProcessDefinitionCmd.execute(commandContext);
            ActivateProcessDefinitionCmd activateProcessDefinitionCmd = new ActivateProcessDefinitionCmd(processDefinitionEntity, false, this.deploymentBuilder.getProcessDefinitionsActivationDate(), deployment.getTenantId());
            activateProcessDefinitionCmd.execute(commandContext);
        }
    }
}

