/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.JavaDelegate;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.delegate.ActivityBehavior;
import org.activiti5.engine.ActivitiIllegalArgumentException;
import org.activiti5.engine.delegate.BpmnError;
import org.activiti5.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti5.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.activiti5.engine.impl.bpmn.helper.DelegateExpressionUtil;
import org.activiti5.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti5.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.activiti5.engine.impl.bpmn.parser.FieldDeclaration;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.delegate.ActivityBehaviorInvocation;
import org.activiti5.engine.impl.delegate.JavaDelegateInvocation;
import org.activiti5.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti5.engine.impl.pvm.delegate.SignallableActivityBehavior;
import org.apache.commons.lang3.StringUtils;

public class ServiceTaskDelegateExpressionActivityBehavior
extends TaskActivityBehavior {
    protected String serviceTaskId;
    protected Expression expression;
    protected Expression skipExpression;
    private final List<FieldDeclaration> fieldDeclarations;

    public ServiceTaskDelegateExpressionActivityBehavior(String serviceTaskId, Expression expression, Expression skipExpression, List<FieldDeclaration> fieldDeclarations) {
        this.serviceTaskId = serviceTaskId;
        this.expression = expression;
        this.skipExpression = skipExpression;
        this.fieldDeclarations = fieldDeclarations;
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        Object delegate = DelegateExpressionUtil.resolveDelegateExpression(this.expression, (VariableScope)execution, this.fieldDeclarations);
        if (delegate instanceof SignallableActivityBehavior) {
            ((SignallableActivityBehavior)delegate).signal(execution, signalName, signalData);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(DelegateExecution execution) {
        ActivityExecution activityExecution = (ActivityExecution)execution;
        try {
            boolean isSkipExpressionEnabled = SkipExpressionUtil.isSkipExpressionEnabled(activityExecution, this.skipExpression);
            if (!isSkipExpressionEnabled || isSkipExpressionEnabled && !SkipExpressionUtil.shouldSkipFlowElement(activityExecution, this.skipExpression)) {
                Object object;
                String overrideExpression;
                ObjectNode objectNode;
                if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache() && (objectNode = Context.getBpmnOverrideElementProperties(this.serviceTaskId, execution.getProcessDefinitionId())) != null && objectNode.has("serviceTaskDelegateExpression") && StringUtils.isNotEmpty((CharSequence)(overrideExpression = objectNode.get("serviceTaskDelegateExpression").asText())) && !overrideExpression.equals(this.expression.getExpressionText())) {
                    this.expression = Context.getProcessEngineConfiguration().getExpressionManager().createExpression(overrideExpression);
                }
                if ((object = DelegateExpressionUtil.resolveDelegateExpression(this.expression, (VariableScope)execution, this.fieldDeclarations)) instanceof ActivityBehavior) {
                    if (object instanceof AbstractBpmnActivityBehavior) {
                        ((AbstractBpmnActivityBehavior)object).setMultiInstanceActivityBehavior(this.getMultiInstanceActivityBehavior());
                    }
                    Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ActivityBehaviorInvocation((ActivityBehavior)object, activityExecution));
                    return;
                } else {
                    if (!(object instanceof JavaDelegate)) throw new ActivitiIllegalArgumentException("Delegate expression " + this.expression + " did neither resolve to an implementation of " + ActivityBehavior.class + " nor " + JavaDelegate.class);
                    Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new JavaDelegateInvocation((JavaDelegate)object, execution));
                    this.leave(activityExecution);
                }
                return;
            } else {
                this.leave(activityExecution);
            }
            return;
        }
        catch (Exception exc) {
            void var4_8;
            Exception exception = exc;
            BpmnError error = null;
            while (var4_8 != null) {
                if (var4_8 instanceof BpmnError) {
                    error = (BpmnError)var4_8;
                    break;
                }
                Throwable throwable = var4_8.getCause();
            }
            if (error == null) throw new ActivitiException(exc.getMessage(), (Throwable)exc);
            ErrorPropagation.propagateError(error, activityExecution);
            return;
        }
    }
}

