/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cdi.impl.annotation;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.activiti.cdi.ActivitiCdiException;
import org.activiti.cdi.BusinessProcess;
import org.activiti.cdi.annotation.CompleteTask;

@Interceptor
@CompleteTask
public class CompleteTaskInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    BusinessProcess businessProcess;

    @AroundInvoke
    public Object invoke(InvocationContext ctx) throws Exception {
        try {
            Object result = ctx.proceed();
            CompleteTask completeTaskAnnotation = ctx.getMethod().getAnnotation(CompleteTask.class);
            boolean endConversation = completeTaskAnnotation.endConversation();
            this.businessProcess.completeTask(endConversation);
            return result;
        }
        catch (InvocationTargetException e) {
            throw new ActivitiCdiException("Error while completing task: " + e.getCause().getMessage(), e.getCause());
        }
    }
}

