/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cdi.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.enterprise.context.spi.Context;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import org.activiti.cdi.annotation.BusinessProcessScoped;
import org.activiti.cdi.impl.ProcessDeployer;
import org.activiti.cdi.impl.context.BusinessProcessContext;
import org.activiti.cdi.impl.util.ActivitiServices;
import org.activiti.cdi.impl.util.BeanManagerLookup;
import org.activiti.cdi.impl.util.ProgrammaticBeanLookup;
import org.activiti.cdi.spi.ProcessEngineLookup;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ProcessEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivitiExtension
implements Extension {
    private static Logger logger = LoggerFactory.getLogger(ActivitiExtension.class);
    private ProcessEngineLookup processEngineLookup;

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event) {
        event.addScope(BusinessProcessScoped.class, true, true);
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager manager) {
        BeanManagerLookup.localInstance = manager;
        event.addContext((Context)new BusinessProcessContext(manager));
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        try {
            logger.info("Initializing activiti-cdi.");
            ProcessEngine processEngine = this.lookupProcessEngine(beanManager);
            this.deployProcesses(processEngine);
        }
        catch (Exception e) {
            event.addDeploymentProblem((Throwable)e);
        }
    }

    protected ProcessEngine lookupProcessEngine(BeanManager beanManager) {
        ServiceLoader<ProcessEngineLookup> processEngineServiceLoader = ServiceLoader.load(ProcessEngineLookup.class);
        Iterator<ProcessEngineLookup> serviceIterator = processEngineServiceLoader.iterator();
        ArrayList<ProcessEngineLookup> discoveredLookups = new ArrayList<ProcessEngineLookup>();
        while (serviceIterator.hasNext()) {
            ProcessEngineLookup serviceInstance = serviceIterator.next();
            discoveredLookups.add(serviceInstance);
        }
        Collections.sort(discoveredLookups, new Comparator<ProcessEngineLookup>(){

            @Override
            public int compare(ProcessEngineLookup o1, ProcessEngineLookup o2) {
                return -1 * Integer.valueOf(o1.getPrecedence()).compareTo(o2.getPrecedence());
            }
        });
        ProcessEngine processEngine = null;
        for (ProcessEngineLookup processEngineLookup : discoveredLookups) {
            processEngine = processEngineLookup.getProcessEngine();
            if (processEngine != null) {
                this.processEngineLookup = processEngineLookup;
                logger.debug("ProcessEngineLookup service {} returned process engine.", processEngineLookup.getClass());
                break;
            }
            logger.debug("ProcessEngineLookup service {} retuned 'null' value.", processEngineLookup.getClass());
        }
        if (this.processEngineLookup == null) {
            throw new ActivitiException("Could not find an implementation of the org.activiti.cdi.spi.ProcessEngineLookup service returning a non-null processEngine. Giving up.");
        }
        ActivitiServices activitiServices = ProgrammaticBeanLookup.lookup(ActivitiServices.class, beanManager);
        activitiServices.setProcessEngine(processEngine);
        return processEngine;
    }

    private void deployProcesses(ProcessEngine processEngine) {
        new ProcessDeployer(processEngine).deployProcesses();
    }

    public void beforeShutdown(@Observes BeforeShutdown event) {
        if (this.processEngineLookup != null) {
            this.processEngineLookup.ungetProcessEngine();
            this.processEngineLookup = null;
        }
        logger.info("Shutting down activiti-cdi");
    }
}

