/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cdi;

import java.util.Map;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.inject.Named;
import org.activiti.cdi.BusinessProcess;
import org.activiti.cdi.annotation.ProcessVariable;
import org.activiti.cdi.impl.ProcessVariableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessVariables {
    private Logger logger = LoggerFactory.getLogger(ProcessVariables.class);
    @Inject
    private BusinessProcess businessProcess;
    @Inject
    private ProcessVariableMap processVariableMap;

    protected String getVariableName(InjectionPoint ip) {
        String variableName = ((ProcessVariable)ip.getAnnotated().getAnnotation(ProcessVariable.class)).value();
        if (variableName.length() == 0) {
            variableName = ip.getMember().getName();
        }
        return variableName;
    }

    @Produces
    @ProcessVariable
    protected Object getProcessVariable(InjectionPoint ip) {
        String processVariableName = this.getVariableName(ip);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Getting process variable '{}' from ProcessInstance[{}].", (Object)processVariableName, (Object)this.businessProcess.getProcessInstanceId());
        }
        return this.businessProcess.getVariable(processVariableName);
    }

    @Produces
    @Named
    protected Map<String, Object> processVariables() {
        return this.processVariableMap;
    }
}

