/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.olap4j.metadata.MetadataElement;
import org.pivot4j.util.OlapUtils;
import org.pivot4j.util.TreeNodeCallback;

public class TreeNode<T> {
    private TreeNode<T> parent;
    private List<TreeNode<T>> children = new ArrayList<TreeNode<T>>();
    private T reference;

    public TreeNode() {
    }

    public TreeNode(T obj) {
        this.reference = obj;
    }

    public void remove() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    public void removeChild(TreeNode<T> child) {
        if (this.children.contains(child)) {
            this.children.remove(child);
        }
    }

    public void clear() {
        this.children.clear();
    }

    public void addChild(TreeNode<T> child) {
        if (!this.children.contains(child)) {
            child.parent = this;
            this.children.add(child);
        }
    }

    public void addChild(int index, TreeNode<T> child) {
        if (!this.children.contains(child)) {
            child.parent = this;
            this.children.add(index, child);
        }
    }

    public TreeNode<T> deepCopy() {
        TreeNode<T> newNode = new TreeNode<T>(this.reference);
        for (TreeNode<T> child : this.children) {
            newNode.addChild(child.deepCopy());
        }
        return newNode;
    }

    public TreeNode<T> deepCopyPrune(int depth) {
        if (depth < 0) {
            throw new IllegalArgumentException("Depth is negative");
        }
        TreeNode<T> newNode = new TreeNode<T>(this.reference);
        if (depth == 0) {
            return newNode;
        }
        for (TreeNode<T> child : this.children) {
            newNode.addChild(child.deepCopyPrune(depth - 1));
        }
        return newNode;
    }

    public int getLevel() {
        int level = 0;
        TreeNode<T> p = this.parent;
        while (p != null) {
            ++level;
            p = p.parent;
        }
        return level;
    }

    public int getMaxDescendantLevel() {
        int level;
        if (this.getChildCount() == 0) {
            level = this.getLevel();
        } else {
            level = 0;
            for (TreeNode<T> child : this.getChildren()) {
                level = Math.max(level, child.getMaxDescendantLevel());
            }
        }
        return level;
    }

    public int getWidth() {
        int width = 0;
        if (this.getChildCount() > 0) {
            for (TreeNode<T> child : this.getChildren()) {
                width += child.getWidth();
            }
        }
        return Math.max(1, width);
    }

    public int walkTree(TreeNodeCallback<T> callbackHandler) {
        int code = 0;
        code = callbackHandler.handleTreeNode(this);
        if (code != 0) {
            return code;
        }
        for (TreeNode<T> child : this.children) {
            code = child.walkTree(callbackHandler);
            if (code < 2) continue;
            return code;
        }
        return code;
    }

    public int walkChildren(TreeNodeCallback<T> callbackHandler) {
        int code = 0;
        for (TreeNode<T> child : this.children) {
            code = callbackHandler.handleTreeNode(child);
            if (code >= 2) {
                return code;
            }
            if (code != 0 || (code = child.walkChildren(callbackHandler)) <= 2) continue;
            return code;
        }
        return code;
    }

    public List<TreeNode<T>> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public TreeNode<T> getParent() {
        return this.parent;
    }

    public TreeNode<T> getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public T getReference() {
        return this.reference;
    }

    public void setReference(T object) {
        this.reference = object;
    }

    public TreeNode<T> findNode(T reference) {
        TreeNode<T> node = null;
        if (this.isEquals(this.getReference(), reference)) {
            node = this;
        } else {
            TreeNode<T> child;
            Iterator<TreeNode<T>> iterator = this.getChildren().iterator();
            while (iterator.hasNext() && (node = (child = iterator.next()).findNode(reference)) == null) {
            }
        }
        return node;
    }

    private boolean isEquals(T reference, T otherReference) {
        if (reference instanceof MetadataElement && otherReference instanceof MetadataElement) {
            return OlapUtils.equals((MetadataElement)reference, (MetadataElement)otherReference);
        }
        return ObjectUtils.equals(reference, otherReference);
    }

    public TreeNode<T> findChild(T reference) {
        TreeNode<T> child;
        TreeNode<T> node = null;
        Iterator<TreeNode<T>> iterator = this.getChildren().iterator();
        while (iterator.hasNext() && (node = (child = iterator.next()).findNode(reference)) == null) {
        }
        return node;
    }
}

