/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.pivot4j.el.EvaluationFailedException;
import org.pivot4j.ui.RenderContext;
import org.pivot4j.ui.property.RenderProperty;
import org.pivot4j.ui.property.RenderPropertyList;

public class RenderPropertyUtils {
    private RenderContext context;
    private Map<String, Map<String, EvaluationFailedException>> errors;
    private boolean suppressErrors;

    public RenderPropertyUtils(RenderContext context) {
        if (context == null) {
            throw new NullArgumentException("context");
        }
        this.context = context;
        this.clearErrors();
    }

    public Object getValue(String name, String category, Object defaultValue) {
        try {
            return RenderPropertyUtils.getValue(name, category, defaultValue, this.context);
        }
        catch (EvaluationFailedException e) {
            if (this.suppressErrors) {
                this.addError(name, category, e);
                return defaultValue;
            }
            throw e;
        }
    }

    public static Object getValue(String name, String category, Object defaultValue, RenderContext context) {
        RenderProperty property;
        if (name == null) {
            throw new NullArgumentException("name");
        }
        if (category == null) {
            throw new NullArgumentException("category");
        }
        if (context == null) {
            throw new NullArgumentException("context");
        }
        Object value = null;
        RenderPropertyList properties = context.getRenderProperties().get(category);
        if (properties != null && (property = properties.getRenderProperty(name)) != null) {
            value = property.getValue(context);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String getString(String name, String category, String defaultValue) {
        try {
            return RenderPropertyUtils.getString(name, category, defaultValue, this.context);
        }
        catch (EvaluationFailedException e) {
            if (this.suppressErrors) {
                this.addError(name, category, e);
                return defaultValue;
            }
            throw e;
        }
    }

    public static String getString(String name, String category, String defaultValue, RenderContext context) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        if (category == null) {
            throw new NullArgumentException("category");
        }
        if (context == null) {
            throw new NullArgumentException("context");
        }
        Object value = RenderPropertyUtils.getValue(name, category, null, context);
        String stringValue = StringUtils.trimToNull((String)ObjectUtils.toString((Object)value));
        if (stringValue == null) {
            stringValue = defaultValue;
        }
        return stringValue;
    }

    public Integer getInteger(String name, String category, Integer defaultValue) {
        try {
            return RenderPropertyUtils.getInteger(name, category, defaultValue, this.context);
        }
        catch (EvaluationFailedException e) {
            if (this.suppressErrors) {
                this.addError(name, category, e);
                return defaultValue;
            }
            throw e;
        }
    }

    public static Integer getInteger(String name, String category, Integer defaultValue, RenderContext context) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        if (category == null) {
            throw new NullArgumentException("category");
        }
        if (context == null) {
            throw new NullArgumentException("context");
        }
        Integer intValue = defaultValue;
        Object value = RenderPropertyUtils.getValue(name, category, defaultValue, context);
        if (value instanceof Integer) {
            intValue = (Integer)value;
        } else if ((value = StringUtils.trimToNull((String)ObjectUtils.toString((Object)value))) != null) {
            intValue = Integer.parseInt((String)value);
        }
        return intValue;
    }

    public Float getFloat(String name, String category, Float defaultValue) {
        try {
            return RenderPropertyUtils.getFloat(name, category, defaultValue, this.context);
        }
        catch (EvaluationFailedException e) {
            if (this.suppressErrors) {
                this.addError(name, category, e);
                return defaultValue;
            }
            throw e;
        }
    }

    public static Float getFloat(String name, String category, Float defaultValue, RenderContext context) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        if (category == null) {
            throw new NullArgumentException("category");
        }
        if (context == null) {
            throw new NullArgumentException("context");
        }
        Float floatValue = defaultValue;
        Object value = RenderPropertyUtils.getValue(name, category, defaultValue, context);
        if (value instanceof Float) {
            floatValue = (Float)value;
        } else if ((value = StringUtils.trimToNull((String)ObjectUtils.toString((Object)value))) != null) {
            floatValue = Float.valueOf(Float.parseFloat((String)value));
        }
        return floatValue;
    }

    public Double getDouble(String name, String category, Double defaultValue) {
        try {
            return RenderPropertyUtils.getDouble(name, category, defaultValue, this.context);
        }
        catch (EvaluationFailedException e) {
            if (this.suppressErrors) {
                this.addError(name, category, e);
                return defaultValue;
            }
            throw e;
        }
    }

    public static Double getDouble(String name, String category, Double defaultValue, RenderContext context) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        if (category == null) {
            throw new NullArgumentException("category");
        }
        if (context == null) {
            throw new NullArgumentException("context");
        }
        Double doubleValue = defaultValue;
        Object value = RenderPropertyUtils.getValue(name, category, defaultValue, context);
        if (value instanceof Double) {
            doubleValue = (Double)value;
        } else if ((value = StringUtils.trimToNull((String)ObjectUtils.toString((Object)value))) != null) {
            doubleValue = Double.parseDouble((String)value);
        }
        return doubleValue;
    }

    public Boolean getBoolean(String name, String category, Boolean defaultValue) {
        try {
            return RenderPropertyUtils.getBoolean(name, category, defaultValue, this.context);
        }
        catch (EvaluationFailedException e) {
            if (this.suppressErrors) {
                this.addError(name, category, e);
                return defaultValue;
            }
            throw e;
        }
    }

    public static Boolean getBoolean(String name, String category, Boolean defaultValue, RenderContext context) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        if (category == null) {
            throw new NullArgumentException("category");
        }
        if (context == null) {
            throw new NullArgumentException("context");
        }
        Boolean booleanValue = defaultValue;
        Object value = RenderPropertyUtils.getValue(name, category, defaultValue, context);
        if (value instanceof Boolean) {
            booleanValue = (Boolean)value;
        } else if ((value = StringUtils.trimToNull((String)ObjectUtils.toString((Object)value))) != null) {
            booleanValue = Boolean.parseBoolean((String)value);
        }
        return booleanValue;
    }

    public boolean getSuppressErrors() {
        return this.suppressErrors;
    }

    public void setSuppressErrors(boolean suppressErrors) {
        this.suppressErrors = suppressErrors;
    }

    protected void addError(String name, String category, EvaluationFailedException exception) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        if (category == null) {
            throw new NullArgumentException("category");
        }
        if (exception == null) {
            throw new NullArgumentException("exception");
        }
        Map<String, EvaluationFailedException> errorsInCategory = this.errors.get(category);
        if (errorsInCategory == null) {
            errorsInCategory = new HashMap<String, EvaluationFailedException>();
            this.errors.put(category, errorsInCategory);
        }
        errorsInCategory.put(name, exception);
    }

    public Map<String, EvaluationFailedException> getLastErrors(String category) {
        if (category == null) {
            throw new NullArgumentException("category");
        }
        Map<String, EvaluationFailedException> errorsInCategory = this.errors.get(category);
        if (errorsInCategory == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(errorsInCategory);
    }

    public void clearErrors() {
        this.errors = new HashMap<String, Map<String, EvaluationFailedException>>();
    }
}

