/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.property;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.ObjectUtils;
import org.pivot4j.el.ExpressionEvaluator;
import org.pivot4j.ui.RenderContext;
import org.pivot4j.ui.condition.Condition;
import org.pivot4j.ui.condition.ConditionFactory;
import org.pivot4j.ui.property.AbstractRenderProperty;
import org.pivot4j.ui.property.ConditionalValue;

public class ConditionalRenderProperty
extends AbstractRenderProperty {
    private String defaultValue;
    private ConditionFactory conditionFactory;
    private List<ConditionalValue> values;

    ConditionalRenderProperty(ConditionFactory conditionFactory) {
        if (conditionFactory == null) {
            throw new NullArgumentException("conditionFactory");
        }
        this.conditionFactory = conditionFactory;
    }

    public ConditionalRenderProperty(String name, ConditionFactory conditionFactory) {
        super(name);
        if (conditionFactory == null) {
            throw new NullArgumentException("conditionFactory");
        }
        this.conditionFactory = conditionFactory;
    }

    public ConditionalRenderProperty(String name, String defaultValue, List<ConditionalValue> values, ConditionFactory conditionFactory) {
        super(name);
        if (conditionFactory == null) {
            throw new NullArgumentException("conditionFactory");
        }
        this.defaultValue = defaultValue;
        this.values = values;
        this.conditionFactory = conditionFactory;
    }

    protected ConditionFactory getConditionFactory() {
        return this.conditionFactory;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public List<ConditionalValue> getValues() {
        return this.values;
    }

    public void setValues(List<ConditionalValue> values) {
        this.values = values;
    }

    @Override
    public String getValue(RenderContext context) {
        if (this.values == null) {
            return null;
        }
        String value = null;
        for (ConditionalValue conditionValue : this.values) {
            if (!conditionValue.getCondition().matches(context)) continue;
            value = conditionValue.getValue();
        }
        if (value == null) {
            value = this.defaultValue;
        }
        if (value != null) {
            ExpressionEvaluator evaluator = context.getExpressionEvaluator();
            value = ObjectUtils.toString((Object)evaluator.evaluate(value, context.getExpressionContext()));
        }
        return value;
    }

    @Override
    public Serializable saveState() {
        Serializable[] states = null;
        if (this.values != null) {
            states = new Serializable[this.values.size()];
            int index = 0;
            for (ConditionalValue value : this.values) {
                Condition condition = value.getCondition();
                states[index++] = new Serializable[]{condition.getName(), condition.saveState(), value.getValue()};
            }
        }
        return new Serializable[]{super.saveState(), this.defaultValue, states};
    }

    @Override
    public void restoreState(Serializable state) {
        Serializable[] states = (Serializable[])state;
        super.restoreState(states[0]);
        this.defaultValue = (String)((Object)states[1]);
        Serializable[] conditionStates = (Serializable[])states[2];
        if (conditionStates == null) {
            this.values = null;
        } else {
            this.values = new LinkedList<ConditionalValue>();
            for (Serializable conditionState : conditionStates) {
                Serializable[] stateValues = (Serializable[])conditionState;
                Condition condition = this.conditionFactory.createCondition((String)((Object)stateValues[0]));
                condition.restoreState(stateValues[1]);
                this.values.add(new ConditionalValue(condition, (String)((Object)stateValues[2])));
            }
        }
    }

    @Override
    public void saveSettings(HierarchicalConfiguration configuration) {
        super.saveSettings(configuration);
        if (this.defaultValue != null) {
            configuration.setProperty("default", (Object)this.defaultValue);
        }
        if (this.values != null) {
            int index = 0;
            configuration.setProperty("conditions", (Object)"");
            SubnodeConfiguration configurations = configuration.configurationAt("conditions");
            for (ConditionalValue value : this.values) {
                String prefix = String.format("condition-property(%s)", index++);
                configurations.setProperty(prefix + ".condition", (Object)"");
                configurations.setProperty(prefix + ".value", (Object)value.getValue());
                SubnodeConfiguration conditionConfig = configurations.configurationAt(prefix + ".condition");
                value.getCondition().saveSettings((HierarchicalConfiguration)conditionConfig);
            }
        }
    }

    @Override
    public void restoreSettings(HierarchicalConfiguration configuration) {
        super.restoreSettings(configuration);
        this.defaultValue = configuration.getString("default");
        this.values = new LinkedList<ConditionalValue>();
        try {
            List configurations = configuration.configurationsAt("conditions.condition-property");
            for (HierarchicalConfiguration propertyConfig : configurations) {
                String name = propertyConfig.getString("condition[@name]");
                Condition condition = this.conditionFactory.createCondition(name);
                condition.restoreSettings((HierarchicalConfiguration)propertyConfig.configurationAt("condition"));
                String value = propertyConfig.getString("value");
                this.values.add(new ConditionalValue(condition, value));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

