/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.condition;

import java.lang.reflect.Constructor;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.NullArgumentException;
import org.pivot4j.PivotException;
import org.pivot4j.ui.condition.AndCondition;
import org.pivot4j.ui.condition.AxisCondition;
import org.pivot4j.ui.condition.CellTypeCondition;
import org.pivot4j.ui.condition.CellValueCondition;
import org.pivot4j.ui.condition.Condition;
import org.pivot4j.ui.condition.ConditionFactory;
import org.pivot4j.ui.condition.ExpressionCondition;
import org.pivot4j.ui.condition.HierarchyCondition;
import org.pivot4j.ui.condition.LevelCondition;
import org.pivot4j.ui.condition.MemberCondition;
import org.pivot4j.ui.condition.NotCondition;
import org.pivot4j.ui.condition.OrCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConditionFactory
implements ConditionFactory {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, Class<? extends Condition>> types = new TreeMap<String, Class<? extends Condition>>();

    public DefaultConditionFactory() {
        this.types.put("and", AndCondition.class);
        this.types.put("or", OrCondition.class);
        this.types.put("not", NotCondition.class);
        this.types.put("expression", ExpressionCondition.class);
        this.types.put("axis", AxisCondition.class);
        this.types.put("hierarchy", HierarchyCondition.class);
        this.types.put("level", LevelCondition.class);
        this.types.put("member", MemberCondition.class);
        this.types.put("cellType", CellTypeCondition.class);
        this.types.put("cellValue", CellValueCondition.class);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public List<String> getAvailableConditions() {
        return new LinkedList<String>(this.types.keySet());
    }

    @Override
    public Condition createCondition(String name) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        Condition condition = null;
        Class<? extends Condition> type = this.types.get(name);
        if (type != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Instantiating a new condition : {}", type);
            }
            try {
                Constructor<? extends Condition> constructor = type.getConstructor(ConditionFactory.class);
                condition = constructor.newInstance(this);
            }
            catch (Exception e) {
                throw new PivotException(e);
            }
        }
        if (condition == null && this.logger.isWarnEnabled()) {
            this.logger.warn("Unknown condition name : {}", (Object)name);
        }
        return condition;
    }
}

