/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.condition;

import java.io.Serializable;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang.ObjectUtils;
import org.olap4j.Axis;
import org.pivot4j.ui.RenderContext;
import org.pivot4j.ui.condition.AbstractCondition;
import org.pivot4j.ui.condition.ConditionFactory;

public class AxisCondition
extends AbstractCondition {
    public static final String NAME = "axis";
    private Axis axis;

    public AxisCondition(ConditionFactory conditionFactory) {
        super(conditionFactory);
    }

    public AxisCondition(ConditionFactory conditionFactory, Axis axis) {
        super(conditionFactory);
        this.axis = axis;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public void setAxis(Axis axis) {
        this.axis = axis;
    }

    @Override
    public boolean matches(RenderContext context) {
        if (this.axis == null) {
            throw new IllegalStateException("Axis is not specified.");
        }
        return ObjectUtils.equals((Object)this.axis, (Object)context.getAxis());
    }

    @Override
    public Serializable saveState() {
        if (this.axis == null) {
            return null;
        }
        return this.axis.name();
    }

    @Override
    public void restoreState(Serializable state) {
        this.axis = state == null ? null : Axis.Standard.valueOf((String)((String)((Object)state)));
    }

    @Override
    public void saveSettings(HierarchicalConfiguration configuration) {
        super.saveSettings(configuration);
        if (this.axis == null) {
            return;
        }
        configuration.addProperty(NAME, (Object)this.axis.name());
    }

    @Override
    public void restoreSettings(HierarchicalConfiguration configuration) {
        String name = configuration.getString(NAME);
        this.axis = name == null ? null : Axis.Standard.valueOf((String)name);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("axis = '");
        if (this.axis != null) {
            builder.append(this.axis.name());
        }
        builder.append("'");
        return builder.toString();
    }
}

