/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.condition;

import java.io.Serializable;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.olap4j.Axis;
import org.olap4j.Position;
import org.olap4j.metadata.Member;
import org.pivot4j.ui.RenderContext;
import org.pivot4j.ui.condition.AbstractCondition;
import org.pivot4j.ui.condition.ConditionFactory;

public abstract class AbstractMetadataCondition
extends AbstractCondition {
    private String uniqueName;

    public AbstractMetadataCondition(ConditionFactory conditionFactory) {
        super(conditionFactory);
    }

    public AbstractMetadataCondition(ConditionFactory conditionFactory, String uniqueName) {
        super(conditionFactory);
        this.uniqueName = uniqueName;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    @Override
    public boolean matches(RenderContext context) {
        if (this.uniqueName == null) {
            throw new IllegalStateException("Unique name of the metadata is not specified.");
        }
        if (this.matches(context.getMember())) {
            return true;
        }
        for (Axis axis : context.getAxes()) {
            Position pos = context.getPosition(axis);
            if (pos == null || !this.matches(pos)) continue;
            return true;
        }
        return false;
    }

    protected boolean matches(Position position) {
        if (position == null) {
            return false;
        }
        boolean matches = false;
        for (Member member : position.getMembers()) {
            if (!this.matches(member)) continue;
            matches = true;
            break;
        }
        return matches;
    }

    protected abstract boolean matches(Member var1);

    @Override
    public Serializable saveState() {
        return this.uniqueName;
    }

    @Override
    public void restoreState(Serializable state) {
        if (state != null) {
            this.uniqueName = (String)((Object)state);
        }
    }

    @Override
    public void saveSettings(HierarchicalConfiguration configuration) {
        super.saveSettings(configuration);
        if (this.uniqueName == null) {
            return;
        }
        configuration.addProperty(this.getName(), (Object)this.uniqueName);
    }

    @Override
    public void restoreSettings(HierarchicalConfiguration configuration) {
        this.uniqueName = configuration.getString(this.getName());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName() + " = '");
        if (this.uniqueName != null) {
            builder.append(this.uniqueName);
        }
        builder.append("'");
        return builder.toString();
    }
}

