/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.command;

import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.Position;
import org.pivot4j.PivotModel;
import org.pivot4j.sort.SortMode;
import org.pivot4j.transform.SwapAxes;
import org.pivot4j.ui.PivotRenderer;
import org.pivot4j.ui.command.AbstractSortCommand;
import org.pivot4j.ui.command.UICommandParameters;

public class ToggleSortCommand
extends AbstractSortCommand {
    public static final String NAME = "sort";

    public ToggleSortCommand(PivotRenderer<?> renderer) {
        super(renderer);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Void execute(PivotModel model, UICommandParameters parameters) {
        CellSet cellSet = model.getCellSet();
        CellSetAxis axis = (CellSetAxis)cellSet.getAxes().get(parameters.getAxisOrdinal());
        CellSetAxis otherAxis = (CellSetAxis)cellSet.getAxes().get(Math.abs(parameters.getAxisOrdinal() - 1));
        SwapAxes transform = model.getTransform(SwapAxes.class);
        if (transform.isSwapAxes()) {
            CellSetAxis temp = axis;
            axis = otherAxis;
            otherAxis = temp;
        }
        Position position = (Position)axis.getPositions().get(parameters.getPositionOrdinal());
        SortMode mode = this.getRenderer().getSortMode();
        if (mode != null) {
            mode.toggleSort(model);
        }
        model.sort(otherAxis, position);
        return null;
    }
}

