/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.aggregator;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.ObjectUtils;
import org.olap4j.Axis;
import org.olap4j.Cell;
import org.olap4j.OlapException;
import org.olap4j.Position;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.MetadataElement;
import org.olap4j.metadata.Property;
import org.pivot4j.PivotException;
import org.pivot4j.ui.RenderContext;
import org.pivot4j.ui.aggregator.Aggregator;
import org.pivot4j.util.OlapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAggregator
implements Aggregator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Axis axis;
    private Level level;
    private Measure measure;
    private List<Member> members;
    private Map<Position, Double> values = new HashMap<Position, Double>();
    private Map<Position, Integer> counts = new HashMap<Position, Integer>();
    private Map<Measure, NumberFormat> formats = new HashMap<Measure, NumberFormat>();

    public AbstractAggregator(Axis axis, List<Member> members, Level level, Measure measure) {
        if (axis == null) {
            throw new NullArgumentException("axis");
        }
        this.axis = axis;
        this.members = members == null ? Collections.emptyList() : Collections.unmodifiableList(members);
        this.level = level;
        this.measure = measure;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public Axis getAxis() {
        return this.axis;
    }

    @Override
    public List<Member> getMembers() {
        return this.members;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public Measure getMeasure() {
        return this.measure;
    }

    @Override
    public void aggregate(RenderContext context) {
        Position targetPosition = context.getAggregationTarget(this.getAxis());
        Double cellValue = null;
        if (context.getCell() == null) {
            cellValue = context.getAggregator().getValue(context);
        } else if (context.getCell().isEmpty()) {
            cellValue = null;
        } else {
            try {
                cellValue = context.getCell().getDoubleValue();
            }
            catch (OlapException e) {
                throw new PivotException(e);
            }
        }
        if (cellValue == null) {
            return;
        }
        Double value = this.values.get(targetPosition);
        Double newValue = this.calculate(cellValue, value, targetPosition, context);
        this.values.put(targetPosition, newValue);
        int count = this.getCount(targetPosition);
        this.counts.put(targetPosition, ++count);
        Measure targetMeasure = this.getMeasure(targetPosition);
        if (targetMeasure != null && context.getCell() != null && !this.formats.containsKey(targetMeasure)) {
            this.formats.put(targetMeasure, this.getNumberFormat(context.getCell()));
        }
        if (this.members.isEmpty() && this.logger.isTraceEnabled()) {
            this.logger.trace("Calculation result : ");
            this.logger.trace("\t- count : {}", (Object)count);
            this.logger.trace("\t- value : {}", (Object)cellValue);
            this.logger.trace("\t- old value : {}", (Object)value);
            this.logger.trace("\t- new value : {}", (Object)newValue);
        }
    }

    protected Measure getMeasure(Position position) {
        if (this.measure != null) {
            return this.measure;
        }
        Measure targetMeasure = null;
        int size = position.getMembers().size();
        for (int i = size - 1; i > -1; --i) {
            Member member = (Member)position.getMembers().get(i);
            if (!(member instanceof Measure)) continue;
            targetMeasure = (Measure)member;
            break;
        }
        return targetMeasure;
    }

    protected NumberFormat getNumberFormat(Cell cell) {
        NumberFormat format;
        block4: {
            format = null;
            String pattern = ObjectUtils.toString((Object)cell.getPropertyValue((Property)Property.StandardCellProperty.FORMAT_STRING));
            if (pattern != null && !"Standard".equals(pattern)) {
                try {
                    format = new DecimalFormat(pattern);
                }
                catch (IllegalArgumentException e) {
                    if (!this.logger.isWarnEnabled()) break block4;
                    this.logger.warn("Illegal number format : {}", (Object)pattern);
                }
            }
        }
        if (format == null) {
            format = DecimalFormat.getNumberInstance();
        }
        return format;
    }

    protected NumberFormat getNumberFormat(Position position) {
        Measure measureAtPosition = this.getMeasure(position);
        if (measureAtPosition == null) {
            return null;
        }
        return this.formats.get(measureAtPosition);
    }

    protected int getCount(Position position) {
        Integer count = this.counts.get(position);
        if (count == null) {
            count = 0;
        }
        return count;
    }

    @Override
    public Double getValue(RenderContext context) {
        Position targetPosition = context.getAggregationTarget(this.getAxis());
        return this.getValue(targetPosition);
    }

    protected Double getValue(Position position) {
        return this.values.get(position);
    }

    @Override
    public String getFormattedValue(RenderContext context) {
        Position position = context.getAggregationTarget(this.getAxis());
        Double value = this.getValue(position);
        NumberFormat format = this.getNumberFormat(position);
        if (value == null) {
            return null;
        }
        if (format == null) {
            return Double.toString(value);
        }
        return format.format(value);
    }

    @Override
    public String getLabel(RenderContext context) {
        if (this.measure != null && OlapUtils.equals((MetadataElement)this.measure, (MetadataElement)context.getMember())) {
            return this.measure.getCaption();
        }
        return this.getAggregationLabel(context);
    }

    protected String getAggregationLabel(RenderContext context) {
        ResourceBundle resources = context.getResourceBundle();
        String label = null;
        if (resources != null) {
            label = resources.getString("label.aggregation.type." + this.getName());
        }
        return label;
    }

    @Override
    public void reset() {
        this.values.clear();
        this.counts.clear();
    }

    protected abstract Double calculate(Double var1, Double var2, Position var3, RenderContext var4);
}

