/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.NullArgumentException;
import org.olap4j.Axis;
import org.olap4j.Position;
import org.pivot4j.PivotModel;
import org.pivot4j.el.ExpressionContext;
import org.pivot4j.ui.PivotRenderer;
import org.pivot4j.ui.RenderContext;

public abstract class CartesianRenderContext
extends RenderContext {
    private static List<Axis> AXES = Collections.unmodifiableList(Arrays.asList(Axis.COLUMNS, Axis.ROWS));
    private Position columnPosition;
    private Position rowPosition;

    public CartesianRenderContext(PivotModel model, PivotRenderer<?> renderer) {
        super(model, renderer);
    }

    @Override
    public List<Axis> getAxes() {
        return AXES;
    }

    @Override
    public Position getAggregationTarget(Axis axis) {
        if (axis == null) {
            throw new NullArgumentException("axis");
        }
        if (axis.equals(Axis.COLUMNS)) {
            return this.rowPosition;
        }
        if (axis.equals(Axis.ROWS)) {
            return this.columnPosition;
        }
        return null;
    }

    public Position getColumnPosition() {
        return this.columnPosition;
    }

    public void setColumnPosition(Position columnPosition) {
        this.columnPosition = columnPosition;
    }

    public Position getRowPosition() {
        return this.rowPosition;
    }

    public void setRowPosition(Position rowPosition) {
        this.rowPosition = rowPosition;
    }

    @Override
    public Position getPosition(Axis axis) {
        if (axis == Axis.COLUMNS) {
            return this.columnPosition;
        }
        if (axis == Axis.ROWS) {
            return this.rowPosition;
        }
        return null;
    }

    @Override
    protected ExpressionContext createExpressionContext(PivotModel model) {
        ExpressionContext context = super.createExpressionContext(model);
        context.put("columnPosition", new ExpressionContext.ValueBinding<Position>(){

            @Override
            public Position getValue() {
                return CartesianRenderContext.this.getColumnPosition();
            }
        });
        context.put("rowPosition", new ExpressionContext.ValueBinding<Position>(){

            @Override
            public Position getValue() {
                return CartesianRenderContext.this.getRowPosition();
            }
        });
        return context;
    }
}

