/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.LogFactory;
import org.olap4j.Axis;
import org.pivot4j.sort.SortMode;
import org.pivot4j.ui.PivotRenderer;
import org.pivot4j.ui.RenderCallback;
import org.pivot4j.ui.RenderContext;
import org.pivot4j.ui.aggregator.AggregatorFactory;
import org.pivot4j.ui.aggregator.AggregatorPosition;
import org.pivot4j.ui.aggregator.DefaultAggregatorFactory;
import org.pivot4j.ui.collector.NonInternalPropertyCollector;
import org.pivot4j.ui.collector.PropertyCollector;
import org.pivot4j.ui.command.BasicDrillThroughCommand;
import org.pivot4j.ui.command.DrillCollapseMemberCommand;
import org.pivot4j.ui.command.DrillCollapsePositionCommand;
import org.pivot4j.ui.command.DrillDownReplaceCommand;
import org.pivot4j.ui.command.DrillExpandMemberCommand;
import org.pivot4j.ui.command.DrillExpandPositionCommand;
import org.pivot4j.ui.command.DrillUpReplaceCommand;
import org.pivot4j.ui.command.ToggleSortCommand;
import org.pivot4j.ui.command.UICommand;
import org.pivot4j.ui.condition.ConditionFactory;
import org.pivot4j.ui.condition.DefaultConditionFactory;
import org.pivot4j.ui.property.DefaultRenderPropertyList;
import org.pivot4j.ui.property.RenderPropertyList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPivotRenderer<T1 extends RenderContext, T2 extends RenderCallback<T1>>
implements PivotRenderer<T2> {
    private Map<String, UICommand<?>> commands = new HashMap();
    private boolean enableSort = true;
    private SortMode sortMode = SortMode.BASIC;
    private boolean enableDrillDown = true;
    private String drillDownMode = "position";
    private boolean enableDrillThrough = false;
    private boolean renderSlicer = false;
    private PropertyCollector propertyCollector;
    private ConditionFactory conditionFactory = new DefaultConditionFactory();
    private AggregatorFactory aggregatorFactory = new DefaultAggregatorFactory();
    private Map<AggregatorKey, List<String>> aggregatorNames = new HashMap<AggregatorKey, List<String>>();
    private Map<String, RenderPropertyList> renderProperties = new HashMap<String, RenderPropertyList>();

    public AbstractPivotRenderer() {
        this.registerCommands();
        this.initializeRenderProperties();
    }

    protected abstract String getLabel(T1 var1);

    protected abstract Double getValue(T1 var1);

    protected void registerCommands() {
        this.addCommand(new DrillExpandPositionCommand(this));
        this.addCommand(new DrillCollapsePositionCommand(this));
        this.addCommand(new DrillExpandMemberCommand(this));
        this.addCommand(new DrillCollapseMemberCommand(this));
        this.addCommand(new DrillDownReplaceCommand(this));
        this.addCommand(new DrillUpReplaceCommand(this));
        this.addCommand(new ToggleSortCommand(this));
        this.addCommand(new BasicDrillThroughCommand(this));
    }

    protected List<String> getRenderPropertyCategories() {
        return Collections.emptyList();
    }

    protected void initializeRenderProperties() {
        this.renderProperties.clear();
        if (this.conditionFactory != null) {
            for (String category : this.getRenderPropertyCategories()) {
                this.renderProperties.put(category, new DefaultRenderPropertyList(this.conditionFactory));
            }
        }
    }

    @Override
    public UICommand<?> getCommand(String name) {
        return this.commands.get(name);
    }

    @Override
    public void addCommand(UICommand<?> command) {
        this.commands.put(command.getName(), command);
    }

    @Override
    public void removeCommand(String name) {
        this.commands.remove(name);
    }

    protected List<UICommand<?>> getCommands(T1 context) {
        ArrayList availableCommands = new ArrayList(this.commands.size());
        for (UICommand<?> command : this.commands.values()) {
            if (!command.canExecute((RenderContext)context)) continue;
            availableCommands.add(command);
        }
        return availableCommands;
    }

    @Override
    public SortMode getSortMode() {
        return this.sortMode;
    }

    @Override
    public void setSortMode(SortMode sortMode) {
        this.sortMode = sortMode;
    }

    @Override
    public String getDrillDownMode() {
        return this.drillDownMode;
    }

    @Override
    public void setDrillDownMode(String drillDownMode) {
        this.drillDownMode = drillDownMode;
    }

    @Override
    public boolean getEnableDrillDown() {
        return this.enableDrillDown;
    }

    @Override
    public void setEnableDrillDown(boolean enableDrillDown) {
        this.enableDrillDown = enableDrillDown;
    }

    @Override
    public boolean getEnableSort() {
        return this.enableSort;
    }

    @Override
    public void setEnableSort(boolean enableSort) {
        this.enableSort = enableSort;
    }

    @Override
    public boolean getEnableDrillThrough() {
        return this.enableDrillThrough;
    }

    @Override
    public void setEnableDrillThrough(boolean enableDrillThrough) {
        this.enableDrillThrough = enableDrillThrough;
    }

    @Override
    public boolean getRenderSlicer() {
        return this.renderSlicer;
    }

    @Override
    public void setRenderSlicer(boolean renderSlicer) {
        this.renderSlicer = renderSlicer;
    }

    @Override
    public PropertyCollector getPropertyCollector() {
        return this.propertyCollector;
    }

    @Override
    public void setPropertyCollector(PropertyCollector propertyCollector) {
        this.propertyCollector = propertyCollector;
    }

    @Override
    public AggregatorFactory getAggregatorFactory() {
        return this.aggregatorFactory;
    }

    public void setAggregatorFactory(AggregatorFactory aggregatorFactory) {
        this.aggregatorFactory = aggregatorFactory;
    }

    @Override
    public List<String> getAggregators(Axis axis, AggregatorPosition position) {
        if (axis == null) {
            throw new NullArgumentException("axis");
        }
        if (position == null) {
            throw new NullArgumentException("position");
        }
        List<String> names = this.aggregatorNames.get(new AggregatorKey(axis, position));
        if (names == null) {
            names = Collections.emptyList();
        }
        return names;
    }

    @Override
    public void addAggregator(Axis axis, AggregatorPosition position, String name) {
        if (axis == null) {
            throw new NullArgumentException("axis");
        }
        if (position == null) {
            throw new NullArgumentException("position");
        }
        if (name == null) {
            throw new NullArgumentException("name");
        }
        AggregatorKey key = new AggregatorKey(axis, position);
        List<String> names = this.aggregatorNames.get(key);
        if (names == null) {
            names = new ArrayList<String>();
            this.aggregatorNames.put(key, names);
        }
        if (!names.contains(name)) {
            names.add(name);
        }
    }

    @Override
    public void removeAggregator(Axis axis, AggregatorPosition position, String name) {
        if (axis == null) {
            throw new NullArgumentException("axis");
        }
        if (position == null) {
            throw new NullArgumentException("position");
        }
        if (name == null) {
            throw new NullArgumentException("name");
        }
        AggregatorKey key = new AggregatorKey(axis, position);
        List<String> names = this.aggregatorNames.get(key);
        if (names != null) {
            names.remove(name);
        }
    }

    @Override
    public void setAggregators(Axis axis, AggregatorPosition position, List<String> names) {
        if (axis == null) {
            throw new NullArgumentException("axis");
        }
        if (position == null) {
            throw new NullArgumentException("position");
        }
        AggregatorKey key = new AggregatorKey(axis, position);
        if (names == null || names.isEmpty()) {
            this.aggregatorNames.remove(key);
        } else {
            this.aggregatorNames.put(key, names);
        }
    }

    public ConditionFactory getConditionFactory() {
        return this.conditionFactory;
    }

    public void setConditionFactory(ConditionFactory conditionFactory) {
        this.conditionFactory = conditionFactory;
    }

    @Override
    public Map<String, RenderPropertyList> getRenderProperties() {
        return this.renderProperties;
    }

    protected String getRenderPropertyCategory(T1 context) {
        return null;
    }

    @Override
    public Serializable saveState() {
        Serializable[] states = new Serializable[9];
        int index = 0;
        states[index++] = Boolean.valueOf(this.enableDrillDown);
        states[index++] = this.drillDownMode;
        states[index++] = Boolean.valueOf(this.enableSort);
        states[index++] = this.sortMode;
        states[index++] = Boolean.valueOf(this.enableDrillThrough);
        states[index++] = Boolean.valueOf(this.renderSlicer);
        states[index++] = (Serializable)((Object)this.aggregatorNames);
        HashMap<String, Serializable> propertyState = new HashMap<String, Serializable>(this.renderProperties.size());
        for (String category : this.getRenderPropertyCategories()) {
            RenderPropertyList properties = this.renderProperties.get(category);
            if (properties == null) continue;
            propertyState.put(category, properties.saveState());
        }
        states[index++] = propertyState;
        states[index++] = this.propertyCollector instanceof Serializable ? (Serializable)((Object)this.propertyCollector) : null;
        return states;
    }

    @Override
    public void restoreState(Serializable state) {
        Serializable collectorState;
        if (state == null) {
            throw new NullArgumentException("state");
        }
        Serializable[] states = (Serializable[])state;
        int index = 0;
        this.enableDrillDown = (Boolean)states[index++];
        this.drillDownMode = (String)((Object)states[index++]);
        this.enableSort = (Boolean)states[index++];
        this.sortMode = (SortMode)states[index++];
        this.enableDrillThrough = (Boolean)states[index++];
        this.renderSlicer = (Boolean)states[index++];
        this.aggregatorNames = (Map)((Object)states[index++]);
        this.initializeRenderProperties();
        Map propertyStates = (Map)((Object)states[index++]);
        for (String category : this.getRenderPropertyCategories()) {
            RenderPropertyList properties = this.renderProperties.get(category);
            Serializable propertyState = (Serializable)propertyStates.get(category);
            if (properties == null || propertyState == null) continue;
            properties.restoreState(propertyState);
        }
        this.propertyCollector = (collectorState = states[index++]) instanceof PropertyCollector ? (PropertyCollector)((Object)collectorState) : null;
    }

    @Override
    public void saveSettings(HierarchicalConfiguration configuration) {
        if (configuration == null) {
            throw new NullArgumentException("configuration");
        }
        configuration.setDelimiterParsingDisabled(true);
        if (configuration.getLogger() == null) {
            configuration.setLogger(LogFactory.getLog(this.getClass()));
        }
        configuration.addProperty("drillDown[@mode]", (Object)this.drillDownMode);
        configuration.addProperty("drillDown[@enabled]", (Object)this.enableDrillDown);
        configuration.addProperty("sort[@enabled]", (Object)this.enableSort);
        if (this.sortMode != null) {
            configuration.addProperty("sort[@mode]", (Object)this.sortMode.getName());
        }
        configuration.addProperty("drillThrough[@enabled]", (Object)this.enableDrillThrough);
        if (!this.aggregatorNames.isEmpty()) {
            int index = 0;
            for (AggregatorKey key : this.aggregatorNames.keySet()) {
                Axis axis = key.getAxis();
                AggregatorPosition position = key.getPosition();
                List<String> names = this.aggregatorNames.get(key);
                for (String name : names) {
                    configuration.addProperty(String.format("aggregations.aggregation(%s)[@name]", index), (Object)name);
                    configuration.addProperty(String.format("aggregations.aggregation(%s)[@axis]", index), (Object)axis.name());
                    configuration.addProperty(String.format("aggregations.aggregation(%s)[@position]", index), (Object)position.name());
                    ++index;
                }
            }
        }
        for (String category : this.renderProperties.keySet()) {
            RenderPropertyList properties = this.renderProperties.get(category);
            if (properties == null) continue;
            String propertyConfigName = "properties." + category;
            configuration.addProperty(propertyConfigName, (Object)"");
            properties.saveSettings((HierarchicalConfiguration)configuration.configurationAt(propertyConfigName));
        }
        configuration.addProperty("filter[@visible]", (Object)this.renderSlicer);
    }

    @Override
    public void restoreSettings(HierarchicalConfiguration configuration) {
        if (configuration == null) {
            throw new NullArgumentException("configuration");
        }
        this.drillDownMode = configuration.getString("drillDown[@mode]", "position");
        this.enableDrillDown = configuration.getBoolean("drillDown[@enabled]", true);
        this.enableSort = configuration.getBoolean("sort[@enabled]", true);
        String sortModeName = configuration.getString("sort[@mode]", SortMode.BASIC.getName());
        this.sortMode = SortMode.fromName(sortModeName);
        if (this.sortMode == null) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            if (logger.isWarnEnabled()) {
                logger.warn("Ignoring unknown sort mode name : {}", (Object)sortModeName);
            }
            this.sortMode = SortMode.BASIC;
        }
        this.enableDrillThrough = configuration.getBoolean("drillThrough[@enabled]", false);
        List aggregationSettings = configuration.configurationsAt("aggregations.aggregation");
        this.aggregatorNames.clear();
        for (HierarchicalConfiguration aggConfig : aggregationSettings) {
            AggregatorPosition position;
            String name = aggConfig.getString("[@name]");
            if (name == null) continue;
            Axis.Standard axis = Axis.Standard.valueOf((String)aggConfig.getString("[@axis]"));
            AggregatorKey key = new AggregatorKey((Axis)axis, position = AggregatorPosition.valueOf(aggConfig.getString("[@position]")));
            List<String> names = this.aggregatorNames.get(key);
            if (names == null) {
                names = new LinkedList<String>();
                this.aggregatorNames.put(key, names);
            }
            if (names.contains(name)) continue;
            names.add(name);
        }
        this.initializeRenderProperties();
        for (String category : this.getRenderPropertyCategories()) {
            RenderPropertyList properties = this.renderProperties.get(category);
            if (properties == null) continue;
            try {
                properties.restoreSettings((HierarchicalConfiguration)configuration.configurationAt("properties." + category));
            }
            catch (IllegalArgumentException e) {}
        }
        this.renderSlicer = configuration.getBoolean("filter[@visible]", false);
        String collectorType = configuration.getString("propertyCollector[@type]");
        this.propertyCollector = "non-internal".equalsIgnoreCase(collectorType) ? new NonInternalPropertyCollector() : null;
    }

    static class AggregatorKey
    implements Serializable {
        private static final long serialVersionUID = 4244611391569825053L;
        private Axis axis;
        private AggregatorPosition position;

        AggregatorKey() {
        }

        AggregatorKey(Axis axis, AggregatorPosition position) {
            if (axis == null) {
                throw new NullArgumentException("axis");
            }
            if (position == null) {
                throw new NullArgumentException("position");
            }
            this.axis = axis;
            this.position = position;
        }

        Axis getAxis() {
            return this.axis;
        }

        AggregatorPosition getPosition() {
            return this.position;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.axis).append((Object)this.position).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AggregatorKey otherKey = (AggregatorKey)obj;
            return this.axis == otherKey.axis && this.position == otherKey.position;
        }
    }
}

