/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.transform.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.olap4j.Axis;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.Position;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.MetadataElement;
import org.pivot4j.PivotException;
import org.pivot4j.impl.Quax;
import org.pivot4j.impl.QueryAdapter;
import org.pivot4j.mdx.Exp;
import org.pivot4j.mdx.FunCall;
import org.pivot4j.mdx.Syntax;
import org.pivot4j.mdx.metadata.MemberExp;
import org.pivot4j.transform.AbstractTransform;
import org.pivot4j.transform.PlaceHierarchiesOnAxes;
import org.pivot4j.transform.PlaceLevelsOnAxes;
import org.pivot4j.transform.PlaceMembersOnAxes;
import org.pivot4j.util.OlapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaceLevelsOnAxesImpl
extends AbstractTransform
implements PlaceLevelsOnAxes {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public PlaceLevelsOnAxesImpl(QueryAdapter queryAdapter, OlapConnection connection) {
        super(queryAdapter, connection);
    }

    @Override
    public void placeLevels(Axis axis, List<Level> levels) {
        try {
            QueryAdapter adapter = this.getQueryAdapter();
            Quax quax = adapter.getQuax(axis);
            if (quax == null) {
                quax = adapter.createQuax(axis);
            }
            ArrayList<Hierarchy> hierarchies = new ArrayList<Hierarchy>(levels.size());
            HashMap<Hierarchy, ArrayList<Member>> memberMap = new HashMap<Hierarchy, ArrayList<Member>>(hierarchies.size());
            for (Level level : levels) {
                Hierarchy hierarchy = level.getHierarchy();
                List members = level.getMembers();
                for (Member member : members) {
                    ArrayList<Member> selection;
                    if (!hierarchies.contains(hierarchy)) {
                        hierarchies.add(hierarchy);
                    }
                    if ((selection = (ArrayList<Member>)memberMap.get(hierarchy)) == null) {
                        selection = new ArrayList<Member>(members.size());
                        memberMap.put(hierarchy, selection);
                    }
                    if (selection.contains(member)) continue;
                    selection.add(member);
                }
            }
            OlapUtils utils = new OlapUtils(this.getModel().getCube());
            utils.setMemberHierarchyCache(this.getQueryAdapter().getModel().getMemberHierarchyCache());
            ArrayList<Exp> expressions = new ArrayList<Exp>(hierarchies.size());
            for (Hierarchy hierarchy : hierarchies) {
                List selection = (List)memberMap.get(hierarchy);
                ArrayList<Exp> sets = new ArrayList<Exp>(selection.size());
                if (selection.size() == 1) {
                    expressions.add(new MemberExp(utils.wrapRaggedIfNecessary((Member)selection.get(0))));
                    continue;
                }
                for (Member member : selection) {
                    sets.add(new MemberExp(utils.wrapRaggedIfNecessary(member)));
                }
                expressions.add(new FunCall("{}", Syntax.Braces, sets));
            }
            quax.regeneratePosTree(expressions, true);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("setQueryAxis axis={}, nDimension={}", (Object)quax.getOrdinal(), (Object)hierarchies.size());
                this.logger.debug("Expression for the axis : ", (Object)quax);
            }
        }
        catch (OlapException e) {
            throw new PivotException(e);
        }
    }

    @Override
    public void addLevel(Axis axis, Level level, int position) {
        PlaceHierarchiesOnAxes hierarchyTransform = this.getQueryAdapter().getModel().getTransform(PlaceHierarchiesOnAxes.class);
        List<Hierarchy> hierarchies = hierarchyTransform.findVisibleHierarchies(axis);
        PlaceMembersOnAxes membersTransform = this.getQueryAdapter().getModel().getTransform(PlaceMembersOnAxes.class);
        Hierarchy hierarchy = level.getHierarchy();
        if (hierarchies.contains(hierarchy)) {
            try {
                membersTransform.addMembers(hierarchy, level.getMembers());
            }
            catch (OlapException e) {
                throw new PivotException(e);
            }
        }
        hierarchies = new ArrayList<Hierarchy>(hierarchies);
        if (position < 0 || position >= hierarchies.size()) {
            hierarchies.add(hierarchy);
        } else {
            hierarchies.add(position, hierarchy);
        }
        ArrayList<Member> selection = new ArrayList<Member>();
        for (Hierarchy hier : hierarchies) {
            List members;
            selection.addAll(membersTransform.findVisibleMembers(hier));
            if (!OlapUtils.equals((MetadataElement)hier, (MetadataElement)hierarchy)) continue;
            try {
                members = level.getMembers();
            }
            catch (OlapException e) {
                throw new PivotException(e);
            }
            for (Member member : members) {
                if (selection.contains(member)) continue;
                selection.add(member);
            }
        }
        membersTransform.placeMembers(axis, selection);
    }

    @Override
    public void removeLevel(Axis axis, Level level) {
        PlaceMembersOnAxes transform = this.getQueryAdapter().getModel().getTransform(PlaceMembersOnAxes.class);
        List<Member> members = transform.findVisibleMembers(level.getHierarchy());
        LinkedList<Member> membersToRemove = new LinkedList<Member>();
        for (Member member : members) {
            if (!OlapUtils.equals((MetadataElement)level, (MetadataElement)member.getLevel())) continue;
            membersToRemove.add(member);
        }
        for (Member member : membersToRemove) {
            members.remove(member);
        }
        transform.placeMembers(level.getHierarchy(), members);
    }

    @Override
    public List<Level> findVisibleLevels(Axis axis) {
        ArrayList<Level> visibleLevels = new ArrayList<Level>();
        QueryAdapter adapter = this.getQueryAdapter();
        CellSet cellSet = adapter.getModel().getCellSet();
        CellSetAxis cellAxis = this.getCellSetAxis(cellSet, axis);
        if (cellAxis == null) {
            return Collections.emptyList();
        }
        List positions = cellAxis.getPositions();
        if (positions.isEmpty()) {
            return Collections.emptyList();
        }
        int size = ((Position)positions.get(0)).getMembers().size();
        for (int i = 0; i < size; ++i) {
            for (Position position : positions) {
                Member member = (Member)position.getMembers().get(i);
                if (visibleLevels.contains(member.getLevel())) continue;
                visibleLevels.add(member.getLevel());
            }
        }
        return visibleLevels;
    }

    @Override
    public List<Level> findVisibleLevels(Hierarchy hierarchy) {
        PlaceMembersOnAxes transform = this.getQueryAdapter().getModel().getTransform(PlaceMembersOnAxes.class);
        List<Member> members = transform.findVisibleMembers(hierarchy);
        ArrayList<Level> visibleLevels = new ArrayList<Level>(members.size());
        for (Member member : members) {
            if (visibleLevels.contains(member.getLevel())) continue;
            visibleLevels.add(member.getLevel());
        }
        return visibleLevels;
    }
}

