/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.transform.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.olap4j.Axis;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.NamedList;
import org.pivot4j.PivotException;
import org.pivot4j.PivotModel;
import org.pivot4j.impl.Quax;
import org.pivot4j.impl.QueryAdapter;
import org.pivot4j.mdx.Exp;
import org.pivot4j.mdx.FunCall;
import org.pivot4j.mdx.Syntax;
import org.pivot4j.mdx.metadata.MemberExp;
import org.pivot4j.transform.AbstractTransform;
import org.pivot4j.transform.PlaceHierarchiesOnAxes;
import org.pivot4j.util.OlapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaceHierarchiesOnAxesImpl
extends AbstractTransform
implements PlaceHierarchiesOnAxes {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public PlaceHierarchiesOnAxesImpl(QueryAdapter queryAdapter, OlapConnection connection) {
        super(queryAdapter, connection);
    }

    @Override
    public void placeHierarchies(Axis axis, List<Hierarchy> hierarchies, boolean expandAllMember) {
        QueryAdapter adapter = this.getQueryAdapter();
        ArrayList<Exp> memberExpressions = new ArrayList<Exp>();
        for (Hierarchy hierarchy : hierarchies) {
            memberExpressions.add(this.createMemberExpression(hierarchy, expandAllMember));
        }
        Quax quax = adapter.getQuax(axis);
        if (quax == null) {
            quax = adapter.createQuax(axis);
        }
        int nDimension = 0;
        for (Exp memberExpression : memberExpressions) {
            if (memberExpression == null) continue;
            ++nDimension;
        }
        ArrayList<Exp> sets = new ArrayList<Exp>(nDimension);
        for (Exp memberExpression : memberExpressions) {
            if (memberExpressions == null) continue;
            sets.add(memberExpression);
        }
        quax.regeneratePosTree(sets, true);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("setQueryAxis axis={}, nDimension={}", (Object)quax.getOrdinal(), (Object)nDimension);
            this.logger.debug("Expression for the axis : ", (Object)quax);
        }
    }

    @Override
    public void addHierarchy(Axis axis, Hierarchy hierarchy, boolean expandAllMember, int position) {
        List<Hierarchy> hierarchies = this.findVisibleHierarchies(axis);
        if (hierarchies.contains(hierarchy)) {
            this.moveHierarchy(axis, hierarchy, position);
            return;
        }
        hierarchies = new ArrayList<Hierarchy>(hierarchies);
        if (position < 0 || position >= hierarchies.size()) {
            hierarchies.add(hierarchy);
        } else {
            hierarchies.add(position, hierarchy);
        }
        this.placeHierarchies(axis, hierarchies, expandAllMember);
    }

    @Override
    public void moveHierarchy(Axis axis, Hierarchy hierarchy, int position) {
        List<Hierarchy> hierarchies = this.findVisibleHierarchies(axis);
        if (!hierarchies.contains(hierarchy)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("The specified axis does not contain the hierarhcy to be moved.");
            }
            return;
        }
        hierarchies = new ArrayList<Hierarchy>(hierarchies);
        if (position < 0 || position >= hierarchies.size()) {
            hierarchies.remove(hierarchy);
            hierarchies.add(hierarchy);
        } else {
            int index = hierarchies.indexOf(hierarchy);
            if (position < index) {
                hierarchies.remove(hierarchy);
                hierarchies.add(position, hierarchy);
            } else if (position > index) {
                hierarchies.add(position, hierarchy);
                hierarchies.remove(index);
            }
        }
        this.placeHierarchies(axis, hierarchies, false);
    }

    @Override
    public void removeHierarchy(Axis axis, Hierarchy hierarchy) {
        List<Hierarchy> hierarchies = this.findVisibleHierarchies(axis);
        if (!hierarchies.contains(hierarchy)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("The specified axis does not contain the hierarhcy to be moved.");
            }
            return;
        }
        hierarchies = new ArrayList<Hierarchy>(hierarchies);
        hierarchies.remove(hierarchy);
        this.placeHierarchies(axis, hierarchies, false);
    }

    @Override
    public List<Hierarchy> findVisibleHierarchies(Axis axis) {
        QueryAdapter adapter = this.getQueryAdapter();
        Quax quax = adapter.getQuax(axis);
        if (quax == null) {
            return Collections.emptyList();
        }
        return quax.getHierarchies();
    }

    protected Exp createMemberExpression(Hierarchy hierarchy, boolean expandAllMember) {
        QueryAdapter adapter = this.getQueryAdapter();
        Quax quax = adapter.findQuax(hierarchy.getDimension());
        if (quax == null) {
            adapter.getCurrentMdx(true);
            return this.topLevelMembers(hierarchy, expandAllMember);
        }
        int iDimension = quax.dimIdx(hierarchy.getDimension());
        return quax.genExpForDim(iDimension);
    }

    protected Exp topLevelMembers(Hierarchy hierarchy, boolean expandAllMember) {
        try {
            NamedList topMembers;
            int size;
            if (hierarchy.hasAll()) {
                Member allMember = hierarchy.getDefaultMember();
                if (allMember == null || !allMember.isAll()) {
                    allMember = null;
                    NamedList topMembers2 = hierarchy.getRootMembers();
                    for (Member member : topMembers2) {
                        if (!member.isAll()) continue;
                        allMember = member;
                        break;
                    }
                }
                if (allMember != null && OlapUtils.isVisible(allMember)) {
                    PivotModel model = this.getModel();
                    OlapUtils utils = new OlapUtils(model.getCube());
                    utils.setMemberHierarchyCache(this.getQueryAdapter().getModel().getMemberHierarchyCache());
                    if (!expandAllMember) {
                        return new MemberExp(utils.wrapRaggedIfNecessary(allMember));
                    }
                    MemberExp allExp = new MemberExp(allMember);
                    FunCall allSet = new FunCall("{}", Syntax.Braces);
                    allSet.getArgs().add(allExp);
                    FunCall mAllChildren = new FunCall("Children", Syntax.Property);
                    mAllChildren.getArgs().add(allExp);
                    FunCall union = new FunCall("Union", Syntax.Function);
                    union.getArgs().add(allSet);
                    union.getArgs().add(mAllChildren);
                    return union;
                }
            }
            if ((size = (topMembers = hierarchy.getRootMembers()).size()) == 0) {
                return null;
            }
            Member firstMember = (Member)topMembers.get(0);
            if (topMembers.size() == 1 && OlapUtils.isVisible(firstMember)) {
                return new MemberExp(firstMember);
            }
            ArrayList<Exp> args = new ArrayList<Exp>(topMembers.size());
            for (Member member : topMembers) {
                if (member.isHidden() || !OlapUtils.isVisible(member)) continue;
                args.add(new MemberExp(member));
            }
            return new FunCall("{}", Syntax.Braces, args);
        }
        catch (OlapException e) {
            throw new PivotException(e);
        }
    }
}

