/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.mdx.metadata;

import org.olap4j.metadata.Cube;
import org.olap4j.metadata.MetadataElement;
import org.pivot4j.mdx.AbstractExp;
import org.pivot4j.mdx.metadata.MetadataExp;

public abstract class AbstractMetadataExp<T extends MetadataElement>
extends AbstractExp
implements MetadataExp<T> {
    private static final long serialVersionUID = 2577401208308436530L;
    private String name;
    private String uniqueName;
    private transient T element;

    public AbstractMetadataExp() {
    }

    public AbstractMetadataExp(String name, String uniqueName) {
        this.name = name;
        this.uniqueName = uniqueName;
    }

    public AbstractMetadataExp(T element) {
        this.setMetadata(element);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public T getMetadata(Cube cube) {
        if (this.element == null && this.uniqueName != null) {
            this.element = this.lookupMetadata(cube);
        }
        return this.element;
    }

    @Override
    public void setMetadata(T element) {
        this.element = element;
        if (element == null) {
            this.name = null;
            this.uniqueName = null;
        } else {
            this.name = element.getName();
            this.uniqueName = element.getUniqueName();
        }
    }

    protected abstract T lookupMetadata(Cube var1);

    @Override
    public String toMdx() {
        if (this.uniqueName == null) {
            return "";
        }
        return this.uniqueName;
    }

    public int hashCode() {
        if (this.uniqueName == null) {
            return super.hashCode();
        }
        return this.uniqueName.hashCode() * 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractMetadataExp other = (AbstractMetadataExp)obj;
        if (this.uniqueName == null) {
            return other.uniqueName == null;
        }
        return this.uniqueName.equals(other.uniqueName);
    }
}

