/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.mdx;

import java.util.ArrayList;
import java.util.List;
import org.pivot4j.mdx.AbstractExp;
import org.pivot4j.mdx.CompoundId;
import org.pivot4j.mdx.Exp;
import org.pivot4j.mdx.ExpVisitor;

public class SapVariable
extends AbstractExp {
    private static final long serialVersionUID = 6766264897810191295L;
    private CompoundId name;
    private List<Value> values = new ArrayList<Value>();

    public SapVariable() {
    }

    public SapVariable(CompoundId name) {
        this.name = name;
    }

    public CompoundId getName() {
        return this.name;
    }

    public void setName(CompoundId name) {
        this.name = name;
    }

    public List<Value> getValues() {
        return this.values;
    }

    @Override
    public String toMdx() {
        if (this.values.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (this.name != null) {
            builder.append(this.name.toMdx());
            builder.append(' ');
        }
        boolean first = true;
        for (Value value : this.values) {
            if (first) {
                first = false;
            } else {
                builder.append(' ');
            }
            builder.append(value.toMdx());
        }
        return builder.toString();
    }

    @Override
    public SapVariable copy() {
        SapVariable clone = new SapVariable();
        if (this.name != null) {
            clone.name = this.name.copy();
        }
        for (Value value : this.values) {
            clone.values.add(value.copy());
        }
        return clone;
    }

    @Override
    public void accept(ExpVisitor visitor) {
        visitor.visitSapVariable(this);
        if (this.name != null) {
            this.name.accept(visitor);
        }
        for (Value value : this.values) {
            value.accept(visitor);
        }
    }

    public static class Value
    extends AbstractExp {
        private static final long serialVersionUID = -5532029488482311594L;
        private Exp highValue;
        private Exp lowValue;
        private boolean including = true;
        private boolean interval = false;
        private String option;

        public Value() {
        }

        public Value(Exp value, boolean including, String option) {
            this.lowValue = value;
            this.including = including;
            this.interval = false;
            this.option = option;
        }

        public Value(Exp lowValue, Exp highValue, boolean including, String option) {
            this.lowValue = lowValue;
            this.highValue = highValue;
            this.including = including;
            this.interval = true;
            this.option = option;
        }

        public Exp getValue() {
            return this.getLowValue();
        }

        public Exp getHighValue() {
            return this.highValue;
        }

        public Exp getLowValue() {
            return this.lowValue;
        }

        public boolean isIncluding() {
            return this.including;
        }

        public boolean isInterval() {
            return this.interval;
        }

        public String getOption() {
            return this.option;
        }

        @Override
        public Value copy() {
            Value clone = new Value();
            if (this.highValue != null) {
                clone.highValue = this.highValue.copy();
            }
            if (this.lowValue != null) {
                clone.lowValue = this.lowValue.copy();
            }
            clone.including = this.including;
            clone.interval = this.interval;
            clone.option = this.option;
            return clone;
        }

        @Override
        public void accept(ExpVisitor visitor) {
            visitor.visitSapVariableValue(this);
            if (this.highValue != null) {
                this.highValue.accept(visitor);
            }
            if (this.lowValue != null) {
                this.lowValue.accept(visitor);
            }
        }

        @Override
        public String toMdx() {
            if (this.lowValue == null || this.isInterval() && this.highValue == null) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            if (this.isIncluding()) {
                builder.append("INCLUDING ");
            } else {
                builder.append("EXCLUDING ");
            }
            if (this.option != null) {
                builder.append(this.option);
                builder.append(' ');
            }
            builder.append(this.lowValue.toMdx());
            if (this.isInterval()) {
                builder.append(':');
                builder.append(this.highValue.toMdx());
            }
            return builder.toString();
        }
    }
}

